/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.input.DinosaurKeyHandler;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HypsilophodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroceratusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OthnieliaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.ai.LeapingMeleeEntityAI;
import net.vit.jurassicreborn.common.entities.ai.RaptorClimbTreeAI;
import net.vit.jurassicreborn.common.entities.ai.RaptorLeapEntityAI;
import net.vit.jurassicreborn.common.entities.ai.animations.BirdPreenAnimationAI;
import net.vit.jurassicreborn.common.entities.ai.animations.TailDisplayAnimationAI;
import net.vit.jurassicreborn.common.network.MicroraptorDismountMessage;
import net.vit.jurassicreborn.common.network.Network;

public class MicroraptorEntity
extends DinosaurEntity {
    private int flyTime;
    private int groundHeight;
    private Vec3 glidingPos;

    public MicroraptorEntity(EntityType<MicroraptorEntity> type, Level world) {
        super(world, type, DinosaurHandler.MICRORAPTOR);
        this.target(Chicken.class, Rabbit.class, CompsognathusEntity.class, HypsilophodonEntity.class, LeptictidiumEntity.class, MicroceratusEntity.class, OthnieliaEntity.class);
        this.addTask(1, (Goal)new LeapingMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
        this.addTask(2, new RaptorClimbTreeAI(this, 1.0));
        this.addTask(3, new BirdPreenAnimationAI(this));
        this.addTask(3, new TailDisplayAnimationAI(this));
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22277_, 35.0);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return !source.m_276093_(DamageTypes.f_268576_) && super.m_6469_(source, amount);
    }

    @Override
    public void m_8119_() {
        boolean climbing;
        super.m_8119_();
        Animation curAni = this.getAnimation();
        boolean bl = climbing = curAni == EntityAnimation.CLIMBING.get() || curAni == EntityAnimation.START_CLIMBING.get();
        if (climbing) {
            BlockPos trunk = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20191_().f_82289_, (double)this.m_20189_());
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (this.f_19853_.m_46859_(trunk.m_121945_(dir)) || !this.f_19853_.m_8055_(trunk.m_121945_(dir)).m_60796_((BlockGetter)this.f_19853_, trunk.m_121945_(dir))) continue;
                float yaw = dir.m_122435_();
                this.m_5616_(yaw);
                this.m_146922_(yaw);
                this.f_19859_ = yaw;
                this.f_20886_ = yaw;
                this.m_5618_(yaw);
                this.f_20884_ = yaw;
                this.f_19794_ = false;
                break;
            }
        }
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        double dist;
        float prevPitch = this.m_146909_();
        if (this.getAnimation() == EntityAnimation.GLIDING.get() && this.glidingPos != null && (dist = this.glidingPos.m_82554_(this.m_20182_())) > 1.0E-4) {
            double dy = (this.glidingPos.f_82480_ - this.m_20186_()) / dist;
            this.m_146926_((float)(-Math.toDegrees(Math.asin(Mth.m_14008_((double)dy, (double)-1.0, (double)1.0)))));
        }
        super.m_7023_(travelVector);
        this.m_146926_(prevPitch);
    }

    @Override
    public void m_8107_() {
        boolean leaping;
        Animation curAni;
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            this.updateClientControls();
        }
        boolean landing = (curAni = this.getAnimation()) == EntityAnimation.LEAP_LAND.get();
        boolean gliding = curAni == EntityAnimation.GLIDING.get();
        boolean climbing = curAni == EntityAnimation.CLIMBING.get() || curAni == EntityAnimation.START_CLIMBING.get();
        boolean bl = leaping = curAni == EntityAnimation.LEAP.get();
        if (this.m_20096_() || this.m_20069_() || this.m_20077_() || this.m_6069_()) {
            this.flyTime = 0;
            if (gliding || landing) {
                this.setAnimation(EntityAnimation.IDLE.get());
                this.m_20115_(7, false);
            }
        } else {
            ++this.flyTime;
            if (this.flyTime > 4 && !leaping) {
                if (!landing) {
                    if (!gliding) {
                        if (!climbing) {
                            this.setAnimation(EntityAnimation.GLIDING.get());
                        }
                    } else if (!this.f_19853_.m_46859_(this.m_20183_().m_7495_())) {
                        this.setAnimation(EntityAnimation.LEAP_LAND.get());
                    }
                }
                if (gliding) {
                    this.m_20115_(7, true);
                }
            }
        }
        if (this.m_21255_()) {
            this.groundHeight = 0;
            BlockPos pos = this.m_20183_();
            while (this.groundHeight <= 10 && !this.f_19853_.m_8055_(pos).m_60783_((BlockGetter)this.f_19853_, pos, Direction.UP)) {
                pos = pos.m_7495_();
                ++this.groundHeight;
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21563_().m_8128_();
        }
    }

    public Vec3 m_20154_() {
        if (this.getAnimation() == EntityAnimation.GLIDING.get() && this.glidingPos != null) {
            double d = this.glidingPos.m_82554_(this.m_20182_());
            if (d < 1.0E-6) {
                return super.m_20154_();
            }
            return new Vec3((this.glidingPos.f_82479_ - this.m_20185_()) / d, (this.glidingPos.f_82480_ - this.m_20186_()) / d, (this.glidingPos.f_82481_ - this.m_20189_()) / d);
        }
        return super.m_20154_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_6144_() && hand == InteractionHand.MAIN_HAND && this.isOwner(player) && this.order == DinosaurEntity.Order.SIT && player.m_20197_().size() < 2) {
            return this.m_7998_((Entity)player, true) ? InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_) : InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (this.getAnimation() == EntityAnimation.GLIDING.get() && slot == EquipmentSlot.CHEST) {
            return new ItemStack((ItemLike)Items.f_42741_);
        }
        return super.m_6844_(slot);
    }

    public Goal getAttackAI() {
        return new RaptorLeapEntityAI(this);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.getAnimation() != EntityAnimation.LEAP_LAND.get()) {
            return false;
        }
        return false;
    }

    protected WallClimberNavigation createNavigation(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.MICRORAPTOR_LIVING;
            }
            case DYING: {
                return SoundHandler.MICRORAPTOR_DEATH;
            }
            case INJURED: {
                return SoundHandler.MICRORAPTOR_HURT;
            }
            case ATTACKING: {
                return SoundHandler.MICRORAPTOR_ATTACK;
            }
            case CALLING: {
                return SoundHandler.MICRORAPTOR_LIVING;
            }
        }
        return null;
    }

    public int m_6056_() {
        return 100;
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        Entity riding = this.m_20202_();
        if (!this.m_20159_() || !(riding instanceof Player)) {
            return;
        }
        Player player = (Player)riding;
        int idx = riding.m_20197_().indexOf(this);
        if (player.m_21255_()) {
            this.m_8127_();
            return;
        }
        float radius = (idx == 2 ? 0.0f : 0.35f) + (player.m_21255_() ? 2.0f : 0.0f);
        float renderYawOffset = player.f_20883_;
        float add = idx == 1 ? -90.0f : (idx == 0 ? 90.0f : 0.0f);
        float angle = (float)Math.toRadians(renderYawOffset + add);
        double offsetX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double offsetZ = radius * Mth.m_14089_((float)angle);
        double offsetY = (player.m_6144_() ? 1.2 : 1.38) + (idx == 2 ? 0.4 : 0.0);
        this.m_6034_(riding.m_20185_() + offsetX, riding.m_20186_() + offsetY, riding.m_20189_() + offsetZ);
        float headYaw = player.m_6080_();
        this.m_146922_(headYaw);
        this.m_5616_(headYaw);
        this.f_19859_ = headYaw;
        this.setAnimation(EntityAnimation.IDLE.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        if (this.m_20202_() != null && this.m_20202_() == Minecraft.m_91087_().f_91074_ && DinosaurKeyHandler.MICRORAPTOR_DISMOUNT.m_90859_()) {
            Network.sendToServer(new MicroraptorDismountMessage(this.m_19879_()));
        }
    }

    @Override
    public boolean canDinoSwim() {
        return true;
    }

    @Override
    public boolean shouldEscapeWaterFast() {
        int radiusXZ = 4;
        BlockPos min = new BlockPos(Mth.m_14107_((double)(this.m_20185_() - (double)radiusXZ)), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)(this.m_20189_() - (double)radiusXZ)));
        BlockPos max = new BlockPos(Mth.m_14165_((double)(this.m_20185_() + (double)radiusXZ)), Mth.m_14165_((double)this.m_20186_()), Mth.m_14165_((double)(this.m_20189_() + (double)radiusXZ)));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            if (this.f_19853_.m_8055_(pos).m_60767_().m_76332_()) continue;
            return false;
        }
        return false;
    }

    public void setGlidingTo(Vec3 glidingPos) {
        this.glidingPos = glidingPos;
    }
}

