/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.client.JurassicClient;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.render.entity.animation.FixedChainBuffer;
import net.vit.jurassicreborn.client.render.entity.animation.PoseHandler;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.grinder.FossilGrinderBlockEntity;
import net.vit.jurassicreborn.common.entities.AdvancedSwimEntityAI;
import net.vit.jurassicreborn.common.entities.AmphibianDinosaurEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEggEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AchillobatorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlligatorGarEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AllosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlvarezsaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AnkylodocusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AnkylosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ApatosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ArsinoitheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AsterocerasEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BaryonyxEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BeelzebufoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BrachiosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CalymeneEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CamarasaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CamerocerasEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CarcharodontosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CarnotaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CearadactylusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CeratosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChasmosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ChilesaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CoelacanthEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CoelurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CorythosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CrassigyrinusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DeinosuchusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DeinotheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DilophosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DimetrodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DimorphodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DiplocaulusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DiplodocusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DodoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DreadnoughtusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DunkleosteusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.EdmontosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ElasmotheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.EndocerasEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GallimimusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GiganotosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GuanlongEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HerrerasaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HyaenodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HypsilophodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.IndominusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.IndoraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.KairukuEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LambeosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeaellynasauraEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LivyatanEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LudodactylusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MaiasauraEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MajungasaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MamenchisaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MammothEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MawsoniaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegalodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegapiranhaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegatheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MetriacanthosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroceratusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MoganopterusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MosasaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MussaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.NigersaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OrnithomimusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OrthocerasEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OthnieliaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.OviraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PachycephalosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ParaceratheriumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ParapuzosiaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ParasaurolophusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PatagotitanEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PerisphinctesEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PostosuchusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ProceratosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ProtoceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PteranodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.QuetzalEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.RaphusrexEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.RugopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SegisaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SinoceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SmilodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SpinoraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SpinosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.StegosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.StyracosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.SuchomimusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TherizinosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TitanisEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TitanitesEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TriceratopsEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TroodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TropeognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TylosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TyrannosaurusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VectipeltaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorBlueEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorCharlieEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorDeltaEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorEchoEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ZhenyuanopterusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurLookHelper;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.InventoryDinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.DinosaurAttributes;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;
import net.vit.jurassicreborn.common.entities.EntityUtils.MetabolismContainer;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.entities.EntityUtils.TaskHelper;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.Family;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.Herd;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.Relationship;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.SmartBodyHelper;
import net.vit.jurassicreborn.common.entities.EscapeWireEntityAI;
import net.vit.jurassicreborn.common.entities.IHasVariants;
import net.vit.jurassicreborn.common.entities.LegSolver;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.PenguinDinosaurEntity;
import net.vit.jurassicreborn.common.entities.RespondToAttackEntityAI;
import net.vit.jurassicreborn.common.entities.ai.AssistOwnerAI;
import net.vit.jurassicreborn.common.entities.ai.DefendOwnerAI;
import net.vit.jurassicreborn.common.entities.ai.DinosaurAttackMeleeEntityAI;
import net.vit.jurassicreborn.common.entities.ai.DinosaurWanderEntityAI;
import net.vit.jurassicreborn.common.entities.ai.FleeAI;
import net.vit.jurassicreborn.common.entities.ai.FollowOwnerAI;
import net.vit.jurassicreborn.common.entities.ai.MateEntityAI;
import net.vit.jurassicreborn.common.entities.ai.ProtectInfantAI;
import net.vit.jurassicreborn.common.entities.ai.SleepEntityAI;
import net.vit.jurassicreborn.common.entities.ai.TargetCarcassAI;
import net.vit.jurassicreborn.common.entities.ai.TemptNonAdultEntityAI;
import net.vit.jurassicreborn.common.entities.ai.animations.CallAnimationAI;
import net.vit.jurassicreborn.common.entities.ai.animations.HeadCockAnimationAI;
import net.vit.jurassicreborn.common.entities.ai.animations.LookAnimationAI;
import net.vit.jurassicreborn.common.entities.ai.animations.RoarAnimationAI;
import net.vit.jurassicreborn.common.entities.ai.metabolism.DrinkEntityAI;
import net.vit.jurassicreborn.common.entities.ai.metabolism.EatFoodItemEntityAI;
import net.vit.jurassicreborn.common.entities.ai.metabolism.FeederEntityAI;
import net.vit.jurassicreborn.common.entities.ai.metabolism.GrazeEntityAI;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurJumpHelper;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurMoveHelper;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurPathNavigate;
import net.vit.jurassicreborn.common.entities.ai.util.AIUtils;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscItem;
import net.vit.jurassicreborn.common.items.misc.DinosaurSpawnEggItem;
import net.vit.jurassicreborn.common.util.GameRuleHandler;
import net.vit.jurassicreborn.common.util.ItemsUtil;
import net.vit.jurassicreborn.common.util.api.DinosaurItem;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class DinosaurEntity
extends PathfinderMob
implements IEntityAdditionalSpawnData,
Animatable {
    private static final Logger LOGGER = LogManager.getLogManager().getLogger("global");
    private static final EntityDataAccessor<Boolean> WATCHER_IS_CARCASS = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WATCHER_AGE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WATCHER_IS_SLEEPING = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> TRACKER_UUIDS = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> WATCHER_OWNER_IDENTIFIER = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Byte> WATCHER_CURRENT_ORDER = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> WATCHER_IS_RUNNING = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WATCHER_WAS_FED = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WATCHER_WAS_MOVED = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public HashMap<Animation, Byte> variants = new HashMap();
    private InventoryDinosaur inventory;
    private MetabolismContainer metabolism;
    protected Dinosaur dinosaur;
    protected Order order = Order.WANDER;
    private boolean isCarcass;
    private boolean wasMoved;
    private boolean blocked;
    private boolean isMale;
    private boolean isSleeping;
    private boolean useInertialTweens;
    private boolean eatsEggs = false;
    private int carcassHealth;
    private int geneticsQuality;
    private int tranquilizerTicks;
    private int stayAwakeTime;
    private int growthSpeedOffset;
    protected int dinosaurAge;
    protected int prevAge;
    private UUID owner;
    private List<Class<? extends LivingEntity>> attackTargets = new ArrayList<Class<? extends LivingEntity>>();
    private String genetics;
    public boolean tranqed;
    private boolean goalsRegistered;
    private boolean deserializing;
    private int ticksUntilDeath;
    private int attackCooldown;
    @javax.annotation.Nullable
    private TaskHelper taskHelper;
    @OnlyIn(value=Dist.CLIENT)
    public FixedChainBuffer tailBuffer;
    public Herd herd;
    public Family family;
    public Set<Relationship> relationships = new HashSet<Relationship>();
    public int wireTicks;
    public int disableHerdingTicks;
    private boolean isSittingNaturally;
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private DinosaurLookHelper lookHelper;
    private BlockPos closestFeeder;
    private int feederSearchTick;
    private boolean inLava;
    private DinosaurAttributes attributes;
    private int breedCooldown;
    private DinosaurEntity breeding;
    private Set<DinosaurEntity> children = new HashSet<DinosaurEntity>();
    private int pregnantTime;
    private int jumpHeight;
    private final LegSolver legSolver;
    private boolean isSkeleton;
    private boolean animSyncInProgress = false;
    private byte skeletonVariant;
    private boolean isFossile;
    public boolean isRendered;
    private int moveTicks = -5;
    private int messageTick = 0;
    private int targetSearchCooldown;
    private final List<String> trackersUUID = new ArrayList<String>();
    public static final HashMap<Class<? extends DinosaurEntity>, RegistryObject<? extends EntityType<? extends DinosaurEntity>>> CLASS_TYPE_LIST = new HashMap();
    private static final int FEEDER_RANGE = 16;
    private static final int FEEDER_VERTICAL = 8;

    public List<UUID> getTrackers() {
        String data = (String)this.f_19804_.m_135370_(TRACKER_UUIDS);
        if (data == null || data.isEmpty()) {
            return new ArrayList<UUID>();
        }
        ArrayList<UUID> out = new ArrayList<UUID>();
        for (String s : data.split(";")) {
            try {
                out.add(UUID.fromString(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return out;
    }

    public void addTracker(UUID uuid) {
        List<UUID> uuids = this.getTrackers();
        if (!uuids.contains(uuid)) {
            uuids.add(uuid);
            this.setTrackers(uuids);
        }
    }

    public void setTrackers(List<UUID> uuids) {
        StringBuilder sb = new StringBuilder();
        for (UUID u : uuids) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(u.toString());
        }
        this.f_19804_.m_135381_(TRACKER_UUIDS, (Object)sb.toString());
    }

    public DinosaurEntity(Level level, EntityType<? extends DinosaurEntity> type, Dinosaur dino) {
        super(type, level);
        this.dinosaur = dino;
        this.blocked = false;
        this.setFullyGrown();
        this.metabolism = new MetabolismContainer(this);
        this.inventory = new InventoryDinosaur(this);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, 0.0f);
        if (dino.isMarineCreature()) {
            this.f_21344_ = new WaterBoundPathNavigation((Mob)this, level);
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
            this.f_21365_ = new DinosaurLookHelper(this);
        } else {
            this.f_21344_ = new DinosaurPathNavigate(this, level);
            this.m_21573_().m_7008_(true);
            this.f_21342_ = new DinosaurMoveHelper(this);
            this.f_21365_ = new DinosaurLookHelper(this);
        }
        this.f_21343_ = new DinosaurJumpHelper(this);
        LegSolver legSolver = this.legSolver = level.f_46443_ ? this.createLegSolver() : null;
        if (level.f_46443_) {
            this.initClient();
        }
        if (this.genetics == null || this.genetics.isEmpty()) {
            this.genetics = GeneticsHelper.randomGenetics(this.f_19796_);
        }
        this.resetAttackCooldown();
        this.animationTick = 0;
        this.setAnimation(EntityAnimation.IDLE.get());
        this.setUseInertialTweens(true);
        this.f_19811_ = true;
        this.setSkeleton(false);
        this.attributes = DinosaurAttributes.create(this);
        this.updateAttributes();
        this.f_21345_.m_148105_().clear();
        this.f_21346_.m_148105_().clear();
        this.m_8099_();
        this.goalsRegistered = true;
    }

    @javax.annotation.Nullable
    protected LegSolver createLegSolver() {
        return null;
    }

    private void eatEggs() {
        if (!this.f_19853_.f_46443_) {
            ArrayList eggs = new ArrayList();
            ((ServerLevel)this.f_19853_).m_142646_().m_142690_(EntityTypeTest.m_156916_(DinosaurEggEntity.class), entity -> {
                eggs.add(entity);
                return AbortableIterationConsumer.Continuation.CONTINUE;
            });
            for (Entity egg : eggs) {
                if (!(egg instanceof DinosaurEggEntity) || !(egg.m_146892_().m_82554_(this.m_20182_()) < 0.5)) continue;
                egg.m_6074_();
                this.getMetabolism().setEnergy((int)((double)this.getMetabolism().getEnergy() + ((DinosaurEggEntity)egg).getDinosaur().getAdultHealth() * 0.4));
            }
        }
    }

    public EntityType<?> m_6095_() {
        return super.m_6095_();
    }

    public InventoryDinosaur getInventory() {
        return this.inventory;
    }

    protected boolean getDoesEatEggs() {
        return this.eatsEggs;
    }

    protected void doesEatEggs(boolean eatsEggs) {
        this.eatsEggs = eatsEggs;
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    private void initClient() {
        this.tailBuffer = new FixedChainBuffer();
    }

    public boolean shouldSleep() {
        if (this.metabolism.isDehydrated() || this.metabolism.isStarving()) {
            return false;
        }
        SleepTime sleepTime = this.dinosaur.getSleepTime();
        return sleepTime.shouldSleep() && this.getDinosaurTime() > sleepTime.getAwakeTime() && !this.hasPredators() && (this.herd == null || this.herd.enemies.isEmpty());
    }

    private boolean hasPredators() {
        for (LivingEntity predator : this.f_19853_.m_6443_(LivingEntity.class, new AABB(this.m_20185_() - 10.0, this.m_20186_() - 5.0, this.m_20189_() - 10.0, this.m_20185_() + 10.0, this.m_20186_() + 5.0, this.m_20189_() + 10.0), e -> e != this)) {
            DinosaurEntity dinosaur;
            boolean hasDinosaurPredator = false;
            if (predator instanceof DinosaurEntity && (!(dinosaur = (DinosaurEntity)predator).isCarcass() || dinosaur.isSleeping)) {
                for (Class<? extends LivingEntity> target : dinosaur.getAttackTargets()) {
                    if (!target.isAssignableFrom(this.getClass())) continue;
                    hasDinosaurPredator = true;
                    break;
                }
            }
            if (this.m_21188_() != predator && !hasDinosaurPredator) continue;
            return true;
        }
        return false;
    }

    public int getDinosaurTime() {
        SleepTime sleepTime = this.dinosaur.getSleepTime();
        long time = this.f_19853_.m_46468_() % 24000L - (long)sleepTime.getWakeUpTime();
        if (time < 0L) {
            time += 24000L;
        }
        return (int)time;
    }

    public ItemStack getPickedResult(HitResult target) {
        RegistryObject<DinosaurSpawnEggItem> eggItem = ModItems.getSpawnEgg(this.getDinosaur());
        if (eggItem == null) {
            return ItemStack.f_41583_;
        }
        ItemStack egg = new ItemStack((ItemLike)eggItem.get());
        egg.m_41784_().m_128405_("GenderMode", this.isMale() ? 1 : 2);
        return egg;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(Player player) {
        if (this.dinosaur.isImprintable()) {
            UUID prevOwner = this.owner;
            this.owner = player.m_20148_();
            if (!this.owner.equals(prevOwner)) {
                if (!this.f_19853_.f_46443_) {
                    this.f_19804_.m_135381_(WATCHER_OWNER_IDENTIFIER, (Object)this.owner.toString());
                }
                ArrayList<String> vowels = this.buildArray("a", "e", "i", "o", "u");
                boolean hasVowel = false;
                for (String vowel : vowels) {
                    if (!this.dinosaur.getName().toLowerCase().startsWith(vowel)) continue;
                    hasVowel = true;
                    break;
                }
                String msg = Component.m_237115_((String)"message.tame").getString().replace("{dinosaur}", this.dinosaur.getName());
                if (!hasVowel) {
                    msg = msg.replace("an", "a");
                }
                player.m_213846_((Component)Component.m_237113_((String)msg));
            }
        }
    }

    public ArrayList<String> buildArray(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, strings);
        return list;
    }

    public boolean m_7327_(Entity entity) {
        if (entity instanceof DinosaurEntity && ((DinosaurEntity)entity).isCarcass() && this.canEatEntity(entity)) {
            this.setAnimation(EntityAnimation.EATING.get());
        } else {
            this.setAnimation(EntityAnimation.ATTACKING.get());
        }
        while (entity.m_20202_() != null) {
            entity = entity.m_20202_();
        }
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        if (entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage)) {
            if (entity instanceof DinosaurEntity && ((DinosaurEntity)entity).isCarcass()) {
                DinosaurEntity dinosaur = (DinosaurEntity)entity;
                if (dinosaur.herd != null && this.herd != null && dinosaur.herd.fleeing && dinosaur.herd.enemies.contains(this)) {
                    this.herd.enemies.removeAll(dinosaur.herd.members);
                    for (DinosaurEntity member : this.herd) {
                        if (member.m_5448_() == null || !dinosaur.herd.members.contains(member.m_5448_())) continue;
                        member.m_6710_(null);
                    }
                    this.herd.state = Herd.State.IDLE;
                }
            }
            return true;
        }
        return false;
    }

    public LivingEntity getAttackTarget() {
        if (super.m_5448_() != null && super.m_5448_().m_21224_()) {
            this.m_6710_(null);
            return null;
        }
        return super.m_5448_();
    }

    public void m_6710_(@javax.annotation.Nullable LivingEntity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            UUID ownerId = this.getOwner();
            if (ownerId != null && ownerId.equals(player.m_20148_())) {
                super.m_6710_(null);
                return;
            }
        }
        super.m_6710_(target);
    }

    private boolean canEatEntity(DinosaurEntity entity) {
        boolean isMarine = entity.getDinosaur().isMarineCreature();
        if (!isMarine) {
            return entity.dinosaur.getDiet().canEat(entity, FoodType.MEAT);
        }
        return entity.dinosaur.getDiet().canEat(entity, FoodType.FISH);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean canHarmInCreative = damageSource.m_269533_(DamageTypeTags.f_268738_);
        Entity attacker = damageSource.m_7639_();
        if (!this.isCarcass()) {
            if (this.m_21223_() - amount <= 0.0f) {
                if (!canHarmInCreative) {
                    this.m_5496_(this.getSoundForAnimation(EntityAnimation.DYING.get()), this.m_6121_(), this.m_6100_());
                    this.m_21153_(this.m_21233_());
                    this.setCarcass(true);
                    return true;
                }
                if (attacker instanceof DinosaurEntity) {
                    this.getRelationship(attacker, true).onAttacked(amount);
                }
                if (!(this.f_19853_.f_46443_ || RebornConfig.allowCarcass || canHarmInCreative)) {
                    this.setAnimation(EntityAnimation.DYING.get());
                }
                return super.m_6469_(damageSource, amount);
            }
            if (this.getAnimation() == EntityAnimation.RESTING.get() && !this.f_19853_.f_46443_) {
                this.setAnimation(EntityAnimation.IDLE.get());
                this.isSittingNaturally = false;
            }
            if (!this.f_19853_.f_46443_) {
                float f = this.f_19802_;
                Objects.requireNonNull(this);
                if (!(f > 20.0f / 2.0f)) {
                    this.setAnimation(EntityAnimation.INJURED.get());
                }
            }
            if (this.shouldSleep()) {
                this.disturbSleep();
            }
            if (attacker instanceof LivingEntity) {
                this.respondToAttack((LivingEntity)attacker);
            }
            return super.m_6469_(damageSource, amount);
        }
        if (!this.f_19853_.f_46443_) {
            if (!damageSource.m_269533_(DamageTypeTags.f_268581_)) {
                if (this.carcassHealth >= 0 && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.dropMeat(attacker);
                }
                --this.carcassHealth;
                if (this.carcassHealth < 0 || !RebornConfig.allowCarcass) {
                    int looting = attacker instanceof LivingEntity ? EnchantmentHelper.m_44930_((LivingEntity)((LivingEntity)attacker)) : 0;
                    this.m_7472_(damageSource, looting, true);
                    this.m_146870_();
                    return true;
                }
            }
            if (canHarmInCreative) {
                return super.m_6469_(damageSource, amount);
            }
            float f = this.f_19802_;
            Objects.requireNonNull(this);
            if (f <= 20.0f / 2.0f) {
                this.f_20917_ = 10;
                this.f_20916_ = 10;
            }
            return true;
        }
        return false;
    }

    private Relationship getRelationship(Entity entity, boolean create) {
        for (Relationship relationship : this.relationships) {
            if (!relationship.getUUID().equals(entity.m_20148_())) continue;
            return relationship;
        }
        if (create) {
            Relationship relationship = new Relationship(entity.m_20148_(), 0);
            this.relationships.add(relationship);
            return relationship;
        }
        return null;
    }

    private void dropMeat(Entity attacker) {
        int n;
        if (attacker instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)attacker;
            n = EnchantmentHelper.m_44930_((LivingEntity)le);
        } else {
            n = 0;
        }
        int fortune = n;
        int count = this.f_19796_.m_188503_(2) + 1 + fortune;
        boolean burning = this.m_6060_();
        for (int i = 0; i < count; ++i) {
            Item dinoMeat;
            Item item = dinoMeat = burning ? ItemsUtil.getSteakForDinosaur(this.dinosaur) : ItemsUtil.getMeatForDinosaur(this.dinosaur);
            if (dinoMeat == null) {
                Item item2 = dinoMeat = burning ? ItemsUtil.getMeatForDinosaur(this.dinosaur) : ItemsUtil.getSteakForDinosaur(this.dinosaur);
            }
            if (dinoMeat == null) continue;
            this.dropStackWithGenetics(new ItemStack((ItemLike)dinoMeat, 1));
        }
    }

    public boolean m_6094_() {
        return super.m_6094_() && !this.isCarcass() && !this.m_5803_();
    }

    public boolean canStandOnPowderSnow() {
        return true;
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41613_() != 0 && stack.m_41720_() != null) {
            Random rand = new Random();
            ItemEntity item = new ItemEntity(this.f_19853_, this.m_20185_() + (double)(rand.nextFloat() * this.m_20205_() - this.m_20205_() / 2.0f), this.m_20186_() + (double)offsetY, this.m_20189_() + (double)(rand.nextFloat() * this.m_20205_() - this.m_20205_() / 2.0f), stack);
            item.m_32060_();
            if (this.m_6149_()) {
                Collection thingie = this.captureDrops();
                if (thingie != null) {
                    thingie.add(item);
                }
            } else {
                this.f_19853_.m_7967_((Entity)item);
            }
            return item;
        }
        return null;
    }

    public AttributeInstance m_21051_(Attribute attr) {
        return this.m_21204_().m_22146_(attr);
    }

    public void m_6667_(DamageSource cause) {
        UUID head;
        super.m_6667_(cause);
        if (this.herd != null) {
            if (this.herd.leader == this) {
                this.herd.updateLeader();
            }
            this.herd.members.remove(this);
        }
        if (this.family != null && ((head = this.family.getHead()) == null || head.equals(this.m_20148_()))) {
            this.family.update(this);
        }
        if (cause.m_7639_() instanceof LivingEntity) {
            this.respondToAttack((LivingEntity)cause.m_7639_());
        }
    }

    public void m_8032_() {
        if (this.getAnimation() == EntityAnimation.IDLE.get()) {
            this.setAnimation(EntityAnimation.SPEAK.get());
            super.m_8032_();
        }
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRACKER_UUIDS, (Object)"");
        this.f_19804_.m_135372_(WATCHER_IS_CARCASS, (Object)this.isCarcass);
        this.f_19804_.m_135372_(WATCHER_AGE, (Object)this.dinosaurAge);
        this.f_19804_.m_135372_(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
        this.f_19804_.m_135372_(WATCHER_OWNER_IDENTIFIER, (Object)"");
        this.f_19804_.m_135372_(WATCHER_CURRENT_ORDER, (Object)0);
        this.f_19804_.m_135372_(WATCHER_IS_RUNNING, (Object)false);
        this.f_19804_.m_135372_(WATCHER_WAS_FED, (Object)false);
        this.f_19804_.m_135372_(WATCHER_WAS_MOVED, (Object)this.wasMoved);
    }

    public void updateAttributes() {
        double prevHealth = this.m_21233_();
        double newHealth = Math.max(1.0, this.interpolate(this.dinosaur.getBabyHealth(), this.dinosaur.getAdultHealth()) * (double)this.attributes.getHealthModifier());
        double speed = this.interpolate(this.dinosaur.getBabySpeed(), this.dinosaur.getAdultSpeed()) * (double)this.attributes.getSpeedModifier();
        double strength = this.getAttackDamage() * (double)this.attributes.getDamageModifier();
        this.m_21204_().m_22146_(Attributes.f_22276_).m_22100_(newHealth);
        this.m_21204_().m_22146_(Attributes.f_22279_).m_22100_(speed);
        this.m_21204_().m_22146_(Attributes.f_22281_).m_22100_(strength);
        this.m_21204_().m_22146_(Attributes.f_22277_).m_22100_(64.0);
        if (prevHealth != newHealth) {
            this.m_5634_((float)(newHealth - prevHealth));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22282_).m_22266_(Attributes.f_22277_).m_22266_(Attributes.f_22281_);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.attributes == null) {
            return super.m_6972_(pose);
        }
        float scale = this.attributes.getScaleModifier();
        float baseW = (float)this.interpolate(this.dinosaur.getBabySizeX(), this.dinosaur.getAdultSizeX());
        float baseH = (float)this.interpolate(this.dinosaur.getBabySizeY(), this.dinosaur.getAdultSizeY());
        float width = Mth.m_14036_((float)(baseW * scale), (float)0.1f, (float)4.0f);
        float height = Mth.m_14036_((float)(baseH * scale), (float)0.1f, (float)4.0f);
        if (this.isCarcass) {
            float slab = Mth.m_14036_((float)(width * 0.35f), (float)0.2f, (float)1.0f);
            return EntityDimensions.m_20398_((float)width, (float)slab);
        }
        return EntityDimensions.m_20398_((float)width, (float)height);
    }

    protected float m_6431_(Pose pose, EntityDimensions dims) {
        if (this.attributes == null) {
            return super.m_6431_(pose, dims);
        }
        float scale = this.attributes.getScaleModifier();
        float eye = (float)this.interpolate(this.dinosaur.getBabyEyeHeight(), this.dinosaur.getAdultEyeHeight()) * scale;
        if (this.isCarcass) {
            eye = Math.min(eye, 0.3f);
        } else if (this.isSleeping) {
            eye = Math.max(0.3f, eye * 0.6f);
        }
        float hitboxHeight = dims.f_20378_;
        float maxEye = Math.max(0.1f, hitboxHeight - 0.05f);
        return Mth.m_14036_((float)eye, (float)0.1f, (float)maxEye);
    }

    public void m_6210_() {
        super.m_6210_();
        EntityDimensions d = this.m_6972_(this.m_20089_());
        float base = Mth.m_14036_((float)(d.f_20378_ * 0.5f), (float)0.9f, (float)1.0f);
        if (this.m_20072_() || this.m_20077_()) {
            base = Math.min(1.2f, Math.max(base, 1.0f));
        }
        this.f_19793_ = base;
    }

    public double interpolate(double baby, double adult) {
        int dinosaurAge = this.dinosaurAge;
        int maxAge = this.dinosaur.getMaximumAge();
        if (dinosaurAge > maxAge) {
            dinosaurAge = maxAge;
        }
        return (adult - baby) / (double)maxAge * (double)dinosaurAge + baby;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return true;
    }

    public void setupDisplay(boolean isMale) {
        this.setFullyGrown();
        this.setMale(isMale);
        this.f_19797_ = 4;
    }

    public int m_8100_() {
        return 200;
    }

    public float m_6100_() {
        return (float)this.interpolate(2.5, 1.0) + (this.f_19796_.m_188501_() - 0.5f) * 0.125f;
    }

    public float m_6121_() {
        if (this.isCarcass() || this.isSleeping) {
            return 0.0f;
        }
        float largestDimension = Math.max(this.m_20205_(), this.m_20206_());
        float scaledVolume = 0.25f + largestDimension * 0.25f;
        return Mth.m_14036_((float)scaledVolume, (float)0.15f, (float)1.75f);
    }

    public void m_5496_(@javax.annotation.Nullable SoundEvent sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        super.m_5496_(sound, volume, pitch);
    }

    public String getGenetics() {
        return this.genetics;
    }

    public void setGenetics(String genetics) {
        this.genetics = genetics;
    }

    public boolean isEntityFreindly(Entity entity) {
        return this.getClass().isAssignableFrom(entity.getClass());
    }

    public boolean canEatEntity(Entity entity) {
        if (entity instanceof Player && (((Player)entity).m_7500_() || ((Player)entity).m_5833_())) {
            return false;
        }
        return !this.isEntityFreindly(entity);
    }

    private static void setVariantFromParent(DinosaurEntity child, DinosaurEntity parent) {
        if (child instanceof IHasVariants && parent instanceof IHasVariants) {
            ((IHasVariants)((Object)child)).setVariant(((IHasVariants)((Object)parent)).getVariant());
        }
    }

    protected void m_267689_(float partialTicks) {
        float amount;
        if (this.isClimbing()) {
            double dy = (this.m_20186_() - this.f_19791_) * 4.0;
            if (dy > 1.0) {
                dy = 1.0;
            }
            amount = (float)dy;
        } else {
            double dz;
            double dx = this.m_20185_() - this.f_19854_;
            float dist = Mth.m_14116_((float)((float)(dx * dx + (dz = this.m_20189_() - this.f_19856_) * dz))) * 4.0f;
            if (dist > 1.0f) {
                dist = 1.0f;
            }
            amount = dist;
        }
        this.f_267362_.m_267566_(amount, 0.4f);
    }

    public void m_8107_() {
        DinosaurEntity entity;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!RebornConfig.allowCarcass && this.isCarcass) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if ((livingEntity = this.getAttackTarget()) instanceof DinosaurEntity && (entity = (DinosaurEntity)livingEntity).isCarcass()) {
            boolean carnivore;
            Diet diet = this.getDinosaur().getDiet();
            boolean bl = carnivore = diet.canEat(this, FoodType.MEAT) || diet.canEat(this, FoodType.FISH);
            if (!this.getMetabolism().isHungry() || !carnivore) {
                this.m_6710_(null);
            }
        }
        if (!this.f_19853_.m_46469_().m_46207_(GameRuleHandler.DINO_METABOLISM)) {
            if (this.getMetabolism().getEnergy() < this.getMetabolism().getMaxEnergy()) {
                this.getMetabolism().setEnergy(this.getMetabolism().getMaxEnergy());
            }
            if (this.getMetabolism().getWater() < this.getMetabolism().getMaxWater()) {
                this.getMetabolism().setWater(this.getMetabolism().getMaxWater());
            }
        }
        this.blocked = this.animation != null && EntityAnimation.getAnimation(this.animation).doesBlockMovement();
        if (!this.f_19853_.f_46443_ && this instanceof TyrannosaurusEntity) {
            if (this.moveTicks > 0) {
                --this.moveTicks;
                double yaw = Math.toRadians(this.m_146908_() - 90.0f);
                double motionX = Math.sin(-yaw) * 0.03 * 6.3;
                double motionZ = Math.cos(yaw) * 0.03 * 6.3;
                this.m_20334_(motionX, this.m_20184_().f_82480_, motionZ);
            }
            if (this.moveTicks > -5) {
                --this.moveTicks;
                if (this.moveTicks == -4) {
                    this.wasMoved = true;
                }
            }
        }
        if (this.isCarcass()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.breedCooldown > 0) {
            --this.breedCooldown;
        }
        if (!(this.f_19853_.f_46443_ || !this.dinosaur.getDiet().canEat(this, FoodType.MEAT) && !this.dinosaur.getDiet().canEat(this, FoodType.FISH) || RebornConfig.attackOnlyWhenHungry && !this.getMetabolism().isHungry() || this.m_5448_() != null && this.m_5448_().m_6084_() || this.targetSearchCooldown-- > 0)) {
            this.targetSearchCooldown = 30 + this.f_19796_.m_188503_(20);
            boolean requirePath = !(this.m_21573_() instanceof WaterBoundPathNavigation);
            LivingEntity best = null;
            double bestDist2 = Double.MAX_VALUE;
            List nearby = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(12.0), this::canEatEntity);
            for (LivingEntity cand : nearby) {
                double d2;
                if (!this.attackTargets.stream().anyMatch(clazz -> clazz.isAssignableFrom(cand.getClass())) || !this.m_142582_((Entity)cand) || !((d2 = this.m_20280_((Entity)cand)) < bestDist2)) continue;
                bestDist2 = d2;
                best = cand;
            }
            if (best != null) {
                if (!requirePath) {
                    this.m_6710_(best);
                } else if (this.m_21573_().m_6570_(best, 0) != null) {
                    this.m_6710_(best);
                }
            }
        }
        if (!(this.isMale() || this.f_19853_.f_46443_ || this.dinosaur.isHybrid)) {
            if (this.isPregnant() && --this.pregnantTime <= 0) {
                this.f_21344_.m_26573_();
                this.setAnimation(this.dinosaur.givesDirectBirth() ? EntityAnimation.GIVING_BIRTH.get() : EntityAnimation.LAYING_EGG.get());
                if (this.family != null) {
                    this.family.setHome(this.m_20097_(), 6000);
                }
            }
            if ((this.getAnimation() == EntityAnimation.LAYING_EGG.get() || this.getAnimation() == EntityAnimation.GIVING_BIRTH.get()) && this.animationTick == this.getAnimationLength() / 2) {
                for (DinosaurEntity child : this.children) {
                    IEntityAdditionalSpawnData entity2;
                    DinosaurEntity.setVariantFromParent(child, this);
                    if (this.dinosaur.givesDirectBirth()) {
                        entity2 = child;
                        child.setAge(0);
                        if (this.family != null) {
                            this.family.addChild(entity2.m_20148_());
                        }
                    } else {
                        entity2 = new DinosaurEggEntity((EntityType<? extends DinosaurEggEntity>)((EntityType)ModEntities.DINOSAUR_EGG.get()), this.f_19853_, child, this);
                    }
                    entity2.m_6034_(this.m_20185_() + (double)(this.f_19796_.m_188501_() - 0.5f), this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.m_188501_() - 0.5f));
                    this.f_19853_.m_7967_((Entity)entity2);
                }
            }
        }
        if (this.breeding != null) {
            boolean dead;
            if (this.f_19797_ % 10 == 0) {
                this.m_21573_().m_5624_((Entity)this.breeding, 1.0);
            }
            boolean bl = dead = this.breeding.f_20890_ || this.breeding.isCarcass();
            if (dead || this.m_20191_().m_82381_(this.breeding.m_20191_().m_82400_(3.0))) {
                if (!dead) {
                    this.breedCooldown = this.dinosaur.getBreedCooldown();
                    if (!this.isMale()) {
                        int minClutch = this.dinosaur.getMinClutch();
                        int maxClutch = this.dinosaur.getMaxClutch();
                        int clutchSize = this.f_19796_.m_188503_(maxClutch - minClutch + 1) + minClutch;
                        for (int i = 0; i < clutchSize; ++i) {
                            try {
                                DinosaurEntity child;
                                RegistryObject<? extends EntityType<? extends DinosaurEntity>> reg = CLASS_TYPE_LIST.get(this.getClass());
                                if (reg == null || (child = (DinosaurEntity)((EntityType)reg.get()).m_20615_(this.f_19853_)) == null) continue;
                                child.setAge(0);
                                child.setMale(this.f_19796_.m_188500_() > 0.5);
                                child.setDNAQuality(100);
                                StringBuilder genetics = new StringBuilder();
                                for (int c = 0; c < this.genetics.length(); ++c) {
                                    if (this.f_19796_.m_188499_()) {
                                        genetics.append(this.genetics.charAt(c));
                                        continue;
                                    }
                                    genetics.append(this.breeding.genetics.charAt(c));
                                }
                                child.setGenetics(genetics.toString());
                                child.setAttributes(this.attributes);
                                this.children.add(child);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this.pregnantTime = 9600;
                    }
                }
                this.breeding = null;
            }
        }
        if (this.f_19797_ % 10 == 0) {
            this.inLava = this.m_20077_();
        }
        if (!this.isCarcass) {
            SoundEvent breathingSound;
            if (this.f_19803_) {
                this.updateAttributes();
            }
            this.updateGrowth();
            if (!this.f_19853_.f_46443_) {
                if (this.metabolism.isHungry()) {
                    List entitiesWithinAABB = this.f_19853_.m_45976_(ItemEntity.class, this.m_20191_().m_82400_(1.0));
                    for (ItemEntity itemEntity : entitiesWithinAABB) {
                        Item item = itemEntity.m_32055_().m_41720_();
                        if (!FoodHelper.isEdible(this, this.dinosaur.getDiet(), item)) continue;
                        this.setAnimation(EntityAnimation.EATING.get());
                        if (itemEntity.m_32055_().m_41613_() > 1) {
                            itemEntity.m_32055_().m_41774_(1);
                        } else {
                            itemEntity.m_6074_();
                        }
                        this.getMetabolism().eat(FoodHelper.getHealAmount(item));
                        FoodHelper.applyEatEffects(this, item);
                        this.m_5634_(10.0f);
                        break;
                    }
                }
                this.metabolism.update();
            }
            if (this.f_19797_ % 62 == 0 && (breathingSound = this.getBreathingSound()) != null) {
                this.m_5496_(breathingSound, this.m_6121_(), this.m_6100_());
            }
            if (!(this.dinosaur.isMarineCreature() || this instanceof AmphibianDinosaurEntity || this instanceof PenguinDinosaurEntity)) {
                this.handleLandDinosaurInFluid();
            }
            if (this.herd == null) {
                this.herd = new Herd(this);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.order == Order.WANDER) {
                    if (this.herd.state == Herd.State.IDLE && this.getAttackTarget() == null && !this.metabolism.isThirsty() && !this.metabolism.isHungry() && this.m_21573_().m_26571_()) {
                        if (!this.isSleeping && !this.shouldSleep() && this.f_19861_ && !this.m_20069_() && this.getAnimation() == EntityAnimation.IDLE.get() && this.f_19796_.m_188503_(800) == 0) {
                            this.setAnimation(EntityAnimation.RESTING.get());
                            this.isSittingNaturally = true;
                        }
                    } else if (this.getAnimation() == EntityAnimation.RESTING.get()) {
                        this.setAnimation(EntityAnimation.IDLE.get());
                        this.isSittingNaturally = false;
                    }
                }
                if (this == this.herd.leader && !this.dinosaur.isMarineCreature()) {
                    this.herd.update();
                }
                if (this.f_19797_ % 10 == 0) {
                    if (this.family != null && (this.family.getHead() == null || this.family.getHead().equals(this.m_20148_()))) {
                        if (this.family.update(this)) {
                            this.family = null;
                        }
                    } else if (this.family == null && this.getAttackTarget() == null && this.relationships.size() > 0 && this.f_19796_.m_188500_() > 0.9) {
                        DinosaurEntity chosen = null;
                        Relationship chosenRelationship = null;
                        for (Relationship relationship : this.relationships) {
                            DinosaurEntity entity3;
                            if (!((double)relationship.getScore() > 900.0) || (entity3 = relationship.get(this)) == null || this.isMale == entity3.isMale) continue;
                            chosen = entity3;
                            chosenRelationship = relationship;
                            break;
                        }
                        if (chosen != null) {
                            this.family = new Family(this.m_20148_(), chosen.m_20148_());
                            chosenRelationship.setFamily();
                            chosen.breedCooldown = this.breedCooldown = this.f_19796_.m_188503_(1000) + 1000;
                        }
                    }
                    if (this.herd != null) {
                        for (DinosaurEntity herdMember : this.herd.members) {
                            if (herdMember == this) continue;
                            Relationship relationship = this.getRelationship((Entity)herdMember, true);
                            relationship.updateHerd(this);
                        }
                        for (LivingEntity enemy : this.herd.enemies) {
                            Relationship relationship;
                            if (!(enemy instanceof DinosaurEntity) || this.relationships.contains(relationship = new Relationship(enemy.m_20148_(), -30))) continue;
                            this.relationships.add(relationship);
                        }
                    }
                    if (this.relationships.size() > 0) {
                        HashSet<Relationship> removal = new HashSet<Relationship>();
                        for (Relationship relationship : this.relationships) {
                            if (!relationship.update(this)) continue;
                            removal.add(relationship);
                        }
                        this.relationships.removeAll(removal);
                    }
                }
                if (!this.m_21573_().m_26571_() && this.isSittingNaturally && this.getAnimation() == EntityAnimation.RESTING.get()) {
                    this.setAnimation(EntityAnimation.IDLE.get());
                    this.isSittingNaturally = false;
                }
            }
        }
        if (!this.f_19853_.f_46443_) {
            // empty if block
        }
        if (this.getDoesEatEggs()) {
            this.eatEggs();
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ % 20 == 0) {
            this.f_19804_.m_135381_(WATCHER_WAS_FED, (Object)false);
        }
    }

    private void updateGrowth() {
        if (!this.f_20890_ && this.f_19797_ % 8 == 0 && !this.f_19853_.f_46443_) {
            this.dinosaurAge += Math.min(this.growthSpeedOffset, 960) + 1;
            this.metabolism.decreaseEnergy((int)((double)(Math.min(this.growthSpeedOffset, 960) + 1) * 0.1));
            if (this.growthSpeedOffset > 0) {
                this.growthSpeedOffset -= 10;
                if (this.growthSpeedOffset < 0) {
                    this.growthSpeedOffset = 0;
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        }
        if (this.f_19853_.f_46443_ && ((Boolean)this.f_19804_.m_135370_(WATCHER_WAS_FED)).booleanValue()) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
        }
        if (this.ticksUntilDeath > 0 && --this.ticksUntilDeath == 0) {
            this.m_5496_(this.getSoundForAnimation(EntityAnimation.DYING.get()), this.m_6121_(), this.m_6100_());
            this.m_21153_(this.m_21233_());
            this.setCarcass(true);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.animation == EntityAnimation.LEAP.get() && this.m_20184_().f_82480_ < 0.0) {
                this.setAnimation(EntityAnimation.LEAP_LAND.get());
            } else if (this.animation == EntityAnimation.LEAP_LAND.get() && (this.f_19861_ || this.m_6069_())) {
                this.setAnimation(EntityAnimation.IDLE.get());
            }
        }
        if (this.animation != null && this.animation != EntityAnimation.IDLE.get()) {
            boolean hold = EntityAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!hold) {
                this.animationTick = 0;
                if (this.animation == EntityAnimation.PREPARE_LEAP.get()) {
                    this.setAnimation(EntityAnimation.LEAP.get());
                } else {
                    this.setAnimation(EntityAnimation.IDLE.get());
                }
            } else {
                this.animationTick = Math.max(0, this.animationLength - 1);
            }
        } else {
            this.animationTick = 0;
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(WATCHER_WAS_MOVED, (Object)this.wasMoved);
            this.f_19804_.m_135381_(WATCHER_AGE, (Object)this.dinosaurAge);
            this.f_19804_.m_135381_(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
            this.f_19804_.m_135381_(WATCHER_IS_CARCASS, (Object)this.isCarcass);
            this.f_19804_.m_135381_(WATCHER_CURRENT_ORDER, (Object)((byte)this.order.ordinal()));
            this.f_19804_.m_135381_(WATCHER_OWNER_IDENTIFIER, (Object)(this.owner != null ? this.owner.toString() : ""));
            this.f_19804_.m_135381_(WATCHER_IS_RUNNING, (Object)((double)this.m_6113_() > this.m_21172_(Attributes.f_22279_) ? 1 : 0));
        } else {
            this.updateTailBuffer();
            this.wasMoved = (Boolean)this.f_19804_.m_135370_(WATCHER_WAS_MOVED);
            this.dinosaurAge = (Integer)this.f_19804_.m_135370_(WATCHER_AGE);
            this.isSleeping = (Boolean)this.f_19804_.m_135370_(WATCHER_IS_SLEEPING);
            this.isCarcass = (Boolean)this.f_19804_.m_135370_(WATCHER_IS_CARCASS);
            String ownerStr = (String)this.f_19804_.m_135370_(WATCHER_OWNER_IDENTIFIER);
            this.order = Order.values()[(Byte)this.f_19804_.m_135370_(WATCHER_CURRENT_ORDER)];
            if (this.order == Order.SIT) {
                this.isSittingNaturally = false;
                if (!this.isSleeping && this.getAnimation() != EntityAnimation.RESTING.get()) {
                    this.setAnimationSilently(EntityAnimation.RESTING.get());
                }
            } else if (!this.isSleeping && !this.isSittingNaturally && this.getAnimation() == EntityAnimation.RESTING.get()) {
                this.setAnimationSilently(EntityAnimation.IDLE.get());
            }
            if (!(ownerStr.isEmpty() || this.owner != null && ownerStr.equals(this.owner.toString()))) {
                this.owner = UUID.fromString(ownerStr);
            } else if (ownerStr.isEmpty()) {
                this.owner = null;
            }
        }
        if (this.f_19797_ % 20 == 0) {
            this.updateAttributes();
            this.m_6210_();
        }
        if (this.isCarcass) {
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
        }
        if (this.isSleeping) {
            if (this.getAnimation() != EntityAnimation.SLEEPING.get()) {
                this.setAnimation(EntityAnimation.SLEEPING.get());
            }
        } else if (this.getAnimation() == EntityAnimation.SLEEPING.get()) {
            this.setAnimation(EntityAnimation.IDLE.get());
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isCarcass) {
                if (this.getAnimation() != EntityAnimation.DYING.get()) {
                    this.setAnimation(EntityAnimation.DYING.get());
                }
                if (this.f_19797_ % 1000 == 0) {
                    this.m_6469_(this.m_269291_().m_269264_(), 1.0f);
                }
            } else {
                if (this.isSleeping) {
                    if (this.f_19797_ % 20 == 0 && this.stayAwakeTime <= 0 && this.hasPredators()) {
                        this.disturbSleep();
                    }
                    if (!this.shouldSleep() && this.tranquilizerTicks-- <= 0) {
                        this.isSleeping = false;
                        this.tranquilizerTicks = 0;
                        this.tranqed = false;
                    }
                } else if (this.getAnimation() == EntityAnimation.SLEEPING.get()) {
                    this.setAnimation(EntityAnimation.IDLE.get());
                }
                if (!this.isSleeping) {
                    if (this.order == Order.SIT) {
                        if (this.getAnimation() != EntityAnimation.RESTING.get()) {
                            this.setAnimation(EntityAnimation.RESTING.get());
                        }
                    } else if (!this.isSittingNaturally && this.getAnimation() == EntityAnimation.RESTING.get()) {
                        this.setAnimation(EntityAnimation.IDLE.get());
                    }
                }
            }
        }
        if (!this.shouldSleep() && !this.isSleeping) {
            this.stayAwakeTime = 0;
        }
        if (this.stayAwakeTime > 0) {
            --this.stayAwakeTime;
        }
        if (this.wireTicks > 0) {
            --this.wireTicks;
        }
        if (this.disableHerdingTicks > 0) {
            --this.disableHerdingTicks;
        }
        if (this.legSolver != null) {
            boolean skeleton = this.isSkeleton();
            double adultScale = this.dinosaur.getScaleAdult(skeleton);
            double infantScale = this.dinosaur.getScaleInfant(skeleton);
            double msc = adultScale != 0.0 ? infantScale / adultScale : 1.0;
            this.legSolver.update((LivingEntity)this, (float)this.interpolate(msc, 1.0) * this.attributes.getScaleModifier());
        }
        this.prevAge = this.dinosaurAge;
    }

    private void updateTailBuffer() {
        this.tailBuffer.calculateChainSwingBuffer(68.0f, 3, 7.0f, (LivingEntity)this);
    }

    public boolean m_6107_() {
        return this.isMovementBlocked();
    }

    public boolean isMovementBlocked() {
        return this.isCarcass() || this.m_5803_() || this.blocked;
    }

    protected float m_5632_(float angle, float distance) {
        if (!this.isMovementBlocked()) {
            return super.m_5632_(angle, distance);
        }
        return distance;
    }

    public int getDaysExisted() {
        return (int)Math.floor((float)this.dinosaurAge * 8.0f / 24000.0f);
    }

    public void setFullyGrown() {
        this.setAge(this.dinosaur.getMaximumAge());
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean m_6072_() {
        return true;
    }

    public int getDinosaurAge() {
        return this.dinosaurAge;
    }

    public void setAge(int age) {
        this.dinosaurAge = age;
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(WATCHER_AGE, (Object)this.dinosaurAge);
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        if (pSource.m_269533_(DamageTypeTags.f_268738_) && pSource.m_269533_(DamageTypeTags.f_268490_)) {
            return;
        }
        this.dropMeat(pSource.m_7639_());
        for (String bone : this.dinosaur.getBones()) {
            this.dropStackWithGenetics(new ItemStack((ItemLike)ItemsUtil.getFreshDinosaurBone(this.dinosaur, bone)));
        }
    }

    private void dropStackWithGenetics(ItemStack stack) {
        ItemStack src = ((StorageDiscItem)ModItems.STORAGE_DISC.get()).m_7968_();
        new DinoDNA(this.dinosaur, this.geneticsQuality, this.genetics).writeToNBT(src.m_41784_());
        StorageDiscItem.applyCustomModelData(src);
        FossilGrinderBlockEntity.copyDNA(src, stack);
        DinosaurItem.setDino(stack, this.dinosaur);
        ItemEntity item = new ItemEntity(this.f_19853_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() - this.m_20205_() / 2.0f), this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() - this.m_20205_() / 2.0f), stack);
        item.m_32060_();
        this.f_19853_.m_7967_((Entity)item);
    }

    @Override
    public boolean isCarcass() {
        return this.isCarcass;
    }

    public void setCarcass(boolean carcass) {
        if (!this.f_19853_.f_46443_ && carcass != this.isCarcass && !this.wasMoved) {
            this.moveTicks = 18;
        }
        this.isCarcass = carcass;
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(WATCHER_IS_CARCASS, (Object)this.isCarcass);
        }
        if (carcass && RebornConfig.allowCarcass) {
            this.setAnimation(EntityAnimation.DYING.get());
            this.carcassHealth = Mth.m_14045_((int)Math.max(1, (int)Math.sqrt(this.m_20205_() * this.m_20206_())), (int)0, (int)8);
            this.f_19797_ = 0;
            this.inventory.dropItems(this.f_19853_, this.f_19796_);
        } else if (carcass) {
            this.setAnimation(EntityAnimation.DYING.get());
            this.carcassHealth = 0;
            this.inventory.dropItems(this.f_19853_, this.f_19796_);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean isClient = this.f_19853_.f_46443_;
        if (player.m_6047_() && hand == InteractionHand.MAIN_HAND) {
            if (this.isOwner(player)) {
                if (this.getAgePercentage() <= 75 && isClient) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.too_young").m_130940_(ChatFormatting.RED));
                }
            } else if (isClient) {
                player.m_213846_((Component)Component.m_237115_((String)"message.not_owned.name").m_130940_(ChatFormatting.RED));
            }
        } else if (stack.m_41619_() && hand == InteractionHand.MAIN_HAND && isClient) {
            if (this.isOwner(player)) {
                JurassicClient.openOrderMenu(this);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"message.not_owned.name").m_130940_(ChatFormatting.RED));
            }
        } else if (!stack.m_41619_() && (this.metabolism.isThirsty() || this.metabolism.isHungry()) && !this.f_19853_.f_46443_) {
            Item item = stack.m_41720_();
            boolean fed = false;
            if (item == Items.f_42589_) {
                fed = true;
                this.metabolism.increaseWater(1000);
                this.setAnimation(EntityAnimation.DRINKING.get());
            } else if (FoodHelper.isEdible(this, this.dinosaur.getDiet(), item)) {
                fed = true;
                this.metabolism.eat(FoodHelper.getHealAmount(item));
                this.setAnimation(EntityAnimation.EATING.get());
                FoodHelper.applyEatEffects(this, item);
            }
            if (fed) {
                this.f_19804_.m_135381_(WATCHER_WAS_FED, (Object)true);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (item == Items.f_42589_) {
                        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                    }
                }
                if (!this.isOwner(player) && this.f_19796_.m_188501_() < 0.3f) {
                    if (this.dinosaur.getDinosaurType() == Dinosaur.DinosaurType.AGGRESSIVE) {
                        if (this.f_19796_.m_188501_() * 4.0f < (float)this.herd.members.size() / (float)this.dinosaur.getMaxHerdSize()) {
                            this.herd.enemies.add((LivingEntity)player);
                        } else {
                            this.m_7327_((Entity)player);
                        }
                    } else if (this.dinosaur.getDinosaurType() == Dinosaur.DinosaurType.SCARED) {
                        this.herd.fleeing = true;
                        this.herd.enemies.add((LivingEntity)player);
                    }
                }
                player.m_21011_(hand, true);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isOwner(Player player) {
        return player.m_20148_().equals(this.getOwner());
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_() && (double)this.m_20205_() < 1.5 && super.m_6573_(pPlayer);
    }

    public int getDNAQuality() {
        return this.geneticsQuality;
    }

    public void setDNAQuality(int quality) {
        this.geneticsQuality = quality;
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnimation) {
        if (this.m_5803_()) {
            newAnimation = EntityAnimation.SLEEPING.get();
        }
        if (this.isCarcass()) {
            newAnimation = EntityAnimation.DYING.get();
        }
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.dinosaur.getPoseHandler().getAnimationLength(newAnimation, this.getGrowthStage());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, newAnimation);
        }
    }

    private void setAnimationSilently(Animation newAnimation) {
        if (this.m_5803_()) {
            newAnimation = EntityAnimation.SLEEPING.get();
        }
        if (this.isCarcass()) {
            newAnimation = EntityAnimation.DYING.get();
        }
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.dinosaur.getPoseHandler().getAnimationLength(newAnimation, this.getGrowthStage());
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean isBusy() {
        if (!this.m_6084_()) {
            return true;
        }
        if (this.isCarcass() || this.m_5803_()) {
            return true;
        }
        Animation anim = this.getAnimation();
        return anim != null && EntityAnimation.getAnimation(anim).doesBlockMovement();
    }

    public boolean m_6084_() {
        return !this.isCarcass && !this.f_20890_;
    }

    public SoundEvent m_7515_() {
        return this.getSoundForAnimation(EntityAnimation.SPEAK.get());
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return this.getSoundForAnimation(EntityAnimation.INJURED.get());
    }

    public SoundEvent m_5592_() {
        return this.getSoundForAnimation(EntityAnimation.DYING.get());
    }

    public SoundEvent getSoundForAnimation(Animation animation) {
        return null;
    }

    public SoundEvent getBreathingSound() {
        return null;
    }

    public double getAttackDamage() {
        return this.interpolate(this.dinosaur.getBabyStrength(), this.dinosaur.getAdultStrength());
    }

    public boolean isMale() {
        return this.isMale;
    }

    public boolean isPregnant() {
        return !this.isMale() && this.pregnantTime > 0;
    }

    public void setMale(boolean male) {
        this.isMale = male;
    }

    public int getAgePercentage() {
        int age = this.getDinosaurAge();
        return age != 0 ? age * 100 / this.dinosaur.getMaximumAge() : 0;
    }

    @Override
    public GrowthStage getGrowthStage() {
        if (this.isSkeleton) {
            return GrowthStage.SKELETON;
        }
        int percent = this.getAgePercentage();
        return percent > 75 ? GrowthStage.ADULT : (percent > 50 ? GrowthStage.ADOLESCENT : (percent > 25 ? GrowthStage.JUVENILE : GrowthStage.INFANT));
    }

    public void increaseGrowthSpeed() {
        this.growthSpeedOffset += 240;
    }

    public int getBreedCooldown() {
        return this.breedCooldown;
    }

    public void breed(DinosaurEntity partner) {
        if (!((GameRules.BooleanValue)this.f_19853_.m_46469_().m_46170_(GameRuleHandler.DINO_BREEDING)).m_46223_()) {
            return;
        }
        this.breeding = partner;
    }

    public boolean m_6069_() {
        return (this.m_20069_() || this.inLava()) && !this.f_19861_;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Trackers", (String)this.f_19804_.m_135370_(TRACKER_UUIDS));
        nbt.m_128405_("DinosaurAge", this.dinosaurAge);
        nbt.m_128379_("IsCarcass", this.isCarcass);
        nbt.m_128405_("DNAQuality", this.geneticsQuality);
        nbt.m_128359_("Genetics", this.genetics);
        nbt.m_128379_("IsMale", this.isMale);
        nbt.m_128405_("GrowthSpeedOffset", this.growthSpeedOffset);
        nbt.m_128405_("StayAwakeTime", this.stayAwakeTime);
        nbt.m_128379_("IsSleeping", this.isSleeping);
        nbt.m_128344_("Order", (byte)this.order.ordinal());
        nbt.m_128405_("CarcassHealth", this.carcassHealth);
        nbt.m_128405_("BreedCooldown", this.breedCooldown);
        nbt.m_128405_("PregnantTime", this.pregnantTime);
        nbt.m_128379_("WasMoved", this.wasMoved);
        this.metabolism.writeToNBT(nbt);
        if (this.owner != null) {
            nbt.m_128359_("OwnerUUID", this.owner.toString());
        }
        this.inventory.writeToNBT(nbt);
        if (this.family != null && (this.family.getHead() == null || this.family.getHead().equals(this.m_20148_()))) {
            CompoundTag familyTag = new CompoundTag();
            this.family.writeToNBT(familyTag);
            nbt.m_128365_("Family", (Tag)familyTag);
        }
        ListTag relationshipList = new ListTag();
        for (Relationship relationship : this.relationships) {
            CompoundTag compound = new CompoundTag();
            relationship.writeToNBT(compound);
            relationshipList.add((Object)compound);
        }
        nbt.m_128365_("Relationships", (Tag)relationshipList);
        CompoundTag attributes = new CompoundTag();
        this.attributes.writeToNBT(attributes);
        nbt.m_128365_("GeneticAttributes", (Tag)attributes);
        if (this.children.size() > 0) {
            ListTag children = new ListTag();
            for (DinosaurEntity child : this.children) {
                if (child == null) continue;
                CompoundTag temp = new CompoundTag();
                child.m_20223_(temp);
                children.add((Object)temp);
            }
            nbt.m_128365_("Children", (Tag)children);
        }
        nbt.m_128405_("TranquilizerTicks", this.tranquilizerTicks);
        nbt.m_128405_("TicksUntilDeath", this.ticksUntilDeath);
    }

    public void m_7378_(CompoundTag nbt) {
        this.deserializing = true;
        if (nbt.m_128441_("Trackers")) {
            this.f_19804_.m_135381_(TRACKER_UUIDS, (Object)nbt.m_128461_("Trackers"));
        }
        super.m_7378_(nbt);
        this.wasMoved = nbt.m_128471_("WasMoved");
        this.setAge(nbt.m_128451_("DinosaurAge"));
        this.setCarcass(nbt.m_128471_("IsCarcass"));
        this.geneticsQuality = nbt.m_128451_("DNAQuality");
        this.genetics = nbt.m_128461_("Genetics");
        this.isMale = nbt.m_128471_("IsMale");
        this.growthSpeedOffset = nbt.m_128451_("GrowthSpeedOffset");
        this.stayAwakeTime = nbt.m_128451_("StayAwakeTime");
        this.setSleeping(nbt.m_128471_("IsSleeping"));
        this.carcassHealth = nbt.m_128451_("CarcassHealth");
        this.order = Order.values()[nbt.m_128445_("Order")];
        this.f_19804_.m_135381_(WATCHER_CURRENT_ORDER, (Object)((byte)this.order.ordinal()));
        if (this.order == Order.SIT) {
            this.isSittingNaturally = false;
            if (!this.isSleeping) {
                this.setAnimation(EntityAnimation.RESTING.get());
            }
            if (!this.f_19853_.f_46443_) {
                this.m_21573_().m_26573_();
                this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            }
        }
        this.breedCooldown = nbt.m_128451_("BreedCooldown");
        this.pregnantTime = nbt.m_128451_("PregnantTime");
        this.metabolism.readFromNBT(nbt);
        String ownerUUID = nbt.m_128461_("OwnerUUID");
        if (ownerUUID.length() > 0) {
            this.owner = UUID.fromString(ownerUUID);
        }
        if (nbt.m_128441_("Family")) {
            CompoundTag familyTag = nbt.m_128469_("Family");
            this.family = Family.readFromNBT(familyTag);
        }
        this.inventory.readFromNBT(nbt);
        ListTag relationships = nbt.m_128437_("Relationships", 10);
        for (int i = 0; i < relationships.size(); ++i) {
            CompoundTag compound = relationships.m_128728_(i);
            this.relationships.add(Relationship.readFromNBT(compound));
        }
        if (nbt.m_128441_("GeneticAttributes")) {
            CompoundTag attributes = nbt.m_128469_("GeneticAttributes");
            this.attributes = DinosaurAttributes.from(attributes);
        }
        if (nbt.m_128441_("Children")) {
            ListTag children = nbt.m_128437_("Children", 10);
            for (int i = 0; i < children.size(); ++i) {
                CompoundTag childTag = children.m_128728_(i);
                Entity entity = EntityType.m_20645_((CompoundTag)childTag, (Level)this.f_19853_, entity1 -> entity1);
                if (!(entity instanceof DinosaurEntity)) continue;
                this.children.add((DinosaurEntity)entity);
            }
        }
        this.tranquilizerTicks = nbt.m_128451_("TranquilizerTicks");
        this.ticksUntilDeath = nbt.m_128451_("TicksUntilDeath");
        this.updateAttributes();
        this.m_6210_();
        this.deserializing = false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dinosaurAge);
        buffer.writeBoolean(this.isCarcass);
        buffer.writeInt(this.geneticsQuality);
        buffer.writeBoolean(this.isMale);
        buffer.writeInt(this.growthSpeedOffset);
        this.attributes.write(buffer);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.dinosaurAge = additionalData.readInt();
        this.isCarcass = additionalData.readBoolean();
        this.geneticsQuality = additionalData.readInt();
        this.isMale = additionalData.readBoolean();
        this.growthSpeedOffset = additionalData.readInt();
        this.attributes = DinosaurAttributes.from(additionalData);
        if (this.isCarcass) {
            this.setAnimation(EntityAnimation.DYING.get());
        } else {
            this.setAnimation(EntityAnimation.IDLE.get());
        }
        this.updateAttributes();
        this.m_6210_();
    }

    public MetabolismContainer getMetabolism() {
        return this.metabolism;
    }

    public boolean setSleepLocation(BlockPos sleepLocation, boolean moveTo) {
        return !moveTo || this.m_21573_().m_26519_((double)sleepLocation.m_123341_(), (double)sleepLocation.m_123342_(), (double)sleepLocation.m_123343_(), 1.0);
    }

    public boolean m_5803_() {
        return this.isSleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.isSleeping = sleeping;
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(WATCHER_IS_SLEEPING, (Object)this.isSleeping);
        }
    }

    public void tranquilize(int ticks) {
        this.tranquilizerTicks = 50 + ticks + this.f_19796_.m_188503_(50);
        this.setSleeping(true);
        this.tranqed = true;
    }

    public int getStayAwakeTime() {
        return this.stayAwakeTime;
    }

    public void disturbSleep() {
        if (this.tranquilizerTicks == 0) {
            this.isSleeping = false;
            this.stayAwakeTime = 400;
        }
    }

    public void writeStatsToLog() {
        LOGGER.info(this.toString());
    }

    public String toString() {
        return "DinosaurEntity{ " + this.dinosaur.getName() + ", id=" + this.m_19879_() + ", remote=" + this.m_9236_().f_46443_ + ", isDead=" + this.m_21224_() + ", isCarcass=" + this.isCarcass + ", isSleeping=" + this.isSleeping + ", stayAwakeTime=" + this.stayAwakeTime + "\n    , dinosaurAge=" + this.dinosaurAge + ", prevAge=" + this.prevAge + ", maxAge" + this.dinosaur.getMaximumAge() + ", ticksExisted=" + this.f_19797_ + ", entityAge=" + this.f_20891_ + ", isMale=" + this.isMale + ", growthSpeedOffset=" + this.growthSpeedOffset + "\n    , food=" + this.metabolism.getEnergy() + " / " + this.metabolism.getMaxEnergy() + " (" + (double)this.metabolism.getMaxEnergy() * 0.875 + "), water=" + this.metabolism.getWater() + " / " + this.metabolism.getMaxWater() + " (" + (double)this.metabolism.getMaxWater() * 0.875 + "), digestingFood=" + this.metabolism.getDigestingFood() + " / 3000, health=" + this.m_21223_() + " / " + this.m_21233_() + "\n    , pos=" + this.m_146892_() + ", eyePos=" + this.getHeadPos() + ", eyeHeight=" + this.m_20192_() + ", lookX=" + this.m_20154_().f_82479_ + ", lookY=" + this.m_20154_().f_82480_ + ", lookZ=" + this.m_20154_().f_82481_ + "\n    , width=" + this.m_20205_() + ", bb=" + this.m_20191_() + ", owner=" + this.owner + ", inventory=" + this.inventory + " }";
    }

    public Vec3 getHeadPos() {
        boolean skeleton = this.isSkeleton();
        double scale = this.interpolate(this.dinosaur.getScaleInfant(skeleton), this.dinosaur.getScaleAdult(skeleton));
        double[] headPos = this.dinosaur.getHeadPosition(this.getGrowthStage(), (360.0f - this.f_20885_) % 360.0f - 180.0f);
        float offsetX = skeleton ? this.dinosaur.getSkeletonOffsetX() : this.dinosaur.getOffsetX();
        float offsetY = skeleton ? this.dinosaur.getSkeletonOffsetY() : this.dinosaur.getOffsetY();
        float offsetZ = skeleton ? this.dinosaur.getSkeletonOffsetZ() : this.dinosaur.getOffsetZ();
        double headX = (headPos[0] * 0.0625 - (double)offsetX) * scale;
        double headY = ((24.0 - headPos[1]) * 0.0625 - (double)offsetY) * scale;
        double headZ = (headPos[2] * 0.0625 - (double)offsetZ) * scale;
        return new Vec3(this.m_20185_() + headX, this.m_20186_() + headY, this.m_20189_() + headZ);
    }

    public boolean areEyelidsClosed() {
        return this.getDinosaurAge() != 4 && !this.dinosaur.isMarineCreature() && (this.isCarcass || this.isSleeping || this.f_19797_ % 100 < 4);
    }

    @Override
    public boolean shouldUseInertia() {
        return this.useInertialTweens;
    }

    public void setUseInertialTweens(boolean parUseInertialTweens) {
        this.useInertialTweens = parUseInertialTweens;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20069_() && !this.canDinoSwim()) {
            float friction = 9.1f;
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)friction));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void giveBirth() {
        this.pregnantTime = 1;
    }

    public void setDeathIn(int ticks) {
        this.ticksUntilDeath = ticks;
        this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, ticks));
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (!(!this.isSleeping || this.m_20365_(entity) || entity.f_19794_ || this.f_19794_ || entity.getClass().equals(this.getClass()))) {
            this.disturbSleep();
        }
    }

    public Order getOrder() {
        return this.order;
    }

    public void setFieldOrder(Order order) {
        this.order = order;
        this.f_19804_.m_135381_(WATCHER_CURRENT_ORDER, (Object)((byte)order.ordinal()));
        if (!this.f_19853_.f_46443_) {
            if (order == Order.SIT) {
                this.isSittingNaturally = false;
                this.m_21573_().m_26573_();
                this.m_6710_(null);
                this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
                if (!this.isSleeping) {
                    this.setAnimation(EntityAnimation.RESTING.get());
                }
            } else if (!this.isSleeping && !this.isSittingNaturally && this.getAnimation() == EntityAnimation.RESTING.get()) {
                this.setAnimation(EntityAnimation.IDLE.get());
            }
        }
    }

    public List<Class<? extends LivingEntity>> getAttackTargets() {
        return this.attackTargets;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance diff, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnData, @javax.annotation.Nullable CompoundTag dataTag) {
        SpawnGroupData out = super.m_6518_(level, diff, reason, spawnData, dataTag);
        this.metabolism.setEnergy(this.metabolism.getMaxEnergy());
        this.metabolism.setWater(this.metabolism.getMaxWater());
        if (this.genetics == null || this.genetics.isEmpty()) {
            this.genetics = GeneticsHelper.randomGenetics(this.f_19796_);
        }
        if (this.getDNAQuality() <= 0) {
            this.setDNAQuality(100);
        }
        this.setMale(this.f_19796_.m_188499_());
        this.m_6210_();
        return out;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void resetAttackCooldown() {
        this.attackCooldown = 50 + this.m_217043_().m_188503_(20);
    }

    public void respondToAttack(LivingEntity attacker) {
        if (!(attacker == null || attacker.m_21224_() || attacker instanceof Player && ((Player)attacker).m_7500_())) {
            if (attacker instanceof DinosaurEntity) {
                DinosaurEntity dinoAttacker = (DinosaurEntity)attacker;
                if (this.herd != null && dinoAttacker.herd == this.herd) {
                    return;
                }
            }
            LinkedList<LivingEntity> enemies = new LinkedList<LivingEntity>();
            if (attacker instanceof DinosaurEntity) {
                DinosaurEntity enemyDinosaur = (DinosaurEntity)attacker;
                if (enemyDinosaur.herd != null) {
                    enemies.addAll(enemyDinosaur.herd.members);
                }
            } else {
                enemies.add(attacker);
            }
            if (enemies.size() > 0) {
                Herd herd = this.herd;
                if (herd != null) {
                    herd.fleeing = !herd.shouldDefend(enemies) || this.dinosaur.shouldFlee();
                    for (LivingEntity entity : enemies) {
                        if (herd.enemies.contains(entity)) continue;
                        herd.enemies.add(entity);
                    }
                } else {
                    this.m_6710_((LivingEntity)enemies.get(this.m_217043_().m_188503_(enemies.size())));
                }
            }
        }
    }

    public int getAnimationLength() {
        return this.animationLength;
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(WATCHER_IS_RUNNING);
    }

    public boolean m_6914_(LevelReader pLevel) {
        if (!pLevel.m_5776_()) {
            return super.m_6914_(pLevel) && this.f_19853_.m_6042_().equals((Object)this.m_20194_().m_129783_().m_6042_());
        }
        return false;
    }

    public boolean shouldEscapeWaterFast() {
        return true;
    }

    private void handleLandDinosaurInFluid() {
        block8: {
            AABB detectionBox;
            Path path;
            block7: {
                boolean needsShoreSearch;
                boolean inWater = this.m_20072_();
                boolean inLava = this.inLava();
                if (!inWater && !inLava) {
                    return;
                }
                if (this.m_5803_()) {
                    this.disturbSleep();
                }
                this.m_21573_().m_7008_(true);
                float height = this.m_20206_();
                Vec3 motion = this.m_20184_();
                double sizeBoost = (double)Mth.m_14036_((float)(1.0f - height), (float)0.0f, (float)0.7f) * 0.08;
                double upward = (inWater ? 0.04 : 0.03) + sizeBoost;
                if (inWater && (this.m_5842_() || this.m_204029_(FluidTags.f_13131_)) || inLava) {
                    upward += 0.04;
                }
                if (motion.f_82480_ < upward) {
                    this.m_20334_(motion.f_82479_, upward, motion.f_82481_);
                    this.f_19812_ = true;
                    this.f_19789_ = 0.0f;
                }
                boolean bl = needsShoreSearch = (this.m_21573_().m_26571_() || this.f_19797_ % 40 == 0 && this.shouldEscapeWaterFast()) && (this.inWater() || this.inLava());
                if (!needsShoreSearch) break block7;
                BlockPos shore = AIUtils.findShore(this.f_19853_, this.m_20183_());
                boolean pathFound = false;
                if (shore != null) {
                    double speed = 1.2 + (double)Math.max(0.0f, 1.0f - height) * 0.6;
                    pathFound = this.m_21573_().m_26519_((double)shore.m_123341_() + 0.5, (double)shore.m_123342_(), (double)shore.m_123343_() + 0.5, speed);
                }
                if (pathFound) break block8;
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                break block8;
            }
            if (this.m_20069_() && (path = this.m_21573_().m_26570_()) != null && !this.f_19853_.m_45772_(detectionBox = this.m_20191_().m_82377_(0.5, 0.5, 0.5))) {
                for (VoxelShape shape : this.f_19853_.m_186434_((Entity)this, detectionBox)) {
                    AABB box = shape.m_83215_();
                    if (!(box.f_82292_ > this.m_20191_().f_82289_)) continue;
                    this.m_6862_(true);
                    break;
                }
            }
        }
    }

    public void target(Class<? extends LivingEntity> ... entities) {
        if (this.taskHelper == null) {
            this.taskHelper = new TaskHelper(this.getClass());
        }
        this.attackTargets.addAll(Arrays.asList(entities));
        this.taskHelper.addGoal((Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, true, true, livingEntity -> DinosaurEntity.entityPredicate(livingEntity, entities)), 3);
    }

    public static boolean entityPredicate(LivingEntity input, Class<? extends LivingEntity> ... entities) {
        return Arrays.stream(entities).anyMatch(clazz -> clazz.isAssignableFrom(input.getClass()));
    }

    public void addTask(int priority, Goal goal) {
        if (this.taskHelper == null) {
            this.taskHelper = new TaskHelper(this.getClass());
        }
        this.taskHelper.addGoal(goal, priority);
        if (this.goalsRegistered) {
            if (goal instanceof TargetGoal) {
                this.f_21346_.m_25352_(priority, (Goal)((TargetGoal)goal));
            } else {
                this.f_21345_.m_25352_(priority, goal);
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.dinosaur == null) {
            return;
        }
        if (!(this.dinosaur.isMarineCreature() || this instanceof AmphibianDinosaurEntity || this instanceof PenguinDinosaurEntity)) {
            this.f_21345_.m_25352_(0, (Goal)new AdvancedSwimEntityAI(this));
        }
        this.f_21345_.m_25352_(0, (Goal)new EscapeWireEntityAI(this));
        this.f_21345_.m_25352_(0, (Goal)new FeederEntityAI(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new RespondToAttackEntityAI(this));
        this.f_21345_.m_25352_(1, (Goal)new TemptNonAdultEntityAI(this, 0.6));
        if (this.dinosaur.getDiet().canEat(this, FoodType.PLANT)) {
            this.f_21345_.m_25352_(2, (Goal)new GrazeEntityAI(this));
        }
        if (this.dinosaur.getDiet().canEat(this, FoodType.MEAT) || this.dinosaur.getDiet().canEat(this, FoodType.FISH)) {
            this.f_21345_.m_25352_(1, (Goal)new TargetCarcassAI(this));
        }
        if (this.dinosaur.shouldDefendOwner()) {
            this.f_21345_.m_25352_(2, (Goal)new DefendOwnerAI(this));
            this.f_21345_.m_25352_(2, (Goal)new AssistOwnerAI(this));
        }
        if (this.dinosaur.shouldFlee()) {
            this.f_21345_.m_25352_(2, (Goal)new FleeAI(this));
        }
        this.f_21345_.m_25352_(2, new ProtectInfantAI<DinosaurEntity>(this));
        this.f_21345_.m_25352_(1, (Goal)new DinosaurAttackMeleeEntityAI(this, this.dinosaur.getAttackSpeed(), true));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerAI(this));
        this.f_21345_.m_25352_(3, (Goal)new DinosaurWanderEntityAI(this, 0.8, 2, 10));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SleepEntityAI(this));
        this.f_21345_.m_25352_(2, (Goal)new DrinkEntityAI(this));
        this.f_21345_.m_25352_(1, (Goal)new MateEntityAI(this));
        this.f_21345_.m_25352_(3, (Goal)new EatFoodItemEntityAI(this));
        this.f_21345_.m_25352_(3, (Goal)new CallAnimationAI(this));
        this.f_21345_.m_25352_(3, (Goal)new RoarAnimationAI(this));
        this.f_21345_.m_25352_(3, (Goal)new LookAnimationAI(this));
        this.f_21345_.m_25352_(3, (Goal)new HeadCockAnimationAI(this));
        if (this.dinosaur.getDinosaurType() == Dinosaur.DinosaurType.AGGRESSIVE) {
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        if (this.taskHelper != null) {
            this.taskHelper.setSelectorsAndRegisterGoals(this.f_21345_, this.f_21346_);
        }
    }

    public BlockPos getClosestFeeder() {
        Level lvl = this.f_19853_;
        if (lvl == null || lvl.f_46443_) {
            return this.closestFeeder;
        }
        if (this.closestFeeder != null && this.isFeederUsable(this.closestFeeder)) {
            BlockPos here = this.m_20183_();
            if (this.closestFeeder.m_123331_((Vec3i)here) <= 256.0) {
                return this.closestFeeder;
            }
            this.closestFeeder = null;
        } else {
            this.closestFeeder = null;
        }
        if (this.f_19797_ < this.feederSearchTick) {
            return null;
        }
        this.feederSearchTick = this.f_19797_ + 20 + this.m_217043_().m_188503_(20);
        int px = Mth.m_14107_((double)this.m_20185_());
        int py = Mth.m_14107_((double)this.m_20186_());
        int pz = Mth.m_14107_((double)this.m_20189_());
        int minY = Math.max(lvl.m_141937_(), py - 8);
        int maxY = Math.min(lvl.m_151558_() - 1, py + 8);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos bestPos = null;
        int bestDist = Integer.MAX_VALUE;
        BlockPos bestWaitingPos = null;
        int bestWaitingDist = Integer.MAX_VALUE;
        for (int x = px - 16; x <= px + 16; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = pz - 16; z <= pz + 16; ++z) {
                    FeederBlockEntity feeder;
                    BlockEntity be;
                    cursor.m_122178_(x, y, z);
                    if (!lvl.m_46805_((BlockPos)cursor) || !((be = lvl.m_7702_((BlockPos)cursor)) instanceof FeederBlockEntity) || !(feeder = (FeederBlockEntity)be).canFeedDinosaur(this) || !feeder.isStockedFor(this)) continue;
                    boolean reservedForSelf = feeder.getFeeding() == this;
                    boolean busy = !reservedForSelf && feeder.getFeeding() != null;
                    boolean opening = feeder.openAnimation != 0 && !reservedForSelf;
                    int dx = x - px;
                    int dy = y - py;
                    int dz = z - pz;
                    int distance = dx * dx + dy * dy + dz * dz;
                    if (!busy && !opening) {
                        if (distance >= bestDist) continue;
                        bestDist = distance;
                        bestPos = cursor.m_7949_();
                        continue;
                    }
                    if (distance >= bestWaitingDist) continue;
                    bestWaitingDist = distance;
                    bestWaitingPos = cursor.m_7949_();
                }
            }
        }
        this.closestFeeder = bestPos != null ? bestPos : bestWaitingPos;
        return this.closestFeeder;
    }

    private boolean isFeederUsable(BlockPos pos) {
        Level lvl = this.f_19853_;
        if (lvl == null || pos == null || !lvl.m_46805_(pos)) {
            return false;
        }
        BlockEntity blockEntity = lvl.m_7702_(pos);
        if (!(blockEntity instanceof FeederBlockEntity)) {
            return false;
        }
        FeederBlockEntity feeder = (FeederBlockEntity)blockEntity;
        if (!feeder.canFeedDinosaur(this) || !feeder.isStockedFor(this)) {
            return false;
        }
        return feeder.getFeeding() == null || feeder.getFeeding() == this;
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    @Override
    public boolean isMoving() {
        Vec3 motion = this.m_20184_();
        return motion.m_165925_() > 1.0E-5;
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return this.dinosaur.doesSupportGrowthStage(growthStage);
    }

    @Override
    public boolean isMarineCreature() {
        return this.dinosaur.isMarineCreature();
    }

    public <E extends LivingEntity> PoseHandler<E> getPoseHandler() {
        return this.dinosaur.getPoseHandler();
    }

    @Override
    public boolean inWater() {
        return this.m_20069_();
    }

    @Override
    public boolean inLava() {
        return this.inLava;
    }

    public DinosaurAttributes getLegacyAttributes() {
        return this.attributes;
    }

    public boolean isBreeding() {
        return this.breeding != null;
    }

    public void setAttributes(DinosaurAttributes attributes) {
        this.attributes = attributes;
    }

    public void setJumpHeight(int jumpHeight) {
        this.jumpHeight = jumpHeight;
    }

    protected float getJumpUpwardsMotion() {
        return (float)Math.sqrt(((double)this.jumpHeight + 0.2) * 0.27);
    }

    public boolean isSkeleton() {
        return this.getGrowthStage() == GrowthStage.SKELETON;
    }

    public void setSkeleton(boolean isSkeleton) {
        this.isSkeleton = isSkeleton;
    }

    public void setSkeletonVariant(byte variant) {
        this.skeletonVariant = variant;
    }

    public byte getSkeletonVariant() {
        return this.skeletonVariant;
    }

    public void setIsFossile(boolean isFossile) {
        this.isFossile = isFossile;
    }

    public boolean getIsFossile() {
        return this.isFossile;
    }

    public boolean canDinoSwim() {
        return true;
    }

    public Vector3f getDinosaurCultivatorRotation() {
        this.setAnimation(EntityAnimation.GESTATED.get());
        return new Vector3f();
    }

    public FieldGuideInfo getFieldGuideInfo() {
        return FieldGuideInfo.fromEntity(this);
    }

    static {
        CLASS_TYPE_LIST.put(AchillobatorEntity.class, ModEntities.ACHILLOBATOR_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(AlligatorGarEntity.class, ModEntities.ALLIGATOR_GAR);
        CLASS_TYPE_LIST.put(AllosaurusEntity.class, ModEntities.ALLOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(AlvarezsaurusEntity.class, ModEntities.ALVAREZSAURUS);
        CLASS_TYPE_LIST.put(AnkylodocusEntity.class, ModEntities.ANKYLODOCUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(AnkylosaurusEntity.class, ModEntities.ANKYLOSAURUS);
        CLASS_TYPE_LIST.put(ApatosaurusEntity.class, ModEntities.APATOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(ArsinoitheriumEntity.class, ModEntities.ARSINOITHERIUM);
        CLASS_TYPE_LIST.put(BaryonyxEntity.class, ModEntities.BARYONYX);
        CLASS_TYPE_LIST.put(BeelzebufoEntity.class, ModEntities.BEELZEBUFO_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(BrachiosaurusEntity.class, ModEntities.BRACHIOSAURUS);
        CLASS_TYPE_LIST.put(CamarasaurusEntity.class, ModEntities.CAMARASAURUS);
        CLASS_TYPE_LIST.put(NigersaurusEntity.class, ModEntities.NIGERSAURUS);
        CLASS_TYPE_LIST.put(CarcharodontosaurusEntity.class, ModEntities.CARCHARODONTOSAURUS);
        CLASS_TYPE_LIST.put(CarnotaurusEntity.class, ModEntities.CARNOTAURUS);
        CLASS_TYPE_LIST.put(CearadactylusEntity.class, ModEntities.CEARADACTYLUS);
        CLASS_TYPE_LIST.put(CeratosaurusEntity.class, ModEntities.CERATOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(ChasmosaurusEntity.class, ModEntities.CHASMOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(ChilesaurusEntity.class, ModEntities.CHILESAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(CoelacanthEntity.class, ModEntities.COELACANTH_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(CoelurusEntity.class, ModEntities.COELURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(CompsognathusEntity.class, ModEntities.COMPSOGNATHUS);
        CLASS_TYPE_LIST.put(CorythosaurusEntity.class, ModEntities.CORYTHOSAURUS);
        CLASS_TYPE_LIST.put(CrassigyrinusEntity.class, ModEntities.CRASSIGYRINUS);
        CLASS_TYPE_LIST.put(DeinotheriumEntity.class, ModEntities.DEINOTHERIUM);
        CLASS_TYPE_LIST.put(DilophosaurusEntity.class, ModEntities.DILOPHOSAURUS);
        CLASS_TYPE_LIST.put(DimorphodonEntity.class, ModEntities.DIMORPHODON_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(DiplocaulusEntity.class, ModEntities.DIPLOCAULUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(DiplodocusEntity.class, ModEntities.DIPLODOCUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(DodoEntity.class, ModEntities.DODO);
        CLASS_TYPE_LIST.put(DreadnoughtusEntity.class, ModEntities.DREADNOUGHTUS);
        CLASS_TYPE_LIST.put(DunkleosteusEntity.class, ModEntities.DUNKLEOSTEUS);
        CLASS_TYPE_LIST.put(EdmontosaurusEntity.class, ModEntities.EDMONTOSAURUS);
        CLASS_TYPE_LIST.put(ElasmotheriumEntity.class, ModEntities.ELASMOTHERIUM);
        CLASS_TYPE_LIST.put(GallimimusEntity.class, ModEntities.GALLIMIMUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(GiganotosaurusEntity.class, ModEntities.GIGANOTOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(GuanlongEntity.class, ModEntities.GUANLONG_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(HerrerasaurusEntity.class, ModEntities.HERRERASAURUS);
        CLASS_TYPE_LIST.put(HyaenodonEntity.class, ModEntities.HYAENODON_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(HypsilophodonEntity.class, ModEntities.HYPSILOPHODON);
        CLASS_TYPE_LIST.put(IndominusEntity.class, ModEntities.INDOMINUS);
        CLASS_TYPE_LIST.put(IndoraptorEntity.class, ModEntities.INDORAPTOR);
        CLASS_TYPE_LIST.put(LambeosaurusEntity.class, ModEntities.LAMBEOSAURUS);
        CLASS_TYPE_LIST.put(LeaellynasauraEntity.class, ModEntities.LEAELLYNASAURA_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(LeptictidiumEntity.class, ModEntities.LEPTICTIDIUM_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(LudodactylusEntity.class, ModEntities.LUDODACTYLUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MajungasaurusEntity.class, ModEntities.MAJUNGASAURUS);
        CLASS_TYPE_LIST.put(MamenchisaurusEntity.class, ModEntities.MAMENCHISAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MammothEntity.class, ModEntities.MAMMOTH);
        CLASS_TYPE_LIST.put(MawsoniaEntity.class, ModEntities.MAWSONIA_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MegapiranhaEntity.class, ModEntities.MEGAPIRANHA_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MegatheriumEntity.class, ModEntities.MEGATHERIUM_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MetriacanthosaurusEntity.class, ModEntities.METRIACANTHOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MicroceratusEntity.class, ModEntities.MICROCERATUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MicroraptorEntity.class, ModEntities.MICRORAPTOR);
        CLASS_TYPE_LIST.put(MoganopterusEntity.class, ModEntities.MOGANOPTERUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MosasaurusEntity.class, ModEntities.MOSASAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MussaurusEntity.class, ModEntities.MUSSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(OrnithomimusEntity.class, ModEntities.ORNITHOMIMUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(OthnieliaEntity.class, ModEntities.OTHNIELIA);
        CLASS_TYPE_LIST.put(OviraptorEntity.class, ModEntities.OVIRAPTOR);
        CLASS_TYPE_LIST.put(PachycephalosaurusEntity.class, ModEntities.PACHYCEPHALOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(ParasaurolophusEntity.class, ModEntities.PARASAUROLOPHUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(PostosuchusEntity.class, ModEntities.POSTOSUCHUS);
        CLASS_TYPE_LIST.put(ProceratosaurusEntity.class, ModEntities.PROCERATOSAURUS);
        CLASS_TYPE_LIST.put(ProtoceratopsEntity.class, ModEntities.PROTOCERATOPS);
        CLASS_TYPE_LIST.put(PteranodonEntity.class, ModEntities.PTERANODON);
        CLASS_TYPE_LIST.put(QuetzalEntity.class, ModEntities.QUETZAL);
        CLASS_TYPE_LIST.put(RaphusrexEntity.class, ModEntities.RAPHUSREX);
        CLASS_TYPE_LIST.put(RugopsEntity.class, ModEntities.RUGOPS);
        CLASS_TYPE_LIST.put(SegisaurusEntity.class, ModEntities.SEGISAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(SinoceratopsEntity.class, ModEntities.SINOCERATOPS);
        CLASS_TYPE_LIST.put(SmilodonEntity.class, ModEntities.SMILODON_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(SpinoraptorEntity.class, ModEntities.SPINORAPTOR_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(SpinosaurusEntity.class, ModEntities.SPINOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(StegosaurusEntity.class, ModEntities.STEGOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(StyracosaurusEntity.class, ModEntities.STYRACOSAURUS);
        CLASS_TYPE_LIST.put(SuchomimusEntity.class, ModEntities.SUCHOMIMUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(TherizinosaurusEntity.class, ModEntities.THERIZINOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(TitanisEntity.class, ModEntities.TITANIS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(TriceratopsEntity.class, ModEntities.TRICERATOPS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(TroodonEntity.class, ModEntities.TROODON);
        CLASS_TYPE_LIST.put(TropeognathusEntity.class, ModEntities.TROPEOGNATHUS);
        CLASS_TYPE_LIST.put(TylosaurusEntity.class, ModEntities.TYLOSAURUS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(TyrannosaurusEntity.class, ModEntities.TYRANNOSAURUS);
        CLASS_TYPE_LIST.put(VelociraptorBlueEntity.class, ModEntities.VELOCIRAPTORBLUE_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(VelociraptorCharlieEntity.class, ModEntities.VELOCIRAPTORCHARLIE_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(VelociraptorDeltaEntity.class, ModEntities.VELOCIRAPTORDELTA);
        CLASS_TYPE_LIST.put(VelociraptorEchoEntity.class, ModEntities.VELOCIRAPTORECHO_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(VelociraptorEntity.class, ModEntities.VELOCIRAPTOR_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(ZhenyuanopterusEntity.class, ModEntities.ZHENYUANOPTERUS);
        CLASS_TYPE_LIST.put(DimetrodonEntity.class, ModEntities.DIMETRODON_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(AsterocerasEntity.class, ModEntities.ASTEROCERAS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(TitanitesEntity.class, ModEntities.TITANITES_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(ParapuzosiaEntity.class, ModEntities.PARAPUZOSIA_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(CamerocerasEntity.class, ModEntities.CAMEROCERAS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(EndocerasEntity.class, ModEntities.ENDOCERAS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(OrthocerasEntity.class, ModEntities.ORTHOCERAS_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(VectipeltaEntity.class, ModEntities.VECTIPELTA);
        CLASS_TYPE_LIST.put(ParaceratheriumEntity.class, ModEntities.PARACERATHERIUM);
        CLASS_TYPE_LIST.put(PerisphinctesEntity.class, ModEntities.PERISPHINCTES);
        CLASS_TYPE_LIST.put(CalymeneEntity.class, ModEntities.CALYMENE_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(LivyatanEntity.class, ModEntities.LIVYATAN_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(MegalodonEntity.class, ModEntities.MEGALODON_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(KairukuEntity.class, ModEntities.KAIRUKU_ENTITY_TYPE);
        CLASS_TYPE_LIST.put(DeinosuchusEntity.class, ModEntities.DEINOSUCHUS);
        CLASS_TYPE_LIST.put(MaiasauraEntity.class, ModEntities.MAIASAURA);
        CLASS_TYPE_LIST.put(PatagotitanEntity.class, ModEntities.PATAGOTITAN);
    }

    public static enum Order {
        WANDER,
        FOLLOW,
        SIT;

    }

    public static class FieldGuideInfo {
        public int hunger;
        public int thirst;
        public boolean flocking;
        public boolean scared;
        public boolean hungry;
        public boolean thirsty;
        public boolean poisoned;

        public static FieldGuideInfo fromEntity(DinosaurEntity entity) {
            MetabolismContainer metabolism = entity.getMetabolism();
            Herd herd = entity.herd;
            FieldGuideInfo info = new FieldGuideInfo();
            info.flocking = herd != null && herd.members.size() > 1 && herd.state == Herd.State.MOVING;
            info.scared = herd != null && herd.fleeing;
            info.hunger = metabolism.getEnergy();
            info.thirst = metabolism.getWater();
            info.hungry = metabolism.isHungry();
            info.thirsty = metabolism.isThirsty();
            info.poisoned = entity.m_21023_(MobEffects.f_19614_);
            return info;
        }

        public static void write(FriendlyByteBuf buf, FieldGuideInfo info) {
            buf.writeBoolean(info.flocking);
            buf.writeBoolean(info.scared);
            buf.writeInt(info.hunger);
            buf.writeInt(info.thirst);
            buf.writeBoolean(info.hungry);
            buf.writeBoolean(info.thirsty);
            buf.writeBoolean(info.poisoned);
        }

        public static FieldGuideInfo read(FriendlyByteBuf buf) {
            FieldGuideInfo info = new FieldGuideInfo();
            info.flocking = buf.readBoolean();
            info.scared = buf.readBoolean();
            info.hunger = buf.readInt();
            info.thirst = buf.readInt();
            info.hungry = buf.readBoolean();
            info.thirsty = buf.readBoolean();
            info.poisoned = buf.readBoolean();
            return info;
        }
    }
}

