/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CearadactylusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class CearadactylusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public CearadactylusDinosaur() {
        this.setName("Cearadactylus");
        this.setScientificName("Cearadactylus atrox");
        this.setFamily("Ornithocheiridae");
        this.setLocation("Brazil");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(CearadactylusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(6594739, 3881271);
        this.setEggColorFemale(0xB55252, 4997690);
        this.setHealth(10.0, 20.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStrength(1.0, 10.0);
        this.setMaximumAge(this.fromDays(50));
        this.setEyeHeight(0.25f, 1.25f);
        this.setSizeX(0.15f, 1.0f);
        this.setSizeY(0.35f, 1.35f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("leg_bones", "pelvis", "skull", "neck_vertebrae", "tail_vertebrae", "teeth", "wing_bones", "ribcage");
        this.setHeadCubeName("Head");
        this.setScale(1.0f, 0.1f);
        this.setAvianAnimal(true);
        this.setBreeding(false, 2, 6, 80, false, true);
        this.shouldDefendOffspring();
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "", "teeth"}, {"", "leg_bones", "", "wing_bones", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_215816_, BiomeTags.f_207610_, BiomeTags.f_207606_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

