/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.ElasmotheriumEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class ElasmotheriumDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public ElasmotheriumDinosaur() {
        this.setName("Elasmotherium");
        this.setScientificName("Elasmotherium sibiricum");
        this.setFamily("Rhinocerotidae");
        this.setLocation("Eurasia");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(ElasmotheriumEntity.class);
        this.setTimePeriod(TimePeriod.NEOGENE);
        this.setEggColorMale(7359031, 0xFFFFFF);
        this.setEggColorFemale(2300680, 6375172);
        this.setHealth(10.0, 40.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStorage(27);
        this.setStrength(5.0, 25.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.45f, 2.45f);
        this.setSizeX(0.35f, 2.2f);
        this.setSizeY(0.5f, 2.5f);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("skull", "teeth", "front_leg_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(1.7f, 0.45f);
        this.setMammal(true);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.shouldDefendOffspring();
        this.setAttackBias(400.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setBreeding(true, 2, 4, 40, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "teeth", ""}, {"", "hind_leg_bones", "", "front_leg_bones", "shoulder"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_215816_, Tags.Biomes.IS_CONIFEROUS, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_, Tags.Biomes.IS_SNOWY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

