/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LambeosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class LambeosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.41f;

    public LambeosaurusDinosaur() {
        this.setName("Lambeosaurus");
        this.setScientificName("Lambeosaurus laticaudus");
        this.setFamily("Hadrosauridae");
        this.setLocation("Canada");
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setDinosaurClass(LambeosaurusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(8557690, 3092777);
        this.setEggColorFemale(0x898969, 4607034);
        this.setHealth(10.0, 60.0);
        this.setSpeed(0.3599999964237213, 0.41f);
        this.setStrength(5.0, 20.0);
        this.setMaximumAge(this.fromDays(50));
        this.setEyeHeight(0.25f, 3.4f);
        this.setSizeX(0.2f, 2.8f);
        this.setSizeY(0.3f, 3.5f);
        this.setStorage(45);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("cheek_teeth", "front_leg_bones", "hind_leg_bones", "neck_vertebrae", "shoulder", "pelvis", "ribcage", "skull", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(1.0f, 0.05f);
        this.setAttackBias(-50.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setFlockSpeed(1.5f);
        this.setBreeding(false, 2, 6, 40, false, true);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "", "", "shoulder", "cheek_teeth"}, {"", "", "", "", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_215816_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207607_, Tags.Biomes.IS_SANDY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

