/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class LeptictidiumDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.39f;

    public LeptictidiumDinosaur() {
        this.setName("Leptictidium");
        this.setScientificName("Leptictidium auderiense");
        this.setFamily("Leptictidae");
        this.setLocation("Europe");
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setDinosaurClass(LeptictidiumEntity.class);
        this.setTimePeriod(TimePeriod.PALEOGENE);
        this.setEggColorMale(3548176, 9931384);
        this.setEggColorFemale(11510398, 4074775);
        this.setHealth(4.0, 14.0);
        this.setStrength(2.0, 4.0);
        this.setSpeed(0.33999998569488527, 0.39f);
        this.setMaximumAge(this.fromDays(25));
        this.setEyeHeight(0.14f, 0.7f);
        this.setSizeX(0.1f, 0.5f);
        this.setSizeY(0.15f, 0.75f);
        this.setMammal(true);
        this.setDiet(Diet.INHERBIVORE.get());
        this.setBones("arm_bones", "leg_bones", "pelvis", "ribcage", "skull", "tail_vertebrae", "teeth", "neck_vertebrae", "shoulder");
        this.setHeadCubeName("Head");
        this.setScale(0.3f, 0.15f);
        this.setAttackBias(-50.0);
        this.setImprintable(true);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setStorage(12);
        this.setBreeding(true, 2, 4, 20, false, true);
        String[][] recipe = new String[][]{{"", "pelvis", "", "", ""}, {"tail_vertebrae", "ribcage", "shoulder", "neck_vertebrae", "skull"}, {"leg_bones", "", "", "arm_bones", "teeth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_215816_, Tags.Biomes.IS_CONIFEROUS, BiomeTags.f_207607_, Tags.Biomes.IS_SNOWY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

