/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MammothEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MammothDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public MammothDinosaur() {
        this.setName("Mammoth");
        this.setScientificName("Mammuthus primigenius");
        this.setFamily("Elephantidae");
        this.setLocation("North America");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(MammothEntity.class);
        this.setTimePeriod(TimePeriod.NEOGENE);
        this.setEggColorMale(8668186, 6374706);
        this.setEggColorFemale(6834989, 7294521);
        this.setHealth(10.0, 60.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStorage(27);
        this.setStrength(5.0, 25.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.9f, 2.6f);
        this.setSizeX(0.85f, 2.4f);
        this.setSizeY(1.0f, 2.7f);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("skull", "tooth", "front_leg_bones", "hind_leg_bones", "tusks", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(1.9f, 0.45f);
        this.setMammal(true);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.shouldDefendOffspring();
        this.setAttackBias(400.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setBreeding(true, 2, 4, 40, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "tooth", "tusks"}, {"", "hind_leg_bones", "", "front_leg_bones", "shoulder"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_215816_, Tags.Biomes.IS_CONIFEROUS, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_, Tags.Biomes.IS_SNOWY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

