/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegapiranhaEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MegapiranhaDinosaur
extends Dinosaur {
    public static final double SPEED = 0.5;

    public MegapiranhaDinosaur() {
        this.setName("Megapiranha");
        this.setScientificName("Megapiranha paranensis");
        this.setFamily("Serrasalmidae");
        this.setLocation("Argentina");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(MegapiranhaEntity.class);
        this.setTimePeriod(TimePeriod.NEOGENE);
        this.setEggColorMale(1511435, 6577236);
        this.setEggColorFemale(8221533, 0x322922);
        this.setHealth(2.0, 12.0);
        this.setSpeed(0.35, 0.5);
        this.setStrength(4.0, 8.0);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.15f, 0.65f);
        this.setSizeX(0.15f, 0.5f);
        this.setSizeY(0.15f, 0.7f);
        this.setStorage(18);
        this.setDiet(Diet.PISCIVORE.get().withModule(new Diet.DietModule(FoodType.FILTER)));
        this.setBones("anal_fin", "body_fins", "caudal_fin", "dorsal_fin", "skull", "spine", "teeth");
        this.setHeadCubeName("Neck ");
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setScale(1.0f, 0.15f);
        this.setOffset(0.0f, 0.65f, -0.25f);
        this.setMarineAnimal(true);
        this.setAttackBias(400.0);
        this.setImprintable(false);
        this.setBreeding(true, 2, 6, 20, false, true);
        String[][] recipe = new String[][]{{"", "dorsal_fin", "", ""}, {"caudal_fin", "spine", "body_fins", "skull"}, {"anal_fin", "", "", "teeth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

