/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PteranodonEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class PteranodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public PteranodonDinosaur() {
        this.setName("Pteranodon");
        this.setScientificName("Pteranodon longiceps");
        this.setFamily("Pteranodontidae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(PteranodonEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(5722188, 2373695);
        this.setEggColorFemale(5463909, 5648684);
        this.setHealth(10.0, 35.0);
        this.setStrength(2.0, 20.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setMaximumAge(this.fromDays(40));
        this.setEyeHeight(0.34f, 1.35f);
        this.setSizeX(0.15f, 1.0f);
        this.setSizeY(0.35f, 1.35f);
        this.setStorage(27);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("leg_bones", "neck_vertebrae", "pelvis", "ribcage", "skull", "tail_vertebrae", "wing_bones");
        this.setHeadCubeName("Head");
        this.setScale(1.2f, 0.1f);
        this.setAttackBias(800.0);
        this.shouldDefendOffspring();
        this.setImprintable(false);
        this.setAvianAnimal(true);
        this.setBreeding(false, 2, 6, 80, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "", ""}, {"", "leg_bones", "", "wing_bones", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_215816_, BiomeTags.f_207610_, BiomeTags.f_207606_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207607_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

