/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TroodonEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class TroodonDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public TroodonDinosaur() {
        this.setName("Troodon");
        this.setScientificName("Troodon formosus");
        this.setFamily("Troodontidae");
        this.setLocation("North America");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(TroodonEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(10332794, 6515559);
        this.setEggColorFemale(10659452, 0x646D66);
        this.setHealth(4.0, 20.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStrength(1.0, 5.0);
        this.setMaximumAge(this.fromDays(35));
        this.setEyeHeight(0.15f, 0.9f);
        this.setSizeX(0.15f, 0.7f);
        this.setSizeY(0.2f, 0.95f);
        this.setStorage(12);
        this.setDiet(Diet.CARNIVORE.get());
        this.setSleepTime(SleepTime.NOCTURNAL);
        this.setBones("arm_bones", "foot_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("head UPPER");
        this.setAttackBias(600.0);
        this.setScale(0.25f, 0.05f);
        this.setOffset(0.0f, 0.0f, 0.5f);
        this.setAttackSpeed(1.2f);
        this.shouldDefendOffspring();
        this.setCanClimb(true);
        this.setDefendOwner(true);
        this.setBreeding(false, 1, 7, 28, false, true);
        this.setJumpHeight(2);
        this.setImprintable(true);
        String[][] recipe = new String[][]{{"", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder"}, {"", "leg_bones", "arm_bones", "tooth"}, {"", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_215816_, BiomeTags.f_207610_, Tags.Biomes.IS_CONIFEROUS, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

