/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.EntityUtils.ai;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.ai.util.AIUtils;
import net.vit.jurassicreborn.common.util.BlockPosUtil;
import net.vit.jurassicreborn.common.util.GameRuleHandler;

public class Herd
implements Iterable<DinosaurEntity> {
    public Set<DinosaurEntity> members = new HashSet<DinosaurEntity>();
    public DinosaurEntity leader;
    private Vec3 center;
    private float moveX;
    private float moveZ;
    public State state = State.IDLE;
    public int stateTicks;
    private final Random random = new Random();
    public Set<LivingEntity> enemies = new HashSet<LivingEntity>();
    public boolean fleeing;
    private final Dinosaur herdType;
    private int nextMemberCheck;
    private int failedPathTicks;
    private final Predicate<Entity> isDino = entity -> entity instanceof DinosaurEntity;

    public Herd(DinosaurEntity leader) {
        this.herdType = leader.getDinosaur();
        this.members.add(leader);
        this.leader = leader;
        this.resetStateTicks();
    }

    public void update() {
        if (this.leader == null || this.leader.isCarcass() || this.leader.m_21224_()) {
            this.updateLeader();
        }
        if (this.stateTicks > 0 && this.failedPathTicks < this.members.size() * 2) {
            --this.stateTicks;
        } else {
            this.state = this.herdType.shouldRandomlyFlock() ? (this.state == State.MOVING ? State.IDLE : State.MOVING) : State.IDLE;
            this.resetStateTicks();
            this.enemies.clear();
            this.fleeing = false;
        }
        if (this.leader != null) {
            if (this.leader.shouldSleep()) {
                this.state = State.IDLE;
                this.resetStateTicks();
            }
            this.center = this.getCenterPosition();
            if (!this.enemies.isEmpty()) {
                if (this.fleeing) {
                    this.state = State.MOVING;
                    float angle = 0.0f;
                    for (LivingEntity attacker : this.enemies) {
                        angle = (float)((double)angle + Mth.m_14136_((double)(this.center.f_82481_ - attacker.m_20189_()), (double)(this.center.f_82479_ - attacker.m_20185_())));
                    }
                    this.moveX = -Mth.m_14089_((float)(angle /= (float)this.enemies.size()));
                    this.moveZ = Mth.m_14031_((float)angle);
                    this.normalizeMovement();
                } else {
                    this.state = State.IDLE;
                }
            } else {
                this.fleeing = false;
            }
            LinkedList<DinosaurEntity> remove = new LinkedList<DinosaurEntity>();
            for (DinosaurEntity entity : this) {
                if (!(entity.m_20275_(this.center.f_82479_, this.center.f_82480_, this.center.f_82481_) > 2048.0)) continue;
                remove.add(entity);
            }
            for (DinosaurEntity entity : remove) {
                this.splitHerd(entity);
                if (entity != this.leader) continue;
                this.updateLeader();
            }
            if (this.leader == null) {
                return;
            }
            boolean attemptedPath = false;
            int failedPaths = 0;
            for (DinosaurEntity entity : this) {
                if (this.enemies.isEmpty() || this.fleeing) {
                    boolean canMove;
                    BlockPos shore;
                    int hz;
                    double speed;
                    if (entity.getMetabolism().isHungry() || entity.getMetabolism().isThirsty() || entity.m_6107_() || entity.m_20069_() || !this.fleeing && !entity.m_21573_().m_26571_() || this.state != State.MOVING && this.random.nextInt(50) != 0) continue;
                    float entityMoveX = this.moveX * 8.0f;
                    float entityMoveZ = this.moveZ * 8.0f;
                    double centerDistSq = entity.m_20275_(this.center.f_82479_, entity.m_20186_(), this.center.f_82481_);
                    if (this.fleeing) {
                        centerDistSq *= 4.0;
                    }
                    if (centerDistSq > 0.0) {
                        entityMoveX += (float)((this.center.f_82479_ - entity.m_20185_()) / centerDistSq);
                        entityMoveZ += (float)((this.center.f_82481_ - entity.m_20189_()) / centerDistSq);
                    }
                    for (DinosaurEntity other : this) {
                        double sep;
                        double sepSq;
                        double distSq;
                        if (other == entity || !((distSq = entity.m_20280_((Entity)other)) < (sepSq = (sep = (double)(entity.m_20205_() * 1.5f + 1.5f)) * sep)) || !(distSq > 1.0E-4)) continue;
                        double scale = Math.max(distSq / sepSq, 1.0E-4);
                        entityMoveX += (float)((entity.m_20185_() - other.m_20185_()) / scale);
                        entityMoveZ += (float)((entity.m_20189_() - other.m_20189_()) / scale);
                    }
                    double navigateX = entity.m_20185_() + (double)entityMoveX;
                    double navigateZ = entity.m_20189_() + (double)entityMoveZ;
                    Dinosaur dinosaur = entity.getDinosaur();
                    double d = speed = this.state == State.IDLE ? 0.8 : dinosaur.getFlockSpeed();
                    if (this.fleeing && dinosaur.getAttackSpeed() > speed) {
                        speed = dinosaur.getAttackSpeed();
                    }
                    if (entity.disableHerdingTicks > 0 || entity.m_5448_() != null || this.members.size() <= 1 && !this.fleeing) continue;
                    int hx = Mth.m_14107_((double)navigateX);
                    int hy = entity.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, hx, hz = Mth.m_14107_((double)navigateZ));
                    BlockPos basePos = BlockPos.m_274561_((double)navigateX, (double)hy, (double)navigateZ);
                    if (entity.f_19853_.m_6425_(basePos).m_205070_(FluidTags.f_13131_) && (shore = AIUtils.findShore(entity.f_19853_, basePos)) != null) {
                        basePos = shore;
                    }
                    BlockPos navigatePos = basePos.m_7494_();
                    if (entity.m_21573_().m_26570_() != null && !entity.m_21573_().m_26570_().m_77392_()) {
                        Node finalPoint = entity.m_21573_().m_26570_().m_77395_();
                        if (navigatePos.m_203198_((double)finalPoint.f_77271_, (double)finalPoint.f_77272_, (double)finalPoint.f_77273_) < 25.0) continue;
                    }
                    attemptedPath = true;
                    if (!(entity.m_20238_(BlockPosUtil.blockPosToVec(navigatePos)) > 16.0) || entity.m_6107_() || (canMove = entity.m_21573_().m_26519_((double)navigatePos.m_123341_(), (double)navigatePos.m_123342_(), (double)navigatePos.m_123343_(), speed))) continue;
                    ++failedPaths;
                    continue;
                }
                if (this.fleeing || entity.m_5448_() != null && this.random.nextInt(20) != 0 || this.enemies.isEmpty() || entity.getAgePercentage() <= 50) continue;
                int index = this.random.nextInt(this.enemies.size());
                Iterator<LivingEntity> it = this.enemies.iterator();
                for (int i = 0; i < index && it.hasNext(); ++i) {
                    it.next();
                }
                if (!it.hasNext()) continue;
                entity.m_6710_(it.next());
            }
            if (attemptedPath) {
                if (failedPaths > this.members.size() / 4) {
                    this.moveX = -this.moveX + (this.random.nextFloat() - 0.5f) * 0.1f;
                    this.moveZ = -this.moveZ + (this.random.nextFloat() - 0.5f) * 0.1f;
                    ++this.failedPathTicks;
                    this.normalizeMovement();
                } else if (this.failedPathTicks > 0) {
                    --this.failedPathTicks;
                }
            }
            LinkedList<LivingEntity> invalidEnemies = new LinkedList<LivingEntity>();
            for (LivingEntity enemy : this.enemies) {
                Player pen;
                DinosaurEntity de;
                if (!(enemy.m_21224_() || enemy instanceof DinosaurEntity && (de = (DinosaurEntity)enemy).isCarcass() || enemy instanceof Player && (pen = (Player)enemy).m_7500_() || enemy.m_20275_(this.center.f_82479_, this.center.f_82480_, this.center.f_82481_) > 1024.0) && !this.members.contains(enemy)) continue;
                invalidEnemies.add(enemy);
            }
            this.enemies.removeAll(invalidEnemies);
            if (this.fleeing && this.enemies.isEmpty()) {
                this.fleeing = false;
                this.state = State.IDLE;
            }
            if (this.state == State.IDLE) {
                this.moveX = 0.0f;
                this.moveZ = 0.0f;
            } else {
                this.moveX += (this.random.nextFloat() - 0.5f) * 0.1f;
                this.moveZ += (this.random.nextFloat() - 0.5f) * 0.1f;
                this.normalizeMovement();
            }
            this.refreshMembers();
        }
    }

    private void splitHerd(DinosaurEntity entity) {
        this.members.remove(entity);
        Herd newHerd = new Herd(entity);
        newHerd.fleeing = this.fleeing;
        newHerd.state = this.state;
        newHerd.enemies = new HashSet<LivingEntity>(this.enemies);
        entity.herd = newHerd;
    }

    private void resetStateTicks() {
        this.stateTicks = this.random.nextInt(this.state == State.MOVING ? 2000 : 4000) + 1000;
        this.failedPathTicks = 0;
    }

    public void refreshMembers() {
        if (this.leader == null || this.center == null) {
            return;
        }
        LinkedList<DinosaurEntity> remove = new LinkedList<DinosaurEntity>();
        for (DinosaurEntity entity : this) {
            if (entity.m_6084_() && !entity.getMetabolism().isStarving() && !entity.getMetabolism().isDehydrated()) continue;
            remove.add(entity);
        }
        this.members.removeAll(remove);
        if (this.leader.f_19797_ > this.nextMemberCheck) {
            this.nextMemberCheck = this.leader.f_19797_ + 20 + this.random.nextInt(20);
            AABB searchBounds = new AABB(this.center.f_82479_ - 16.0, this.center.f_82480_ - 5.0, this.center.f_82481_ - 16.0, this.center.f_82479_ + 16.0, this.center.f_82480_ + 5.0, this.center.f_82481_ + 16.0);
            LinkedList<Herd> otherHerds = new LinkedList<Herd>();
            for (Entity e : this.leader.f_19853_.m_6249_((Entity)null, searchBounds, this.isDino)) {
                DinosaurEntity entity;
                if (!(e instanceof DinosaurEntity) || (entity = (DinosaurEntity)e).isCarcass() || entity.m_21224_() || entity.getMetabolism().isStarving() || entity.getMetabolism().isDehydrated() || !entity.getDinosaur().equals(this.herdType) && (!this.herdType.shouldRandomlyFlock() || !entity.getDinosaur().shouldRandomlyFlock() || this.herdType.isCarnivore() != entity.getDinosaur().isCarnivore())) continue;
                Herd otherHerd = entity.herd;
                if (otherHerd == null || otherHerd.members.size() == 1) {
                    if (this.size() >= this.herdType.getMaxHerdSize()) {
                        return;
                    }
                    this.addMember(entity);
                    continue;
                }
                if (otherHerd == this || otherHerds.contains(otherHerd)) continue;
                otherHerds.add(otherHerd);
            }
            for (Herd otherHerd : otherHerds) {
                boolean killOutcast;
                int originalSize = this.size();
                if (otherHerd.size() <= originalSize && otherHerd.size() + originalSize < this.herdType.getMaxHerdSize()) {
                    for (DinosaurEntity member : otherHerd) {
                        this.members.add(member);
                        member.herd = this;
                    }
                    this.enemies.addAll(otherHerd.enemies);
                    this.fleeing |= otherHerd.fleeing;
                    otherHerd.disband();
                    continue;
                }
                if (originalSize + 1 <= this.herdType.getMaxHerdSize() || this.leader == null || !(killOutcast = this.leader.f_19853_.m_46469_().m_46207_(GameRuleHandler.KILL_HERD_OUTCAST)) || this.herdType.getDinosaurType() != Dinosaur.DinosaurType.AGGRESSIVE) continue;
                for (DinosaurEntity entity : otherHerd) {
                    if (!this.enemies.contains(entity)) {
                        this.enemies.add((LivingEntity)entity);
                        continue;
                    }
                    return;
                }
            }
        }
    }

    public void updateLeader() {
        this.leader = this.members.isEmpty() ? null : this.members.iterator().next();
    }

    public Vec3 getCenterPosition() {
        if (this.members.size() == 1) {
            return this.leader.m_20182_();
        }
        double x = 0.0;
        double z = 0.0;
        int count = 0;
        for (DinosaurEntity member : this.members) {
            if (member.isCarcass() || member.m_20069_()) continue;
            x += member.m_20185_();
            z += member.m_20189_();
            ++count;
        }
        if (count <= 0) {
            return this.leader.m_20182_();
        }
        int y = this.leader.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)Math.round(x /= (double)count), (int)Math.round(z /= (double)count));
        return new Vec3(x, (double)y, z);
    }

    public void addMember(DinosaurEntity entity) {
        Herd oldHerd = entity.herd;
        if (oldHerd != null) {
            oldHerd.members.remove(entity);
            this.enemies.addAll(oldHerd.enemies);
            this.fleeing |= oldHerd.fleeing;
            if (oldHerd.leader == entity) {
                oldHerd.updateLeader();
            }
        }
        entity.herd = this;
        this.members.add(entity);
    }

    public void disband() {
        this.leader = null;
        this.members.clear();
    }

    public int size() {
        return this.members.size();
    }

    @Override
    public Iterator<DinosaurEntity> iterator() {
        return this.members.iterator();
    }

    public void normalizeMovement() {
        if (!Float.isFinite(this.moveX) || !Float.isFinite(this.moveZ)) {
            this.moveX = 0.0f;
            this.moveZ = 0.0f;
            return;
        }
        float length = (float)Math.sqrt(this.moveX * this.moveX + this.moveZ * this.moveZ);
        if (length < 1.0E-4f) {
            this.moveX = 0.0f;
            this.moveZ = 0.0f;
        } else {
            this.moveX /= length;
            this.moveZ /= length;
        }
    }

    public boolean shouldDefend(List<LivingEntity> entities) {
        return this.getScore(this) + this.herdType.getAttackBias() * (double)this.members.size() > this.getScore(entities);
    }

    public double getScore(Iterable<? extends LivingEntity> entities) {
        double score = 0.0;
        for (LivingEntity livingEntity : entities) {
            if (livingEntity == null || livingEntity.m_21051_(Attributes.f_22281_) == null) continue;
            score += (double)livingEntity.m_21223_() * livingEntity.m_21051_(Attributes.f_22281_).m_22115_();
        }
        return score;
    }

    public boolean isBusy() {
        return this.fleeing || this.state == State.MOVING || !this.enemies.isEmpty();
    }

    public static enum State {
        MOVING,
        IDLE;

    }
}

