/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.AdvancedSwimEntityAI;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CompsognathusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.HypsilophodonEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.LeptictidiumEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroceratusEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.ai.DinosaurAttackMeleeEntityAI;
import net.vit.jurassicreborn.common.entities.ai.DinosaurWanderEntityAI;
import net.vit.jurassicreborn.common.entities.ai.metabolism.DrinkEntityAI;
import net.vit.jurassicreborn.common.entities.ai.metabolism.EatFoodItemEntityAI;
import net.vit.jurassicreborn.common.entities.ai.metabolism.FeederEntityAI;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurMoveHelper;

public abstract class FlyingDinosaurEntity
extends DinosaurEntity {
    private int ticksOnFloor;
    private int ticksInAir;
    private boolean blocked = false;
    private boolean takingOff;
    public boolean shouldLand;
    private int idleFlightTicks;
    private int takeoffSmoothTicks;
    private Vec3 takeoffTargetVelocity = Vec3.f_82478_;
    private static final double FLIGHT_ACCEL = 0.05;
    private static final double MAX_FLIGHT_SPEED = 0.55;
    private static final double MAX_ASCENT = 0.45;
    private static final double MAX_DESCENT = -0.45;
    private static final double ARRIVE_SLOW_RADIUS = 4.0;

    public FlyingDinosaurEntity(Level world, EntityType type, Dinosaur dino) {
        super(world, (EntityType<? extends DinosaurEntity>)type, dino);
        this.f_21342_ = new FlyingMoveHelper();
        this.f_21345_.m_25352_(0, (Goal)new DinosaurAttackMeleeEntityAI(this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new AIFlyLand());
        this.f_21345_.m_25352_(0, (Goal)new DrinkEntityAI(this));
        this.f_21345_.m_25352_(0, (Goal)new EatFoodItemEntityAI(this));
        this.f_21345_.m_25352_(0, (Goal)new FeederEntityAI(this));
        this.f_21345_.m_25352_(2, (Goal)new AIStartFlying());
        this.f_21345_.m_25352_(3, (Goal)new AILookAround());
        this.f_21345_.m_25352_(4, (Goal)new AIRandomFly());
        this.f_21345_.m_25352_(5, (Goal)new AIWander());
        this.f_21345_.m_25352_(6, (Goal)new AdvancedSwimEntityAI(this));
        this.doesEatEggs(true);
        this.doTarget();
    }

    @Override
    protected void m_267689_(float partialTicks) {
        if (!this.isTouchingGround()) {
            return;
        }
        super.m_267689_(partialTicks);
    }

    protected void doTarget() {
        this.target(LeptictidiumEntity.class, HypsilophodonEntity.class, MicroraptorEntity.class, MicroceratusEntity.class, CompsognathusEntity.class);
    }

    @Override
    public void m_8119_() {
        if (!this.f_19861_ && this.getAnimation() == EntityAnimation.SLEEPING.get()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.2, 0.0));
        }
        if (this.getMetabolism().isStarving() || this.getMetabolism().isThirsty()) {
            this.shouldLand = true;
        }
        if (this.isTouchingGround()) {
            this.ticksInAir = 0;
            ++this.ticksOnFloor;
            this.idleFlightTicks = 0;
            this.shouldLand = false;
            this.takingOff = false;
            this.takeoffSmoothTicks = 0;
            this.takeoffTargetVelocity = Vec3.f_82478_;
        } else {
            boolean moving;
            ++this.ticksInAir;
            this.ticksOnFloor = 0;
            boolean bl = moving = this.m_20184_().m_82556_() > 0.0025;
            this.idleFlightTicks = !moving || !this.m_21566_().m_24995_() ? ++this.idleFlightTicks : 0;
            if (this.idleFlightTicks > 60) {
                this.shouldLand = true;
            }
        }
        if (this.ticksInAir > 150) {
            this.takingOff = false;
        }
        if (this.takingOff && this.takeoffSmoothTicks > 0) {
            Vec3 current = this.m_20184_();
            Vec3 desired = this.takeoffTargetVelocity;
            Vec3 blended = current.m_165921_(desired, 0.45);
            if (blended.f_82480_ < desired.f_82480_ * 0.6) {
                blended = new Vec3(blended.f_82479_, desired.f_82480_ * 0.6, blended.f_82481_);
            }
            this.m_20256_(blended);
            this.f_19812_ = true;
            this.f_19864_ = true;
            --this.takeoffSmoothTicks;
            if (this.takeoffSmoothTicks == 0) {
                this.takeoffTargetVelocity = Vec3.f_82478_;
            }
        } else if (!this.takingOff) {
            this.takeoffSmoothTicks = 0;
            this.takeoffTargetVelocity = Vec3.f_82478_;
        }
        if (this.shouldLand && !this.isTouchingGround() && !this.m_21566_().m_24995_()) {
            Vec3 current = this.m_20184_();
            double descent = Math.max(current.f_82480_ - 0.08, -0.2);
            this.m_20334_(current.f_82479_ * 0.6, descent, current.f_82481_ * 0.6);
        }
        super.m_8119_();
    }

    @Override
    public boolean m_6107_() {
        return this.isCarcass() || this.m_5803_() || this.blocked;
    }

    public boolean isTouchingGround() {
        if (this.m_21224_() || this.isCarcass() || this.m_20069_()) {
            return true;
        }
        if (this.takingOff) {
            return false;
        }
        AABB box = this.m_20191_().m_82400_(0.24);
        boolean anyCollision = !this.f_19853_.m_45756_((Entity)this, box);
        return anyCollision || this.f_19861_;
    }

    public void startTakeOff() {
        if (!this.takingOff) {
            Vec3 motion = this.m_20184_();
            double boostY = Math.max(motion.f_82480_, 0.35);
            this.m_20334_(motion.f_82479_ * 0.4, boostY, motion.f_82481_ * 0.4);
        }
        this.takingOff = true;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (!this.isTouchingGround()) {
            return super.m_142535_(distance, damageMultiplier, source);
        }
        return false;
    }

    public boolean m_6147_() {
        return false;
    }

    private boolean isCourseTraversable(Vec3 loc) {
        double distance = this.m_20182_().m_82554_(loc) + 1.0;
        double dX = (loc.f_82479_ - this.m_20185_()) / distance;
        double dY = (loc.f_82480_ - this.m_20186_()) / distance;
        double dZ = (loc.f_82481_ - this.m_20189_()) / distance;
        AABB box = this.m_20191_();
        for (double i = 1.0; i < distance; i += 0.75) {
            if (this.f_19853_.m_45756_((Entity)this, box = box.m_82386_(dX, dY, dZ))) continue;
            return false;
        }
        return true;
    }

    protected void updateCustomFlightAnimation() {
        double dz;
        double dx = this.m_20185_() - this.f_19854_;
        float dist = Mth.m_14116_((float)((float)(dx * dx + (dz = this.m_20189_() - this.f_19856_) * dz))) * 4.0f;
        if (dist > 1.0f) {
            dist = 1.0f;
        }
        this.f_267362_.m_267566_(dist, 0.4f);
    }

    @Override
    public void m_7023_(Vec3 travelVec) {
        if (this.tranqed || this.isTouchingGround()) {
            super.m_7023_(travelVec);
            return;
        }
        if (this.m_20069_()) {
            this.m_19920_(0.02f, travelVec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, travelVec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            float friction = 0.91f;
            if (this.f_19861_) {
                BlockPos below = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20191_().f_82289_ - 1.0)), Mth.m_14107_((double)this.m_20189_()));
                friction = this.f_19853_.m_8055_(below).getFriction((LevelReader)this.f_19853_, below, (Entity)this) * 0.91f;
            }
            float accel = this.f_19861_ ? 0.16277136f / (friction * friction * friction) * 0.1f : 0.02f;
            this.m_19920_(accel, travelVec);
            friction = 0.91f;
            if (this.f_19861_) {
                BlockPos below = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20191_().f_82289_ - 1.0)), Mth.m_14107_((double)this.m_20189_()));
                friction = this.f_19853_.m_8055_(below).getFriction((LevelReader)this.f_19853_, below, (Entity)this) * 0.91f;
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 v = this.m_20184_();
            double speed = v.m_82553_();
            if (speed > 0.55) {
                v = v.m_82490_(0.55 / speed);
            }
            this.m_20256_(v.m_82490_((double)friction));
        }
        this.updateCustomFlightAnimation();
    }

    private boolean isOverWater() {
        BlockPos posBelow = this.m_20183_().m_7495_();
        return this.f_19853_.m_8055_(posBelow).m_60713_(Blocks.f_49990_);
    }

    class FlyingMoveHelper
    extends DinosaurMoveHelper {
        private final FlyingDinosaurEntity parent;

        public FlyingMoveHelper() {
            super(FlyingDinosaurEntity.this);
            this.parent = FlyingDinosaurEntity.this;
        }

        @Override
        public void m_8126_() {
            if (this.parent.isTouchingGround()) {
                super.m_8126_();
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double spd;
                double dz;
                double dy;
                double dx = this.f_24975_ - this.parent.m_20185_();
                double d2 = dx * dx + (dy = this.f_24976_ - this.parent.m_20186_()) * dy + (dz = this.f_24977_ - this.parent.m_20189_()) * dz;
                if (d2 < 1.0E-4) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    return;
                }
                double d = Math.sqrt(d2);
                double nx = dx / d;
                double ny = dy / d;
                double nz = dz / d;
                double accel = 0.05;
                if (d < 4.0) {
                    accel *= d / 4.0;
                }
                Vec3 vel = this.parent.m_20184_().m_82520_(nx * accel * this.f_24978_, ny * accel * this.f_24978_, nz * accel * this.f_24978_);
                if (vel.f_82480_ > 0.45) {
                    vel = new Vec3(vel.f_82479_, 0.45, vel.f_82481_);
                }
                if (vel.f_82480_ < -0.45) {
                    vel = new Vec3(vel.f_82479_, -0.45, vel.f_82481_);
                }
                if ((spd = vel.m_82553_()) > 0.55) {
                    vel = vel.m_82490_(0.55 / spd);
                }
                if (!this.isNotColliding(this.f_24975_, this.f_24976_, this.f_24977_, d)) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else {
                    this.parent.m_20256_(vel);
                }
                if (d2 < 0.6) {
                    this.parent.m_20256_(this.parent.m_20184_().m_82490_(0.6));
                    if (d2 < 0.05) {
                        this.f_24981_ = MoveControl.Operation.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double distance) {
            double d0 = (x - this.parent.m_20185_()) / distance;
            double d1 = (y - this.parent.m_20186_()) / distance;
            double d2 = (z - this.parent.m_20189_()) / distance;
            AABB bounds = this.parent.m_20191_();
            for (double i = 1.0; i < distance; i += 0.75) {
                if (this.parent.f_19853_.m_45756_((Entity)this.parent, bounds = bounds.m_82386_(d0, d1, d2))) continue;
                return false;
            }
            return true;
        }
    }

    class AIFlyLand
    extends Goal {
        private final FlyingDinosaurEntity dino;

        public AIFlyLand() {
            this.dino = FlyingDinosaurEntity.this;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double dz;
            double dy;
            if (this.dino.ticksInAir <= 150 && this.dino.isTouchingGround() && this.dino.m_20069_() && this.dino.isOverWater()) {
                return false;
            }
            MoveControl ctrl = this.dino.m_21566_();
            if (!ctrl.m_24995_() && this.dino.m_217043_().m_188501_() < 0.1f || !ctrl.m_24995_() && this.dino.shouldLand) {
                return true;
            }
            double dx = ctrl.m_25000_() - this.dino.m_20185_();
            double d = dx * dx + (dy = ctrl.m_25001_() - this.dino.m_20186_()) * dy + (dz = ctrl.m_25002_() - this.dino.m_20189_()) * dz;
            if (d < 1.0 || d > 3600.0) {
                BlockPos posBelow = this.dino.m_20183_().m_7495_();
                return this.dino.f_19853_.m_8055_(posBelow).m_60795_() && this.dino.m_217043_().m_188501_() < 0.01f;
            }
            return false;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.dino.m_217043_();
            double dstX = this.dino.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double dstZ = this.dino.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            int topY = this.dino.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)dstX), Mth.m_14107_((double)dstZ));
            double dstY = topY;
            BlockPos.MutableBlockPos probe = new BlockPos.MutableBlockPos(Mth.m_14107_((double)dstX), Mth.m_14107_((double)(dstY - 1.0)), Mth.m_14107_((double)dstZ));
            Level level = this.dino.f_19853_;
            while (probe.m_123342_() > level.m_141937_() && level.m_8055_((BlockPos)probe).m_60795_()) {
                probe.m_122184_(0, -1, 0);
            }
            if (!level.m_8055_((BlockPos)probe).m_60795_()) {
                double landingY = (double)probe.m_123342_() + 0.2;
                this.dino.m_21566_().m_6849_(dstX, landingY, dstZ, 1.15);
                this.dino.setAnimation(EntityAnimation.ON_LAND.get());
            } else {
                this.dino.shouldLand = false;
            }
        }
    }

    class AIStartFlying
    extends Goal {
        private final FlyingDinosaurEntity dino;

        public AIStartFlying() {
            this.dino = FlyingDinosaurEntity.this;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.dino.ticksOnFloor >= 220 && this.dino.isTouchingGround() && this.dino.m_217043_().m_188501_() < 0.03f;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.dino.startTakeOff();
            this.dino.setAnimation(EntityAnimation.FLYING.get());
            this.dino.shouldLand = false;
            this.dino.idleFlightTicks = 0;
            RandomSource r = this.dino.m_217043_();
            double x = this.dino.m_20185_() + (double)r.m_188501_();
            double y = this.dino.m_20186_() + (double)(r.m_188501_() * 5.0f);
            double z = this.dino.m_20189_() + (double)r.m_188501_();
            this.dino.m_21566_().m_6849_(x, y, z, 1.2);
        }
    }

    class AILookAround
    extends Goal {
        private final FlyingDinosaurEntity dino;

        public AILookAround() {
            this.dino = FlyingDinosaurEntity.this;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            boolean moving;
            Vec3 vel = this.dino.m_20184_();
            boolean bl = moving = vel.m_82556_() > 1.0E-4;
            if (!moving) {
                double dz;
                double dx;
                MoveControl mc = this.dino.m_21566_();
                if (mc.m_24995_() && (dx = mc.m_25000_() - this.dino.m_20185_()) * dx + (dz = mc.m_25002_() - this.dino.m_20189_()) * dz > 1.0E-4) {
                    float yaw = -((float)(Mth.m_14136_((double)dx, (double)dz) * 57.2957763671875));
                    this.dino.m_146922_(yaw);
                    this.dino.m_5618_(yaw);
                }
                return;
            }
            if (this.dino.m_5448_() == null) {
                float yaw = -((float)(Mth.m_14136_((double)vel.f_82479_, (double)vel.f_82481_) * 57.2957763671875));
                this.dino.m_146922_(yaw);
                this.dino.m_5618_(yaw);
            } else {
                LivingEntity target = this.dino.m_5448_();
                double max = 64.0;
                if (this.dino.m_20280_((Entity)target) < max * max) {
                    double dx = target.m_20185_() - this.dino.m_20185_();
                    double dz = target.m_20189_() - this.dino.m_20189_();
                    float yaw = -((float)(Mth.m_14136_((double)dx, (double)dz) * 57.2957763671875));
                    this.dino.m_146922_(yaw);
                    this.dino.m_5618_(yaw);
                }
            }
        }
    }

    class AIRandomFly
    extends Goal {
        private final FlyingDinosaurEntity dino;

        AIRandomFly() {
            this.dino = FlyingDinosaurEntity.this;
        }

        public boolean m_8036_() {
            double dz;
            double dy;
            if (this.dino.f_19861_) {
                return false;
            }
            MoveControl ctl = this.dino.m_21566_();
            if (!ctl.m_24995_()) {
                return true;
            }
            double dx = ctl.m_25000_() - this.dino.m_20185_();
            double dist = dx * dx + (dy = ctl.m_25001_() - this.dino.m_20186_()) * dy + (dz = ctl.m_25002_() - this.dino.m_20189_()) * dz;
            return dist < 3.0 || dist > 3600.0;
        }

        public void m_8056_() {
            for (int i = 0; i < 100; ++i) {
                double dz;
                double dy;
                double dx = this.dino.m_20185_() + (double)((this.dino.m_217043_().m_188501_() * 2.0f - 1.0f) * 16.0f);
                Vec3 pos = new Vec3(dx, dy = this.dino.m_20186_() + (double)((this.dino.m_217043_().m_188501_() * 2.0f - 1.0f) * 8.0f), dz = this.dino.m_20189_() + (double)((this.dino.m_217043_().m_188501_() * 2.0f - 1.0f) * 16.0f));
                if (!this.dino.isCourseTraversable(pos)) continue;
                this.dino.setAnimation(EntityAnimation.FLYING.get());
                this.dino.m_21566_().m_6849_(dx, dy, dz, 1.0);
                return;
            }
            this.dino.shouldLand = true;
        }
    }

    class AIWander
    extends DinosaurWanderEntityAI {
        private final FlyingDinosaurEntity dino;

        public AIWander() {
            super(FlyingDinosaurEntity.this, 0.8, 10, 10);
            this.dino = FlyingDinosaurEntity.this;
        }

        @Override
        public boolean m_8036_() {
            if (!this.dino.isTouchingGround()) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

