/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class DefendOwnerAI
extends Goal {
    private static final double MAX_DISTANCE_SQR = 2304.0;
    private final DinosaurEntity dino;
    private Player owner;
    private LivingEntity attacker;
    private int lastHurtByTs;

    public DefendOwnerAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.dino.isCarcass() || !this.dino.m_6084_() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (this.dino.getAgePercentage() <= 50) {
            return false;
        }
        if (this.dino.getOrder() != DinosaurEntity.Order.FOLLOW) {
            return false;
        }
        UUID id = this.dino.getOwner();
        if (id == null) {
            return false;
        }
        this.owner = this.dino.f_19853_.m_46003_(id);
        if (this.owner == null || this.owner.m_5833_()) {
            return false;
        }
        LivingEntity hurtBy = this.owner.m_21188_();
        if (hurtBy == null || !hurtBy.m_6084_() || hurtBy == this.dino) {
            return false;
        }
        this.attacker = hurtBy;
        this.lastHurtByTs = this.owner.m_21213_();
        return this.dino.m_20280_((Entity)this.attacker) <= 2304.0;
    }

    public void m_8056_() {
        this.dino.m_6710_(this.attacker);
    }

    public boolean m_8045_() {
        if (this.dino.isCarcass() || !this.dino.m_6084_() || this.dino.isMovementBlocked()) {
            return false;
        }
        if (this.dino.getOrder() != DinosaurEntity.Order.FOLLOW) {
            return false;
        }
        if (this.owner == null || this.owner.m_5833_()) {
            return false;
        }
        return this.attacker != null && this.attacker.m_6084_() && this.dino.m_20280_((Entity)this.attacker) <= 2304.0;
    }

    public void m_8037_() {
        LivingEntity newAttacker = this.owner.m_21188_();
        int ts = this.owner.m_21213_();
        if (newAttacker != null && newAttacker.m_6084_() && newAttacker != this.dino && ts > this.lastHurtByTs) {
            this.attacker = newAttacker;
            this.lastHurtByTs = ts;
            this.dino.m_6710_(this.attacker);
        } else if (this.dino.m_5448_() != this.attacker) {
            this.dino.m_6710_(this.attacker);
        }
    }

    public void m_8041_() {
        this.dino.m_6710_(null);
        this.owner = null;
        this.attacker = null;
        this.lastHurtByTs = 0;
    }
}

