/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class DinosaurAttackMeleeEntityAI
extends MeleeAttackGoal {
    protected final DinosaurEntity dinosaur;
    private final double attackSpeed;
    private static final int REPTH_MIN_TICKS = 10;
    private static final int REPTH_MAX_TICKS = 20;
    private static final double REPATH_MOVE_DIST_SQR = 4.0;
    private int repathTime = 0;
    private Vec3 lastTargetPos = Vec3.f_82478_;

    public DinosaurAttackMeleeEntityAI(DinosaurEntity dinosaur, double speedModifier, boolean useLongMemory) {
        super((PathfinderMob)dinosaur, speedModifier, useLongMemory);
        this.dinosaur = dinosaur;
        this.attackSpeed = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected DinosaurEntity getAttacker() {
        return this.dinosaur;
    }

    public boolean m_8036_() {
        LivingEntity target = this.dinosaur.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.dinosaur.m_6710_(null);
            return false;
        }
        return super.m_8036_();
    }

    public boolean m_8045_() {
        LivingEntity target = this.dinosaur.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.dinosaur.m_6710_(null);
            return false;
        }
        return super.m_8045_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.repathTime = 0;
        LivingEntity t = this.dinosaur.m_5448_();
        this.lastTargetPos = t != null ? t.m_20182_() : this.dinosaur.m_20182_();
        this.dinosaur.m_21573_().m_26529_(1.0f);
    }

    public void m_8041_() {
        super.m_8041_();
        this.dinosaur.m_21573_().m_26573_();
    }

    public void m_8037_() {
        Vec3 cur;
        LivingEntity target = this.dinosaur.m_5448_();
        if (target == null || !target.m_6084_()) {
            return;
        }
        boolean waterNav = this.dinosaur.m_21573_() instanceof WaterBoundPathNavigation;
        this.dinosaur.m_21563_().m_24960_((Entity)target, 30.0f, (float)this.dinosaur.m_8132_());
        double reach = this.m_6639_(target);
        double distSqr = this.dinosaur.m_20280_((Entity)target);
        if (distSqr <= reach) {
            this.dinosaur.m_21573_().m_26573_();
        } else if (--this.repathTime <= 0 && ((cur = target.m_20182_()).m_82557_(this.lastTargetPos) > 4.0 || this.dinosaur.m_217043_().m_188503_(4) == 0)) {
            this.dinosaur.m_21573_().m_5624_((Entity)target, this.attackSpeed);
            this.lastTargetPos = cur;
            this.repathTime = 10 + this.dinosaur.m_217043_().m_188503_(11);
        }
        if (waterNav && this.dinosaur.m_21573_().m_26571_()) {
            this.dinosaur.m_21566_().m_6849_(target.m_20185_(), target.m_20227_((double)target.m_20206_() * 0.5), target.m_20189_(), this.attackSpeed);
        }
        super.m_8037_();
    }

    protected double m_6639_(LivingEntity target) {
        AABB myBox = this.dinosaur.m_20191_().m_82377_(0.25, 0.25, 0.25);
        if (myBox.m_82381_(target.m_20191_())) {
            return 0.25;
        }
        double grownWidth = (double)this.dinosaur.m_20205_() * 0.9 + (double)target.m_20205_() + 0.5;
        return grownWidth * grownWidth;
    }
}

