/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.Herd;

public class DinosaurWanderEntityAI
extends Goal {
    protected final DinosaurEntity entity;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private final double speed;
    protected int executionChance;
    private boolean mustUpdate;
    private final int walkradius;
    private final Herd herd;

    public DinosaurWanderEntityAI(DinosaurEntity creatureIn, double speedIn, int chance, int walkradius) {
        this.entity = creatureIn;
        this.herd = creatureIn.herd;
        this.speed = speedIn;
        this.executionChance = chance;
        this.walkradius = walkradius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.mustUpdate && this.innerShouldStopExecuting()) {
            return false;
        }
        if (this.outerShouldExecute()) {
            for (int i = 0; i < 100; ++i) {
                Vec3 vec = this.getWanderPosition();
                if (vec == null) continue;
                BlockPos base = BlockPos.m_274561_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_);
                boolean spaceClear = true;
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)base.m_7494_(), (BlockPos)base.m_6630_(2))) {
                    if (this.entity.f_19853_.m_8055_(pos).m_60795_()) continue;
                    spaceClear = false;
                    break;
                }
                if (!spaceClear) continue;
                this.xPosition = vec.f_82479_;
                this.yPosition = vec.f_82480_;
                this.zPosition = vec.f_82481_;
                this.mustUpdate = false;
                return true;
            }
        }
        return false;
    }

    protected boolean innerShouldStopExecuting() {
        if (this.entity.getOrder() != DinosaurEntity.Order.WANDER) {
            return true;
        }
        return this.entity.m_217043_().m_188503_(this.executionChance) != 0;
    }

    protected boolean outerShouldExecute() {
        return this.entity.m_21573_().m_26571_() && this.entity.getAttackTarget() == null && !this.entity.m_20069_();
    }

    protected Vec3 getWanderPosition() {
        for (int i = 0; i < 20; ++i) {
            BlockPos bp;
            Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)this.entity, (int)(this.walkradius + 5), (int)this.walkradius);
            if (pos == null || !this.entity.f_19853_.m_6425_(bp = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_)).m_76178_() || !this.entity.f_19853_.m_6425_(bp.m_7495_()).m_76178_() || this.entity.f_19853_.m_6425_(bp).m_205070_(FluidTags.f_13131_) || this.entity.f_19853_.m_6425_(bp.m_7495_()).m_205070_(FluidTags.f_13131_) || this.entity.f_19853_.m_6425_(bp).m_205070_(FluidTags.f_13132_) || this.entity.f_19853_.m_6425_(bp.m_7495_()).m_205070_(FluidTags.f_13132_)) continue;
            return pos;
        }
        return LandRandomPos.m_148488_((PathfinderMob)this.entity, (int)(this.walkradius + 5), (int)this.walkradius);
    }

    public boolean m_8045_() {
        return this.entity.getOrder() == DinosaurEntity.Order.WANDER && !this.entity.m_21573_().m_26571_() && !this.entity.m_20069_();
    }

    public void m_8056_() {
        if (this.herd != null) {
            for (DinosaurEntity member : this.herd.members) {
                member.m_21573_().m_26519_(this.xPosition + member.m_217043_().m_188500_() * 2.0, this.yPosition, this.zPosition + member.m_217043_().m_188500_() * 2.0, this.speed);
            }
        } else {
            this.entity.m_21573_().m_26519_(this.xPosition, this.yPosition, this.zPosition, this.speed);
        }
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int chance) {
        this.executionChance = chance;
    }
}

