/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class FollowOwnerAI
extends Goal {
    private static final double START_DIST_SQR = 36.0;
    private static final double STOP_DIST_SQR = 9.0;
    private static final double TELEPORT_SQR = 196.0;
    private static final double NAV_SPEED = 0.8;
    private final DinosaurEntity dino;
    private Player owner;
    private int recalcCooldown;
    private float oldWaterMalus;

    public FollowOwnerAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dino.isCarcass() || this.dino.isMovementBlocked() || !this.dino.m_6084_()) {
            return false;
        }
        if (this.dino.getOrder() != DinosaurEntity.Order.FOLLOW) {
            return false;
        }
        UUID id = this.dino.getOwner();
        if (id == null) {
            return false;
        }
        this.owner = this.dino.f_19853_.m_46003_(id);
        if (this.owner == null || !this.owner.m_6084_()) {
            return false;
        }
        return this.dino.m_20280_((Entity)this.owner) > 36.0;
    }

    public boolean m_8045_() {
        if (this.owner == null || !this.owner.m_6084_()) {
            return false;
        }
        if (this.dino.getOrder() != DinosaurEntity.Order.FOLLOW) {
            return false;
        }
        if (this.dino.isCarcass() || this.dino.isMovementBlocked()) {
            return false;
        }
        return this.dino.m_20280_((Entity)this.owner) > 9.0;
    }

    public void m_8056_() {
        this.recalcCooldown = 0;
        this.oldWaterMalus = this.dino.m_21439_(BlockPathTypes.WATER);
        this.dino.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.dino.m_21573_().m_26573_();
        this.dino.m_21441_(BlockPathTypes.WATER, this.oldWaterMalus);
        this.owner = null;
    }

    public void m_8037_() {
        if (this.owner == null) {
            return;
        }
        this.dino.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dino.m_8132_());
        if (this.dino.m_20280_((Entity)this.owner) > 196.0) {
            this.tryTeleportNearOwner();
        }
        if (this.recalcCooldown-- <= 0) {
            this.recalcCooldown = 10;
            this.dino.m_21573_().m_5624_((Entity)this.owner, 0.8);
        }
    }

    private void tryTeleportNearOwner() {
        BlockPos ownerPos = this.owner.m_20183_();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos candidate;
                if (Math.abs(dx) < 2 && Math.abs(dz) < 2 || !this.isTeleportFriendly(candidate = ownerPos.m_7918_(dx, 0, dz))) continue;
                this.dino.m_7678_((double)candidate.m_123341_() + 0.5, candidate.m_123342_(), (double)candidate.m_123343_() + 0.5, this.dino.m_146908_(), this.dino.m_146909_());
                this.dino.m_21573_().m_26573_();
                return;
            }
        }
    }

    private boolean isTeleportFriendly(BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState ground = this.dino.f_19853_.m_8055_(below);
        if (!ground.m_60812_((BlockGetter)this.dino.f_19853_, below).m_83281_()) {
            if (this.dino.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13131_) || this.dino.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13132_)) {
                return false;
            }
            AABB head = new AABB(pos).m_82363_(0.0, 2.0, 0.0);
            return this.dino.f_19853_.m_45756_((Entity)this.dino, head);
        }
        return false;
    }
}

