/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MicroraptorEntity;

public class RaptorClimbTreeAI
extends Goal {
    private static final int CLIMB_INTERVAL = 1200;
    private static final int MAX_TREE_HEIGHT = 14;
    private final MicroraptorEntity entity;
    private final double movementSpeed;
    private final Level level;
    private Path path;
    private BlockPos targetTrunk;
    private Direction approachSide;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean gliding;
    private boolean active;
    private boolean reachedTarget;
    private int lastActive = -1200;
    private Vec3 glideTarget;

    public RaptorClimbTreeAI(MicroraptorEntity entity, double speed) {
        this.entity = entity;
        this.movementSpeed = speed;
        this.level = entity.f_19853_;
        this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean m_8036_() {
        if (this.active || this.entity.f_19797_ - this.lastActive < 1200) {
            return false;
        }
        if (this.entity.m_217043_().m_188501_() > 0.12f) {
            return false;
        }
        BlockPos.MutableBlockPos base = new BlockPos.MutableBlockPos().m_122169_(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
        RandomSource random = this.entity.m_217043_();
        block0: for (int i = 0; i < 20; ++i) {
            BlockPos target = base.m_7918_(random.m_188503_(14) - 7, -5, random.m_188503_(14) - 7);
            for (int iteration = 0; iteration <= 15; ++iteration) {
                if (!this.level.m_46805_(target = target.m_7494_())) {
                    return false;
                }
                BlockState state = this.level.m_8055_(target);
                if (RaptorClimbTreeAI.isLeaves(state) || RaptorClimbTreeAI.isWood(state)) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        BlockPos offsetTarget = target.m_121945_(dir);
                        if (this.level.m_8055_(offsetTarget).m_60783_((BlockGetter)this.level, offsetTarget, Direction.DOWN)) continue;
                        boolean canTravel = true;
                        boolean woodFound = false;
                        for (int h = 0; h < 14; ++h) {
                            BlockPos above;
                            boolean passable;
                            BlockPos trunkPos = target.m_6630_(h);
                            BlockPos climbPos = offsetTarget.m_6630_(h);
                            BlockState climbState = this.level.m_8055_(climbPos);
                            boolean bl = passable = climbState.m_60795_() || RaptorClimbTreeAI.isLeaves(climbState);
                            if (RaptorClimbTreeAI.isLeaves(climbState) && !this.level.m_8055_(above = climbPos.m_7494_()).m_60795_()) {
                                canTravel = false;
                                break;
                            }
                            if (!passable) {
                                canTravel = false;
                                break;
                            }
                            BlockState trunkState = this.level.m_8055_(trunkPos);
                            if (!RaptorClimbTreeAI.isWood(trunkState)) break;
                            woodFound = true;
                        }
                        if (!canTravel || !woodFound) continue;
                        float add = this.entity.m_20205_() + 0.25f;
                        float offX = (float)dir.m_122429_() * add + 0.1f;
                        float offZ = (float)dir.m_122431_() * add + 0.1f;
                        this.targetTrunk = target;
                        this.targetX = (float)target.m_123341_() + 0.5f + offX;
                        this.targetY = (float)target.m_123342_() + 0.5f;
                        this.targetZ = (float)target.m_123343_() + 0.5f + offZ;
                        this.approachSide = dir;
                        AABB bounds = this.getBoundsAtPos(this.targetX, this.targetY, this.targetZ);
                        if (!this.noCollisionExceptLeaves(bounds)) continue;
                        PathNavigation nav = this.entity.m_21573_();
                        this.path = nav.m_7864_(new BlockPos(Mth.m_14107_((double)this.targetX), Mth.m_14107_((double)this.targetY), Mth.m_14107_((double)this.targetZ)), 0);
                        if (this.path == null) continue;
                        return true;
                    }
                    continue;
                }
                if (state.m_60795_()) continue block0;
            }
        }
        return false;
    }

    private static boolean isLeaves(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_);
    }

    private static boolean isWood(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_);
    }

    private boolean noCollisionExceptLeaves(AABB box) {
        int minX = Mth.m_14107_((double)box.f_82288_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxX = Mth.m_14107_((double)box.f_82291_);
        int maxY = Mth.m_14107_((double)box.f_82292_);
        int maxZ = Mth.m_14107_((double)box.f_82293_);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState bs = this.level.m_8055_(pos);
                    if (bs.m_60795_() || RaptorClimbTreeAI.isLeaves(bs) || bs.m_60812_((BlockGetter)this.level, pos).m_83281_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private AABB getBoundsAtPos(double x, double y, double z) {
        float half = this.entity.m_20205_() / 2.0f;
        double inset = 0.05;
        return new AABB(x - (double)half + inset, y, z - (double)half + inset, x + (double)half - inset, y + (double)this.entity.m_20206_(), z + (double)half - inset);
    }

    public void m_8056_() {
        if (this.path != null) {
            this.entity.m_21573_().m_26536_(this.path, this.movementSpeed);
        }
        this.active = true;
        this.gliding = false;
        this.reachedTarget = false;
        this.glideTarget = null;
        this.entity.f_19794_ = false;
    }

    public void m_8037_() {
        Vec3 to;
        if (this.gliding && this.entity.getAnimation() == EntityAnimation.GLIDING.get() && this.glideTarget != null && (to = new Vec3(this.glideTarget.f_82479_ - this.entity.m_20185_(), 0.0, this.glideTarget.f_82481_ - this.entity.m_20189_())).m_82556_() > 1.0E-4) {
            this.entity.m_20256_(this.entity.m_20184_().m_82549_(to.m_82541_().m_82490_(0.03)));
        }
        if (this.reachedTarget) {
            BlockPos top;
            boolean atTrunkFace;
            Vec3 toward;
            double d2;
            BlockPos currentTrunk = new BlockPos(this.targetTrunk.m_123341_(), Mth.m_14107_((double)this.entity.m_20191_().f_82289_), this.targetTrunk.m_123343_());
            if (!this.gliding && this.level.m_46859_(currentTrunk)) {
                RandomSource random = this.entity.m_217043_();
                if (random.m_188501_() < 0.3f) {
                    Vec3 push = new Vec3((double)((float)(-this.approachSide.m_122429_()) * 0.1f), (double)0.22f, (double)((float)(-this.approachSide.m_122431_()) * 0.1f));
                    this.entity.m_20256_(this.entity.m_20184_().m_82549_(push));
                } else {
                    Vec3 pos = this.findGlideTarget(random, true);
                    if (pos == null) {
                        pos = this.findGlideTarget(random, false);
                    }
                    if (pos != null) {
                        this.glideTarget = pos;
                        this.entity.setGlidingTo(pos);
                        Vec3 dir0 = new Vec3(pos.f_82479_ - this.entity.m_20185_(), 0.0, pos.f_82481_ - this.entity.m_20189_()).m_82541_();
                        this.entity.m_20256_(this.entity.m_20184_().m_82549_(dir0.m_82490_(0.12)).m_82520_(0.0, 0.28, 0.0));
                        this.gliding = true;
                        this.entity.setAnimation(EntityAnimation.GLIDING.get());
                    }
                }
                this.active = false;
                this.entity.f_19794_ = false;
                return;
            }
            BlockState trunkState = this.level.m_8055_(currentTrunk);
            if (!RaptorClimbTreeAI.isLeaves(trunkState) && !RaptorClimbTreeAI.isWood(trunkState)) {
                this.active = false;
                this.entity.f_19794_ = false;
                return;
            }
            this.entity.m_21566_().m_6849_(this.targetX, this.entity.m_20191_().f_82289_, this.targetZ, this.movementSpeed);
            this.entity.setAnimation(EntityAnimation.CLIMBING.get());
            BlockPos facePos = currentTrunk.m_121945_(this.approachSide);
            boolean insideLeaves = RaptorClimbTreeAI.isLeaves(this.level.m_8055_(this.entity.m_20183_())) || RaptorClimbTreeAI.isLeaves(this.level.m_8055_(this.entity.m_20183_().m_7494_()));
            boolean leafWallAhead = this.isLeafyFrontColumn(facePos);
            boolean bl = this.entity.f_19794_ = insideLeaves || leafWallAhead;
            if (RaptorClimbTreeAI.isLeaves(this.level.m_8055_(facePos))) {
                BlockPos step = facePos;
                for (int up = 0; up < 3 && RaptorClimbTreeAI.isLeaves(this.level.m_8055_(step)); ++up) {
                    step = step.m_7494_();
                }
                if (this.level.m_46859_(step)) {
                    this.entity.m_6034_(this.targetX, (double)step.m_123342_() + 0.05, this.targetZ);
                    this.entity.m_20334_(this.entity.m_20184_().f_82479_, 0.42, this.entity.m_20184_().f_82481_);
                } else {
                    this.active = false;
                    this.entity.f_19794_ = false;
                    return;
                }
            }
            if ((d2 = (toward = new Vec3(this.targetX - this.entity.m_20185_(), 0.0, this.targetZ - this.entity.m_20189_())).m_82556_()) > 1.0E-4) {
                this.entity.m_20256_(this.entity.m_20184_().m_82549_(toward.m_82541_().m_82490_(0.08)));
            }
            boolean bl2 = atTrunkFace = this.entity.f_19862_ || this.level.m_8055_(currentTrunk).m_60783_((BlockGetter)this.level, currentTrunk, this.approachSide);
            if (atTrunkFace) {
                this.entity.m_20334_(this.entity.m_20184_().f_82479_, 0.42, this.entity.m_20184_().f_82481_);
                this.entity.m_20256_(this.entity.m_20184_().m_82520_((double)this.approachSide.m_122429_() * 0.06, 0.0, (double)this.approachSide.m_122431_() * 0.06));
                if (d2 < 0.5625) {
                    this.entity.m_6034_(this.targetX, this.entity.m_20186_(), this.targetZ);
                }
                if (this.entity.m_20238_(Vec3.m_82512_((Vec3i)currentTrunk)) > 2.0) {
                    this.active = false;
                    this.entity.f_19794_ = false;
                }
            }
            if (this.entity.f_19863_ && !this.gliding && RaptorClimbTreeAI.isLeaves(this.level.m_8055_(top = BlockPos.m_274561_((double)this.entity.m_20185_(), (double)(this.entity.m_20191_().f_82292_ + 0.1), (double)this.entity.m_20189_())))) {
                if (this.level.m_46859_(top.m_7494_())) {
                    this.entity.m_6034_(this.targetX, (double)Mth.m_14165_((double)(this.entity.m_20186_() + 1.0)) + 0.2, this.targetZ);
                } else {
                    this.entity.m_6034_(this.targetX, this.entity.m_20186_() + 0.2, this.targetZ);
                }
            }
        } else {
            if (this.path == null) {
                return;
            }
            if (this.path.m_77392_()) {
                this.entity.setAnimation(EntityAnimation.START_CLIMBING.get());
                this.reachedTarget = true;
                Vec3 origin = this.entity.m_20182_().m_82520_(0.0, (double)this.entity.m_20192_(), 0.0);
                BlockHitResult hit = this.level.m_45547_(new ClipContext(origin, new Vec3(this.targetX, this.targetY, this.targetZ), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this.entity));
                if (hit != null && hit.m_6662_() == HitResult.Type.BLOCK) {
                    this.path = null;
                }
            } else {
                this.entity.m_21573_().m_26536_(this.path, this.movementSpeed);
            }
            this.entity.f_19794_ = false;
        }
    }

    private boolean isLeafyFrontColumn(BlockPos facePos) {
        int baseY = Mth.m_14107_((double)this.entity.m_20191_().f_82289_);
        for (int dy = -1; dy <= 2; ++dy) {
            BlockPos p = new BlockPos(facePos.m_123341_(), baseY + dy, facePos.m_123343_());
            BlockState s = this.level.m_8055_(p);
            if (!RaptorClimbTreeAI.isLeaves(s)) continue;
            return true;
        }
        BlockPos halfForward = facePos.m_121945_(this.approachSide);
        for (int dy = -1; dy <= 2; ++dy) {
            BlockPos p = new BlockPos(halfForward.m_123341_(), baseY + dy, halfForward.m_123343_());
            BlockState s = this.level.m_8055_(p);
            if (!RaptorClimbTreeAI.isLeaves(s)) continue;
            return true;
        }
        return false;
    }

    private Vec3 findGlideTarget(RandomSource random, boolean preferLeaves) {
        for (int i = 0; i < 100; ++i) {
            boolean ok;
            double x = ((double)random.m_188501_() - 0.5) * 45.0;
            double z = ((double)random.m_188501_() - 0.5) * 45.0;
            Vec3 base = this.entity.m_20182_().m_82520_(x, 0.0, z);
            BlockPos p = BlockPos.m_274561_((double)base.f_82479_, (double)this.entity.m_20186_(), (double)base.f_82481_);
            int y = this.level.m_6924_(preferLeaves ? Heightmap.Types.MOTION_BLOCKING_NO_LEAVES : Heightmap.Types.MOTION_BLOCKING, p.m_123341_(), p.m_123343_());
            Vec3 candidate = new Vec3((double)Mth.m_14107_((double)base.f_82479_) + 0.5, (double)y + 0.5, (double)Mth.m_14107_((double)base.f_82481_) + 0.5);
            BlockState s = this.level.m_8055_(BlockPos.m_274446_((Position)candidate));
            boolean bl = this.entity.m_20182_().m_82554_(candidate) > 20.0 && (preferLeaves ? RaptorClimbTreeAI.isLeaves(s) : !RaptorClimbTreeAI.isLiquid(s)) ? true : (ok = false);
            if (!ok) continue;
            return candidate;
        }
        return null;
    }

    private static boolean isLiquid(BlockState s) {
        Material m = s.m_60767_();
        return m.m_76332_();
    }

    public boolean m_8045_() {
        BlockPos pos;
        if (!this.reachedTarget) {
            Path current = this.entity.m_21573_().m_26570_();
            if (current == null) {
                return false;
            }
            if (this.path != null && current != this.path && !current.m_77385_(this.path)) {
                return false;
            }
        } else if (!(this.level.m_45756_((Entity)this.entity, this.entity.m_20191_()) || RaptorClimbTreeAI.isLeaves(this.level.m_8055_(pos = this.entity.m_20183_())) || this.isLeafyFrontColumn(this.targetTrunk.m_121945_(this.approachSide)))) {
            return false;
        }
        return this.active && !this.gliding;
    }

    public void m_8041_() {
        this.lastActive = this.entity.f_19797_;
        this.path = null;
        this.targetTrunk = null;
        this.active = false;
        this.reachedTarget = false;
        this.glideTarget = null;
        this.entity.f_19794_ = false;
    }
}

