/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.navigation;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceBaseBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFencePoleBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.fence.FenceType;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;

public class DinosaurWalkNodeEvaluator
extends WalkNodeEvaluator {
    private final Supplier<Dinosaur> dinosaurSupplier;
    private Long2ObjectOpenHashMap<BlockPathTypes> cache;

    public DinosaurWalkNodeEvaluator(Supplier<Dinosaur> dinosaurSupplier) {
        this.dinosaurSupplier = Objects.requireNonNull(dinosaurSupplier);
    }

    public void m_6028_(PathNavigationRegion region, Mob mob) {
        super.m_6028_(region, mob);
        this.cache = new Long2ObjectOpenHashMap();
        mob.m_21441_(BlockPathTypes.DAMAGE_OTHER, 16.0f);
        mob.m_21441_(BlockPathTypes.DANGER_OTHER, 8.0f);
        mob.m_21441_(BlockPathTypes.DAMAGE_FIRE, 16.0f);
        mob.m_21441_(BlockPathTypes.DANGER_FIRE, 8.0f);
        Dinosaur d = this.safeDino();
        if (d != null) {
            // empty if block
        }
    }

    public void m_6802_() {
        super.m_6802_();
        this.cache = null;
    }

    public BlockPathTypes m_8086_(BlockGetter level, int x, int y, int z) {
        BlockPathTypes self;
        BlockPathTypes cached;
        long key = BlockPos.m_121882_((int)x, (int)y, (int)z);
        if (this.cache != null && (cached = (BlockPathTypes)this.cache.get(key)) != null) {
            return cached;
        }
        BlockPathTypes type = super.m_8086_(level, x, y, z);
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = level.m_8055_(pos);
        if (type != BlockPathTypes.BLOCKED && (self = this.classifyBlock(level, pos, state)) != null) {
            type = self;
        }
        if ((type == BlockPathTypes.WALKABLE || type == BlockPathTypes.OPEN) && y >= 1) {
            BlockPathTypes adj;
            BlockPathTypes below = this.getBelowType(level, x, y - 1, z);
            if (below != BlockPathTypes.WALKABLE && below != BlockPathTypes.OPEN && below != BlockPathTypes.WATER && below != BlockPathTypes.LAVA) {
                type = BlockPathTypes.WALKABLE;
            }
            if (below == BlockPathTypes.DAMAGE_FIRE) {
                type = BlockPathTypes.DAMAGE_FIRE;
            }
            if (below == BlockPathTypes.DAMAGE_OTHER) {
                type = BlockPathTypes.DAMAGE_OTHER;
            }
            if (below == BlockPathTypes.WATER) {
                type = BlockPathTypes.WATER;
            }
            if ((adj = this.checkAdjacentDanger(level, x, y, z)) != null) {
                if (adj == BlockPathTypes.DAMAGE_OTHER || adj == BlockPathTypes.DAMAGE_FIRE) {
                    this.putCache(key, adj);
                    return adj;
                }
                if (type == BlockPathTypes.WALKABLE || type == BlockPathTypes.OPEN) {
                    this.putCache(key, adj);
                    return adj;
                }
            }
        }
        this.putCache(key, type);
        return type;
    }

    private BlockPathTypes getBelowType(BlockGetter level, int x, int y, int z) {
        BlockPathTypes cached;
        long key = BlockPos.m_121882_((int)x, (int)y, (int)z);
        if (this.cache != null && (cached = (BlockPathTypes)this.cache.get(key)) != null) {
            return cached;
        }
        BlockPathTypes t = super.m_8086_(level, x, y, z);
        this.putCache(key, t);
        return t;
    }

    private void putCache(long key, BlockPathTypes t) {
        if (this.cache != null) {
            this.cache.put(key, (Object)t);
        }
    }

    private BlockPathTypes classifyBlock(BlockGetter level, BlockPos pos, BlockState state) {
        boolean open;
        FluidState fluid = state.m_60819_();
        if (!fluid.m_76178_()) {
            if (fluid.m_205070_(FluidTags.f_13131_)) {
                return BlockPathTypes.WATER;
            }
            if (fluid.m_205070_(FluidTags.f_13132_)) {
                return BlockPathTypes.LAVA;
            }
        }
        if (state.m_60734_() instanceof BaseRailBlock) {
            return BlockPathTypes.RAIL;
        }
        if (state.m_60734_() instanceof DoorBlock) {
            boolean open2 = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            if (open2) {
                return BlockPathTypes.DOOR_OPEN;
            }
            return state.m_204336_(BlockTags.f_13095_) ? BlockPathTypes.DOOR_WOOD_CLOSED : BlockPathTypes.DOOR_IRON_CLOSED;
        }
        if (state.m_60734_() instanceof FenceGateBlock && !(open = ((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue())) {
            return BlockPathTypes.FENCE;
        }
        if (state.m_60734_() instanceof FenceBlock || state.m_60734_() instanceof WallBlock) {
            return BlockPathTypes.FENCE;
        }
        if (state.m_60734_() instanceof TrapDoorBlock || state.m_60713_(Blocks.f_50196_)) {
            return BlockPathTypes.TRAPDOOR;
        }
        if (state.m_60713_(Blocks.f_50083_) || state.m_60713_(Blocks.f_50450_)) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        if (state.m_60713_(Blocks.f_50128_)) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        Block block = state.m_60734_();
        if (block instanceof ElectricFenceBaseBlock) {
            ElectricFenceBaseBlock base = (ElectricFenceBaseBlock)block;
            return this.fenceDanger(level, pos, base.getType(), false);
        }
        block = state.m_60734_();
        if (block instanceof ElectricFencePoleBlock) {
            ElectricFencePoleBlock pole = (ElectricFencePoleBlock)block;
            return this.fenceDanger(level, pos, pole.getType(), (Boolean)state.m_61143_((Property)ElectricFencePoleBlock.ACTIVE));
        }
        if (state.m_60734_() instanceof ElectricFenceWireBlock) {
            ElectricFenceWireBlockEntity wire;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof ElectricFenceWireBlockEntity && (wire = (ElectricFenceWireBlockEntity)be).isPowered()) {
                return BlockPathTypes.BLOCKED;
            }
            return BlockPathTypes.DANGER_OTHER;
        }
        return null;
    }

    private BlockPathTypes fenceDanger(BlockGetter level, BlockPos pos, FenceType type, boolean powered) {
        return this.isFencePowered(level, pos, type, powered) ? BlockPathTypes.BLOCKED : BlockPathTypes.DANGER_OTHER;
    }

    private boolean isFencePowered(BlockGetter level, BlockPos pos, FenceType type, boolean powered) {
        if (powered) {
            return true;
        }
        BlockPos.MutableBlockPos cursor = pos.m_122032_().m_122173_(Direction.UP);
        BlockState above = level.m_8055_((BlockPos)cursor);
        Block block = above.m_60734_();
        if (block instanceof ElectricFencePoleBlock) {
            ElectricFencePoleBlock pole = (ElectricFencePoleBlock)block;
            return pole.getType() == type && (Boolean)above.m_61143_((Property)ElectricFencePoleBlock.ACTIVE) != false;
        }
        while ((block = above.m_60734_()) instanceof ElectricFenceWireBlock) {
            ElectricFenceWireBlockEntity wireBe;
            ElectricFenceWireBlock wire = (ElectricFenceWireBlock)block;
            if (wire.getType() != type) {
                return false;
            }
            BlockEntity be = level.m_7702_((BlockPos)cursor);
            if (be instanceof ElectricFenceWireBlockEntity && (wireBe = (ElectricFenceWireBlockEntity)be).isPowered()) {
                return true;
            }
            cursor.m_122173_(Direction.UP);
            above = level.m_8055_((BlockPos)cursor);
        }
        return false;
    }

    private BlockPathTypes checkAdjacentDanger(BlockGetter level, int x, int y, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int dx = dir.m_122429_();
            int dz = dir.m_122431_();
            pos.m_122178_(x + dx, y, z + dz);
            BlockPathTypes t = this.dangerFrom(level, (BlockPos)pos);
            if (t != null) {
                return t;
            }
            pos.m_122178_(x + dx, y - 1, z + dz);
            t = this.dangerFrom(level, (BlockPos)pos);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private BlockPathTypes dangerFrom(BlockGetter level, BlockPos pos) {
        BlockPathTypes t = this.classifyBlock(level, pos, level.m_8055_(pos));
        if (t == BlockPathTypes.DAMAGE_OTHER || t == BlockPathTypes.DANGER_OTHER || t == BlockPathTypes.DAMAGE_FIRE || t == BlockPathTypes.DANGER_FIRE) {
            return t;
        }
        return null;
    }

    private Dinosaur safeDino() {
        try {
            return this.dinosaurSupplier.get();
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

