/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.navigation;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.SwimmingDinosaurEntity;

public class MoveUnderwaterEntityAI
extends Goal {
    private final SwimmingDinosaurEntity mob;
    private double x;
    private double y;
    private double z;
    private final int horiz = 8;
    private final int tries = 16;
    private final int minDepthFromSurface = 3;
    private final int minClearAboveFloor = 2;

    public MoveUnderwaterEntityAI(SwimmingDinosaurEntity entity) {
        this.mob = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.mob.m_20069_() || this.mob.isCarcass()) {
            return false;
        }
        if (this.mob.m_217043_().m_188501_() < 0.15f) {
            return false;
        }
        Vec3 target = this.pickUnderwaterTarget(this.mob.f_19853_, this.mob.m_20183_(), this.mob.m_217043_());
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    public boolean m_8045_() {
        return this.mob.m_20069_() && !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        if (this.mob.m_20069_() && this.isBottomedOut(this.mob)) {
            this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, 0.08, 0.0));
        }
        this.mob.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
    }

    private Vec3 pickUnderwaterTarget(Level level, BlockPos origin, RandomSource rnd) {
        if (level == null) {
            return null;
        }
        int minYWorld = level.m_141937_() + 1;
        int maxYWorld = level.m_151558_() - 2;
        for (int i = 0; i < 16; ++i) {
            int maxY;
            int minY;
            int floorY;
            int surfaceY;
            int dz;
            int dx = rnd.m_188503_(17) - 8;
            BlockPos col = origin.m_7918_(dx, 0, dz = rnd.m_188503_(17) - 8);
            if (!level.m_46805_(col) || (surfaceY = this.findSurfaceY(level, col)) == Integer.MIN_VALUE || (floorY = this.findFloorY(level, col, surfaceY)) == Integer.MAX_VALUE || (minY = Math.max(floorY + 2, minYWorld)) >= (maxY = Math.min(surfaceY - 3, maxYWorld))) continue;
            int y = minY + rnd.m_188503_(maxY - minY + 1);
            BlockPos p = new BlockPos(col.m_123341_(), y, col.m_123343_());
            if (!this.isWater(level, p) || !this.isWater(level, p.m_7494_())) continue;
            return Vec3.m_82512_((Vec3i)p);
        }
        return null;
    }

    private int findSurfaceY(Level level, BlockPos col) {
        int y;
        if (!level.m_46805_(col)) {
            return Integer.MIN_VALUE;
        }
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos(col.m_123341_(), col.m_123342_(), col.m_123343_());
        for (y = col.m_123342_(); !(y < level.m_141937_() || level.m_46805_((BlockPos)m.m_142448_(y)) && this.isWater(level, (BlockPos)m)); --y) {
        }
        if (y < level.m_141937_()) {
            return Integer.MIN_VALUE;
        }
        while (y + 1 < level.m_151558_() && level.m_46805_((BlockPos)m.m_142448_(y + 1)) && this.isWater(level, (BlockPos)m)) {
            ++y;
        }
        return y + 1;
    }

    private int findFloorY(Level level, BlockPos col, int surfaceY) {
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos(col.m_123341_(), surfaceY - 1, col.m_123343_());
        for (int y = surfaceY - 1; y >= level.m_141937_(); --y) {
            BlockState s;
            if (!level.m_46805_((BlockPos)m.m_142448_(y)) || this.isWater(level, (BlockPos)m) || (s = level.m_8055_((BlockPos)m)).m_60812_((BlockGetter)level, (BlockPos)m).m_83281_()) continue;
            return y;
        }
        return Integer.MAX_VALUE;
    }

    private boolean isWater(Level level, BlockPos pos) {
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    private boolean isBottomedOut(SwimmingDinosaurEntity e) {
        Level lvl = e.f_19853_;
        BlockPos feet = e.m_20183_();
        if (!lvl.m_46805_(feet) || !this.isWater(lvl, feet)) {
            return false;
        }
        BlockPos below = feet.m_7495_();
        return lvl.m_46805_(below) && !lvl.m_8055_(below).m_60812_((BlockGetter)lvl, below).m_83281_() && e.m_20184_().f_82480_ <= 0.0;
    }
}

