/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;

public class OnionTraverser
implements Iterable<BlockPos> {
    private final BlockPos center;
    private final int maxRadius;

    public OnionTraverser(BlockPos center, int maxRadius) {
        this.center = center;
        this.maxRadius = Math.max(0, maxRadius);
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new ShellIterator();
    }

    private final class ShellIterator
    implements Iterator<BlockPos> {
        private boolean centerEmitted = false;
        private boolean shellStarted = false;
        private int r = 0;
        private int dx = 0;
        private int dy = 0;
        private int dz = 0;
        private BlockPos next;

        private ShellIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.computeNext();
            return this.next != null;
        }

        @Override
        public BlockPos next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BlockPos out = this.next;
            this.next = null;
            return out;
        }

        private BlockPos computeNext() {
            if (!this.centerEmitted) {
                this.centerEmitted = true;
                return OnionTraverser.this.center;
            }
            if (!this.shellStarted) {
                this.shellStarted = true;
                this.r = 1;
                this.dz = -1;
                this.dy = -1;
                this.dx = -1;
            }
            while (this.r <= OnionTraverser.this.maxRadius) {
                while (this.dy <= this.r) {
                    while (this.dx <= this.r) {
                        while (this.dz <= this.r) {
                            if (this.maxAbs(this.dx, this.dy, this.dz) == this.r) {
                                BlockPos out = OnionTraverser.this.center.m_7918_(this.dx, this.dy, this.dz);
                                ++this.dz;
                                return out;
                            }
                            ++this.dz;
                        }
                        this.dz = -this.r;
                        ++this.dx;
                    }
                    this.dx = -this.r;
                    ++this.dy;
                }
                ++this.r;
                if (this.r > OnionTraverser.this.maxRadius) break;
                this.dy = this.dz = -this.r;
                this.dx = this.dz;
            }
            return null;
        }

        private int maxAbs(int a, int b, int c) {
            a = Math.abs(a);
            b = Math.abs(b);
            c = Math.abs(c);
            return Math.max(a, Math.max(b, c));
        }
    }
}

