/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.items.ModItems;
import org.jetbrains.annotations.Nullable;

public class PaddockSignEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private int dinosaur;

    public ResourceLocation getTextureLocation(PaddockSignEntity sign) {
        String name = DinosaurHandler.getName(sign.getDinosaur());
        return new ResourceLocation("jurassicreborn", "textures/paddock/" + name + ".png");
    }

    public PaddockSignEntity(EntityType<? extends PaddockSignEntity> type, Level world) {
        super(type, world);
    }

    public PaddockSignEntity(PlayMessages.SpawnEntity msg, Level world) {
        this((EntityType<? extends PaddockSignEntity>)((EntityType)ModEntities.PADDOCK_SIGN.get()), world);
        this.readSpawnData(msg.getAdditionalData());
    }

    public PaddockSignEntity(Level world, BlockPos clickedPos, Direction facing, int dinosaur) {
        super((EntityType)ModEntities.PADDOCK_SIGN.get(), world, clickedPos.m_121945_(facing));
        this.m_6022_(facing);
        this.dinosaur = dinosaur;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Dinosaur", this.dinosaur);
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.dinosaur = tag.m_128451_("Dinosaur");
        if (tag.m_128441_("Facing")) {
            this.m_6022_(Direction.m_122407_((int)tag.m_128445_("Facing")));
        }
    }

    public int m_7076_() {
        return 16;
    }

    public int m_7068_() {
        return 16;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dinosaur);
        buffer.writeLong(this.m_31748_().m_121878_());
        buffer.writeByte(this.f_31699_.m_122416_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        BlockPos p;
        this.dinosaur = buffer.readInt();
        this.f_31698_ = p = BlockPos.m_122022_((long)buffer.readLong());
        this.m_6022_(Direction.m_122407_((int)buffer.readUnsignedByte()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7084_() {
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        if (!this.f_19853_.m_5776_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            if (brokenEntity instanceof Player) {
                Player p = (Player)brokenEntity;
                if (p.m_150110_().f_35937_) {
                    return;
                }
            }
            ItemStack stack = new ItemStack((ItemLike)ModItems.PADDOCK_SIGN.get());
            stack.m_41784_().m_128405_("Dinosaur", this.dinosaur);
            this.m_5552_(stack, 0.0f);
        }
    }

    public int getDinosaur() {
        return this.dinosaur;
    }

    public void setDinosaur(int dinosaur) {
        this.dinosaur = dinosaur;
    }
}

