/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.vehicle;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jurassicreborn", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InterpValue
implements INBTSerializable<CompoundTag> {
    private static final List<InterpValue> VALUES = Lists.newArrayList();
    private static final List<InterpValue> TO_REMOVE = Lists.newArrayList();
    private final Supplier<Boolean> aliveCheck;
    private double speed;
    private double target;
    private double current;
    private double prev;
    private boolean init;

    public InterpValue(Entity e, double speed) {
        this(() -> ((Entity)e).m_6084_(), speed);
    }

    public double getCurrent() {
        return this.current;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpValue(Supplier<Boolean> aliveCheck, double speed) {
        this.aliveCheck = aliveCheck;
        this.speed = speed;
        List<InterpValue> list = VALUES;
        synchronized (list) {
            VALUES.add(this);
        }
    }

    public double getValueForRendering(float partialTicks) {
        return this.getRenderValue(partialTicks);
    }

    public boolean tickClient() {
        this.tick();
        return this.current == this.target;
    }

    public void setTarget(double t) {
        if (!this.init) {
            this.init = true;
            this.reset(t);
        } else {
            this.target = t;
        }
    }

    public void reset(double t) {
        this.current = this.target = t;
        this.prev = this.target;
    }

    public double getRenderValue(float partial) {
        return this.prev + (this.current - this.prev) * (double)partial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (!this.aliveCheck.get().booleanValue()) {
            List<InterpValue> list = TO_REMOVE;
            synchronized (list) {
                TO_REMOVE.add(this);
            }
            return;
        }
        this.prev = this.current;
        this.current = Math.abs(this.current - this.target) <= this.speed ? this.target : (this.current += this.current < this.target ? this.speed : -this.speed);
    }

    public void update() {
        this.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        List<InterpValue> list = VALUES;
        synchronized (list) {
            VALUES.forEach(InterpValue::tick);
            VALUES.removeAll(TO_REMOVE);
            TO_REMOVE.clear();
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("target", this.target);
        tag.m_128347_("current", this.current);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.current = this.prev = nbt.m_128459_("current");
        this.target = this.prev;
    }
}

