/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.genetics;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.genetics.DNA;
import net.vit.jurassicreborn.common.util.LangUtil;

public class DinoDNA
extends DNA {
    private String genetics;
    private Dinosaur dinosaur;

    public DinoDNA(Dinosaur dinosaur, int quality, String genetics) {
        super(dinosaur.getFormattedName(), quality);
        this.genetics = genetics;
        this.dinosaur = dinosaur == null ? Dinosaur.EMPTY : dinosaur;
    }

    public static DinoDNA fromStack(ItemStack stack) {
        return DinoDNA.readFromNBT(stack.m_41783_());
    }

    @Nullable
    public static DinoDNA readFromNBT(@Nullable CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        if (!tag.m_128441_("DNA")) {
            return null;
        }
        CompoundTag nbt = tag.m_128469_("DNA");
        return new DinoDNA(Dinosaur.getDinosaurByName(nbt.m_128461_("Dinosaur")), nbt.m_128451_("DNAQuality"), nbt.m_128461_("Genetics"));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("DNAQuality", this.quality);
        nbt.m_128359_("Genetics", this.genetics);
        nbt.m_128359_("StorageId", "DinoDNA");
        nbt.m_128359_("Dinosaur", this.dinosaur.getName());
        tag.m_128365_("DNA", (Tag)nbt);
    }

    public String getGenetics() {
        return this.genetics;
    }

    @Override
    public void addInformation(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)LangUtil.replaceWithDinoName(this.dinosaur, "lore.dinosaur").m_130940_(ChatFormatting.DARK_AQUA));
        ChatFormatting colour = this.quality > 75 ? ChatFormatting.GREEN : (this.quality > 50 ? ChatFormatting.YELLOW : (this.quality > 25 ? ChatFormatting.GOLD : (this.quality == -1 ? ChatFormatting.AQUA : ChatFormatting.RED)));
        String qualityString = Component.m_237115_((String)"lore.dna_quality").getString();
        Component quality = LangUtil.getFormattedQuality(this.quality);
        qualityString = qualityString.formatted(quality.getString(), "%");
        tooltip.add((Component)Component.m_237113_((String)qualityString).m_130940_(colour));
        String geneticString = Component.m_237115_((String)"lore.genetic_code").getString();
        Component genetics = LangUtil.getFormattedGenetics(this.genetics);
        geneticString = geneticString.formatted(genetics.getString());
        MutableComponent formattedQuality = Component.m_237113_((String)geneticString).m_130940_(ChatFormatting.BLUE);
        tooltip.add((Component)formattedQuality);
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public int getMetadata() {
        return -1;
    }

    public String getDinoName() {
        return this.dinosaur.getName();
    }
}

