/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.Food;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.ModWoodTypes;
import net.vit.jurassicreborn.common.blocks.wood.AncientLeavesBlock;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.items.ModItems;
import net.vit.jurassicreborn.common.plants.Plant;
import net.vit.jurassicreborn.common.plants.PlantHandler;

public class FoodHelper {
    private static final Map<FoodType, List<FoodKey>> FOOD_TYPES = new EnumMap<FoodType, List<FoodKey>>(FoodType.class);
    private static final List<FoodKey> FOODS = new LinkedList<FoodKey>();
    private static final Map<FoodKey, Integer> HEAL_AMOUNTS = new HashMap<FoodKey, Integer>();
    private static final Map<FoodKey, FoodEffect[]> FOOD_EFFECTS = new HashMap<FoodKey, FoodEffect[]>();

    public static void init() {
        FoodHelper.registerFood(LeavesBlock.class, FoodType.PLANT, 2000);
        FoodHelper.registerFood(TallGrassBlock.class, FoodType.PLANT, 1000);
        FoodHelper.registerFood(Blocks.f_50092_, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.f_50186_, FoodType.PLANT, 3000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.f_50130_, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(SaplingBlock.class, FoodType.PLANT, 1000);
        FoodHelper.registerFood(Blocks.f_50133_, FoodType.PLANT, 3000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.f_50249_, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.f_50250_, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.f_50335_, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.f_50196_, FoodType.PLANT, 500, new FoodEffect[0]);
        FoodHelper.registerFood(FlowerBlock.class, FoodType.PLANT, 500);
        FoodHelper.registerFood(SeagrassBlock.class, FoodType.PLANT, 500);
        FoodHelper.registerFood(TallFlowerBlock.class, FoodType.PLANT, 2000);
        FoodHelper.registerFood(TallSeagrassBlock.class, FoodType.PLANT, 2000);
        FoodHelper.registerFood(Blocks.f_50072_, FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.f_50073_, FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.COCKROACHES.get(), FoodType.INSECT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.CRICKETS.get(), FoodType.INSECT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.MEALWORM_BEETLES.get(), FoodType.INSECT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.RHAMNUS_BERRIES.get(), FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.RHAMNUS_SEEDS.get(), FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.WILD_ONION.get(), FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.WILD_POTATO.get(), FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.WILD_POTATO_COOKED.get(), FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.WILD_POTATO_SEEDS.get(), FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.KRILL.get(), FoodType.FILTER, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Item)ModItems.PLANKTON.get(), FoodType.FILTER, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Block)ModBlocks.PALEO_BALE_CYCADEOIDEA.get(), FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)ModBlocks.PALEO_BALE_CYCAD.get(), FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)ModBlocks.PALEO_BALE_FERN.get(), FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)ModBlocks.PALEO_BALE_LEAVES.get(), FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)ModBlocks.PALEO_BALE_OTHER.get(), FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)WoodBlocks.PHOENIX_LEAVES.get(), FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)WoodBlocks.MAGNOLIA_LEAVES.get(), FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)WoodBlocks.ARAUCARIA_LEAVES.get(), FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)WoodBlocks.PSARONIUS_LEAVES.get(), FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)WoodBlocks.CALAMITES_LEAVES.get(), FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)WoodBlocks.GINKGO_LEAVES.get(), FoodType.PLANT, 2000, new FoodEffect[0]);
        for (Plant plant : PlantHandler.getPlants()) {
            FoodHelper.registerFood(plant.getBlock(), FoodType.PLANT, plant.getHealAmount(), plant.getEffects());
        }
        for (WoodType woodType : ModWoodTypes.modWoodTypes) {
            FoodHelper.registerFood(AncientLeavesBlock.class, FoodType.PLANT, 2000);
            FoodHelper.registerFood((Block)WoodBlocks.getSaplingForType(woodType), FoodType.PLANT, 1000, new FoodEffect[0]);
        }
        FoodHelper.registerFood(Items.f_42405_, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Items.f_42404_, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.f_42578_, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.f_42577_, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.f_42733_, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.f_42732_, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.f_42734_, FoodType.PLANT, 600, new FoodEffect[0]);
        FoodHelper.registerFood(Items.f_41982_, FoodType.PLANT, 50, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42410_, FoodType.PLANT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42210_, FoodType.PLANT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42575_, FoodType.PLANT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42406_, FoodType.PLANT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42780_, FoodType.PLANT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42579_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42580_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42581_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42582_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42697_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42698_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42485_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42486_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42658_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42659_, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42527_, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42531_, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42526_, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42530_, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(Items.f_42528_, FoodType.FISH, new FoodEffect[0]);
        for (RegistryObject registryObject : ModItems.MEATS.values()) {
            FoodHelper.registerFoodAuto((Item)registryObject.get(), FoodType.MEAT, new FoodEffect[0]);
        }
        for (RegistryObject registryObject : ModItems.STEAKS.values()) {
            FoodHelper.registerFoodAuto((Item)registryObject.get(), FoodType.MEAT, new FoodEffect[0]);
        }
        FoodHelper.registerFoodAuto((Item)ModItems.GOAT_RAW.get(), FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((Item)ModItems.GOAT_COOKED.get(), FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((Item)ModItems.SHARK_MEAT_RAW.get(), FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((Item)ModItems.SHARK_MEAT_COOKED.get(), FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((Item)ModItems.CRAB_MEAT_COOKED.get(), FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((Item)ModItems.CRAB_MEAT_RAW.get(), FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((Item)ModItems.PHOENIX_FRUIT.get(), FoodType.PLANT, new FoodEffect[0]);
    }

    public static Ingredient getEdibleFoodIngredient(DinosaurEntity dino, Diet diet) {
        HashSet<Item> edibleItems = FoodHelper.getEdibleFoodItems(dino, diet);
        if (edibleItems.isEmpty()) {
            return Ingredient.f_43901_;
        }
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])edibleItems.toArray(new Item[0])));
    }

    private static void registerFood(Class<? extends Block> blockClass, FoodType plant, int i) {
        FoodHelper.registerFood(new FoodKey(blockClass), plant, i, new FoodEffect[0]);
    }

    public static void registerFoodAuto(Item food, FoodType foodType, FoodEffect ... effects) {
        ItemStack testStack = new ItemStack((ItemLike)food);
        if (food.getFoodProperties(testStack, null) != null) {
            int nutrition = food.getFoodProperties(testStack, null).m_38744_();
            FoodHelper.registerFood(new FoodKey(food), foodType, nutrition * 650, effects);
        } else {
            FoodHelper.registerFood(new FoodKey(food), foodType, 1300, effects);
        }
    }

    public static void registerFood(Item food, FoodType foodType, int healAmount, FoodEffect ... effects) {
        FoodHelper.registerFood(new FoodKey(food), foodType, healAmount, effects);
    }

    private static void registerFood(FoodKey food, FoodType foodType, int healAmount, FoodEffect ... effects) {
        if (!FOODS.contains(food)) {
            if (food == null || food.hashCode() == 0) {
                return;
            }
            FOOD_TYPES.get((Object)foodType).add(food);
            FOODS.add(food);
            HEAL_AMOUNTS.put(food, healAmount);
            FOOD_EFFECTS.put(food, effects);
        }
    }

    public static void registerFood(Block food, FoodType foodType, int foodAmount, FoodEffect ... effects) {
        FoodHelper.registerFood(new FoodKey(food), foodType, foodAmount, effects);
    }

    public static List<FoodKey> getFoodType(FoodType type) {
        return FOOD_TYPES.getOrDefault((Object)type, Collections.emptyList());
    }

    public static List<Item> getFoodItems(FoodType type) {
        return FoodHelper.getValidItemList(FoodHelper.getFoodType(type));
    }

    private static List<Item> getValidItemList(List<FoodKey> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        List<Item> items = keys.stream().filter(k -> !k.isGeneral).map(k -> {
            if (k.item != null) {
                return k.item;
            }
            if (k.block != null) {
                Item itm = Item.m_41439_((Block)k.block);
                return itm != Items.f_41852_ ? itm : null;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        for (FoodKey k2 : keys) {
            if (!k2.isGeneral || k2.BlockClass == null) continue;
            Item.f_41373_.keySet().stream().filter(b -> k.BlockClass.isAssignableFrom(b.getClass())).map(Item.f_41373_::get).filter(itm -> itm != null && itm != Items.f_41852_).forEach(items::add);
        }
        return items;
    }

    private static FoodType getFoodType(FoodKey key) {
        for (FoodType foodType : FoodType.values()) {
            if (!FoodHelper.getFoodType(foodType).contains(key)) continue;
            return foodType;
        }
        return null;
    }

    public static FoodType getFoodType(Item item) {
        return FoodHelper.getFoodType(new FoodKey(item));
    }

    public static FoodType getFoodType(Block block) {
        return FoodHelper.getFoodType(new FoodKey(block));
    }

    public static boolean isFoodType(Item item, FoodType foodType) {
        FoodKey key = new FoodKey(item);
        if (FoodHelper.getFoodType(foodType).contains(key)) {
            return true;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            for (FoodKey foodKey : FoodHelper.getFoodType(foodType)) {
                if (!foodKey.isGeneral || foodKey.BlockClass == null || !foodKey.BlockClass.isAssignableFrom(block.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEdible(DinosaurEntity entity, Diet diet, Item item) {
        return item != null && FoodHelper.getEdibleFoods(entity, diet).contains(new FoodKey(item));
    }

    public static boolean isEdible(DinosaurEntity entity, Diet diet, Block block) {
        return block != null && FoodHelper.getEdibleFoods(entity, diet).contains(new FoodKey(block));
    }

    public static HashSet<Item> getEdibleFoodItems(DinosaurEntity entity, Diet diet) {
        return Sets.newHashSet(FoodHelper.getValidItemList(FoodHelper.getEdibleFoods(entity, diet)));
    }

    public static List<FoodKey> getEdibleFoods(DinosaurEntity entity, Diet diet) {
        ArrayList<FoodKey> possible = new ArrayList<FoodKey>();
        for (Diet.DietModule module : diet.getModules()) {
            if (!module.applies(entity)) continue;
            possible.addAll(FoodHelper.getFoodType(module.getFoodType()));
        }
        return possible;
    }

    public static int getHealAmount(Item item) {
        return HEAL_AMOUNTS.getOrDefault(new FoodKey(item), 0);
    }

    public static void applyEatEffects(DinosaurEntity entity, Item item) {
        FoodEffect[] effects = FOOD_EFFECTS.get(new FoodKey(item));
        if (effects != null) {
            for (FoodEffect effect : effects) {
                if (entity.m_217043_().m_188503_(100) > effect.chance) continue;
                entity.m_7292_(new MobEffectInstance(effect.effect));
            }
        }
    }

    public static boolean isFood(Item item) {
        return FOODS.contains(new FoodKey(item));
    }

    public static boolean isFood(ItemStack stack) {
        return FoodHelper.isFood(stack.m_41720_());
    }

    public static boolean isFood(ItemEntity ent) {
        return FoodHelper.isFood(ent.m_32055_().m_41720_());
    }

    static {
        for (FoodType type : FoodType.values()) {
            FOOD_TYPES.put(type, new ArrayList());
        }
    }

    public static class FoodEffect {
        public MobEffect effect;
        public int chance;

        public FoodEffect(MobEffect effect, int chance) {
            this.effect = effect;
            this.chance = chance;
        }
    }

    static class FoodKey {
        public boolean isGeneral = false;
        final Item item;
        final Block block;
        final Class<? extends Block> BlockClass;

        FoodKey(Item item) {
            this.item = item;
            this.block = null;
            this.BlockClass = null;
        }

        FoodKey(Block block) {
            Item blkItm = Item.m_41439_((Block)block);
            this.item = blkItm != Items.f_41852_ ? blkItm : null;
            this.block = blkItm == Items.f_41852_ ? block : null;
            this.BlockClass = null;
        }

        FoodKey(Class<? extends Block> cls) {
            this.BlockClass = cls;
            this.isGeneral = true;
            this.block = null;
            this.item = null;
        }

        public boolean equals(Object o) {
            return o instanceof FoodKey && this.hashCode() == o.hashCode();
        }

        public int hashCode() {
            if (!this.isGeneral) {
                return this.item != null && this.item != Items.f_41852_ ? this.item.hashCode() : (this.block != null && this.block != Blocks.f_50016_ ? this.block.hashCode() : 0);
            }
            return this.BlockClass.hashCode() + 1;
        }
    }
}

