/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.JurassicClient;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlockEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.paleopad.AppHandler;
import net.vit.jurassicreborn.common.paleopad.FeederTrackerApp;
import net.vit.jurassicreborn.common.util.message.OpenPaleoPadEntityMessage;

public class PaleoPadItem
extends Item {
    public PaleoPadItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            this.openPaleoPad();
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof DinosaurEntity) {
            if (!player.f_19853_.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Network.sendTo(serverPlayer, new OpenPaleoPadEntityMessage((DinosaurEntity)target));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity blockEntity;
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        if (player != null && (blockEntity = level.m_7702_(pos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feeder = (FeederBlockEntity)blockEntity;
            Component name = feeder.m_7755_();
            ItemStack stack = ctx.m_43722_();
            if (stack.m_41788_()) {
                name = stack.m_41786_();
                feeder.m_58638_(name);
            }
            if (level.f_46443_) {
                if (!feeder.m_8077_()) {
                    this.openFeederNameScreen(pos);
                } else {
                    this.openPaleoPadFeederTracker();
                }
            } else {
                FeederTrackerApp.addFeeder(player, pos, name);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.setString(stack, "LastOwner", player.m_20148_().toString());
        }
    }

    public void setString(ItemStack stack, String key, String value) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_(key, value);
        stack.m_41751_(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openPaleoPad() {
        JurassicClient.openPaleoPad();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openFeederNameScreen(BlockPos pos) {
        JurassicClient.openFeederNameScreen(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openPaleoPadFeederTracker() {
        JurassicClient.openPaleoPad(AppHandler.INSTANCE.feederTracker);
    }
}

