/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class TabHandler {
    private static final Map<String, Long> SCROLLING_TAB_UPDATE_TIME = new LinkedHashMap<String, Long>();
    private static final Map<String, Integer> SCROLLING_TAB_ICON_INDEX = new LinkedHashMap<String, Integer>();
    private static final Map<String, List<Supplier<ItemStack>>> SCROLLING_TAB_ICON_SUPPLIERS = new LinkedHashMap<String, List<Supplier<ItemStack>>>();
    private static final Map<CreativeModeTab, List<Supplier<ItemStack>>> TAB_ITEM_SUPPLIERS = new LinkedHashMap<CreativeModeTab, List<Supplier<ItemStack>>>();
    private static final Map<CreativeModeTab, Component> TAB_TITLES = new LinkedHashMap<CreativeModeTab, Component>();
    private static final Map<CreativeModeTab, Supplier<ItemStack>> TAB_ICON_SUPPLIERS = new LinkedHashMap<CreativeModeTab, Supplier<ItemStack>>();
    private static final Map<CreativeModeTab, CreativeModeTab> TAB_ALIASES = new IdentityHashMap<CreativeModeTab, CreativeModeTab>();
    public static final CreativeModeTab ITEMS = TabHandler.makeTab("jurassicreborn.items", TabHandler.rotatingIcons("amber_mosquito", "amber_aphid", "dna_base_material"));
    public static final CreativeModeTab BLOCKS = TabHandler.makeSimpleTab("jurassicreborn.blocks", TabHandler.stackSupplier("gypsum_bricks"));
    public static final CreativeModeTab DECORATIONS = TabHandler.makeSimpleTab("jurassicreborn.decorations", TabHandler.stackSupplier("blueprint"));
    public static final CreativeModeTab DNA = TabHandler.makeSimpleTab("jurassicreborn.dna", TabHandler.stackSupplier("dna_base_material"));
    public static final CreativeModeTab SPAWN_EGGS = TabHandler.makeSimpleTab("jurassicreborn.spawn_eggs", () -> {
        ItemStack velociraptor = TabHandler.stackSupplier("spawn_egg/velociraptor_spawn_egg").get();
        if (!velociraptor.m_41619_()) {
            return velociraptor;
        }
        return TabHandler.stackSupplier("goat_spawn_egg").get();
    });
    public static final CreativeModeTab FOSSILS = TabHandler.makeSimpleTab("jurassicreborn.fossils", TabHandler.stackSupplier("fauna_fossil_block_item"));
    public static final CreativeModeTab FOODS = TabHandler.makeTab("jurassicreborn.foods", TabHandler.rotatingIcons("cooked_shark_meat", "raw_shark_meat", "fun_fries"));
    public static final CreativeModeTab PLANTS = TabHandler.makeSimpleTab("jurassicreborn.plants", TabHandler.stackSupplier("plant_callus"));

    public static CreativeModeTab makeSimpleTab(String name, Supplier<ItemStack> iconSupplier) {
        return TabHandler.buildTab(name, TabHandler.sanitize(iconSupplier));
    }

    public static CreativeModeTab makeTab(String name, List<Supplier<ItemStack>> iconSuppliers) {
        return TabHandler.buildTab(name, TabHandler.createIconSupplier(name, iconSuppliers));
    }

    private static CreativeModeTab buildTab(String name, Supplier<ItemStack> iconSupplier) {
        CreativeModeTab[] holder;
        MutableComponent title = Component.m_237115_((String)("itemGroup." + name));
        CreativeModeTab tab = CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257941_((Component)title).m_257737_(iconSupplier).m_257501_(new CreativeModeTab.DisplayItemsGenerator(){

            public void m_257865_(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
                TabHandler.populate(holder[0], output);
            }
        }).m_257652_();
        holder = new CreativeModeTab[]{tab};
        TAB_TITLES.put(tab, (Component)title);
        TAB_ICON_SUPPLIERS.put(tab, iconSupplier);
        TAB_ALIASES.put(tab, tab);
        return tab;
    }

    private static Supplier<ItemStack> createIconSupplier(String name, List<Supplier<ItemStack>> iconSuppliers) {
        if (iconSuppliers == null || iconSuppliers.isEmpty()) {
            return () -> ItemStack.f_41583_;
        }
        List<Supplier> sanitized = iconSuppliers.stream().filter(Objects::nonNull).map(TabHandler::sanitize).toList();
        if (sanitized.isEmpty()) {
            return () -> ItemStack.f_41583_;
        }
        if (sanitized.size() == 1) {
            return sanitized.get(0);
        }
        SCROLLING_TAB_ICON_SUPPLIERS.put(name, sanitized);
        return () -> {
            Supplier<ItemStack> current;
            List<Supplier<ItemStack>> suppliers = SCROLLING_TAB_ICON_SUPPLIERS.get(name);
            if (suppliers == null || suppliers.isEmpty()) {
                return ItemStack.f_41583_;
            }
            long now = System.currentTimeMillis();
            long last = SCROLLING_TAB_UPDATE_TIME.getOrDefault(name, 0L);
            int index = SCROLLING_TAB_ICON_INDEX.getOrDefault(name, 0);
            if (now - last >= 5000L) {
                index = (index + 1) % suppliers.size();
                SCROLLING_TAB_ICON_INDEX.put(name, index);
                SCROLLING_TAB_UPDATE_TIME.put(name, now);
            }
            return (current = suppliers.get(Math.min(index, suppliers.size() - 1))) != null ? current.get() : ItemStack.f_41583_;
        };
    }

    public static void registerCreativeModeTabs(CreativeModeTabEvent.Register event) {
        for (Map.Entry<CreativeModeTab, Component> e : TAB_TITLES.entrySet()) {
            CreativeModeTab tab = e.getKey();
            Component title = e.getValue();
            Supplier<ItemStack> iconSupplier = TAB_ICON_SUPPLIERS.getOrDefault(tab, () -> ItemStack.f_41583_);
            CreativeModeTab registered = event.registerCreativeModeTab(new ResourceLocation("jurassicreborn", TabHandler.extractPath(title.getString())), builder -> builder.m_257941_(title).m_257737_(iconSupplier).m_257501_((parameters, output) -> TabHandler.populate(tab, output)));
            TAB_ALIASES.put(registered, tab);
        }
    }

    public static void fillTabContents(CreativeModeTabEvent.BuildContents event) {
        CreativeModeTab baseTab = TAB_ALIASES.get(event.getTab());
        if (baseTab != null) {
            TabHandler.populate(baseTab, (arg_0, arg_1) -> ((CreativeModeTabEvent.BuildContents)event).m_246267_(arg_0, arg_1));
        }
    }

    private static String extractPath(String key) {
        int i = key.lastIndexOf(46);
        return i >= 0 ? key.substring(i + 1) : key;
    }

    private static void populate(CreativeModeTab tab, CreativeModeTab.Output output) {
        CreativeModeTab baseTab = TAB_ALIASES.getOrDefault(tab, tab);
        TAB_ITEM_SUPPLIERS.getOrDefault(baseTab, List.of()).stream().map(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
    }

    public static void addToTab(CreativeModeTab tab, Supplier<ItemStack> stackSupplier) {
        TAB_ITEM_SUPPLIERS.computeIfAbsent(tab, k -> new ArrayList()).add(stackSupplier);
    }

    public static void addToTab(CreativeModeTab tab, RegistryObject<? extends Item> itemSupplier) {
        TabHandler.addToTab(tab, () -> ((Item)itemSupplier.get()).m_7968_());
    }

    public static void addItemToTab(CreativeModeTab tab, Supplier<? extends Item> itemSupplier) {
        TabHandler.addToTab(tab, () -> new ItemStack((ItemLike)itemSupplier.get()));
    }

    private static Supplier<ItemStack> sanitize(Supplier<ItemStack> supplier) {
        return () -> {
            if (supplier == null) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = (ItemStack)supplier.get();
            return stack == null ? ItemStack.f_41583_ : stack;
        };
    }

    private static Supplier<ItemStack> stackSupplier(String path) {
        return () -> TabHandler.stackFromRegistry(path);
    }

    private static List<Supplier<ItemStack>> rotatingIcons(String ... itemIds) {
        ArrayList<Supplier<ItemStack>> suppliers = new ArrayList<Supplier<ItemStack>>();
        for (String id : itemIds) {
            suppliers.add(TabHandler.stackSupplier(id));
        }
        return suppliers;
    }

    private static ItemStack stackFromRegistry(String path) {
        ResourceLocation id;
        if (path == null || path.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ResourceLocation resourceLocation = id = path.contains(":") ? ResourceLocation.m_135820_((String)path) : new ResourceLocation("jurassicreborn", path);
        if (id == null) {
            return ItemStack.f_41583_;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = item.m_7968_();
        return stack == null ? ItemStack.f_41583_ : stack;
    }
}

