/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.misc;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.genetics.GeneticsHelper;
import net.vit.jurassicreborn.common.util.LangUtil;

public class DinosaurSpawnEggItem
extends Item {
    private static final String TAG_GENDER = "GenderMode";
    private final Dinosaur dinosaur;
    private final Supplier<? extends EntityType<? extends DinosaurEntity>> entityTypeSupplier;

    public DinosaurSpawnEggItem(Dinosaur dinosaur, Supplier<? extends EntityType<? extends DinosaurEntity>> entityTypeSupplier) {
        super(new Item.Properties());
        this.dinosaur = dinosaur;
        this.entityTypeSupplier = entityTypeSupplier;
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent dinoName = this.dinosaur.getTranslatedName();
        return Component.m_237110_((String)"item.jurassicreborn.spawn_egg_name", (Object[])new Object[]{dinoName});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            int mode = this.changeMode(stack);
            if (world.f_46443_) {
                String template = LangUtil.translate("item.spawnegg.change_gender");
                String genderText = LangUtil.getGender(mode).getString();
                String msg = template.replace("{mode}", genderText);
                player.m_5661_((Component)Component.m_237113_((String)msg), true);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        double z;
        double y;
        Level world = ctx.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        BlockEntity be = world.m_7702_(pos);
        EntityType<?> resolvedType = this.resolveEntityType();
        if (resolvedType == null) {
            return InteractionResult.PASS;
        }
        if (be instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)be;
            spawner.m_59801_().m_253197_(resolvedType, world, world.m_213780_(), pos);
            spawner.m_6596_();
            if (player != null && !player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        BlockPos spawnPos = pos.m_121945_(ctx.m_43719_());
        double x = (double)spawnPos.m_123341_() + 0.5;
        DinosaurEntity ent = this.spawnDinosaur(world, player, stack, resolvedType, x, y = (double)spawnPos.m_123342_(), z = (double)spawnPos.m_123343_() + 0.5);
        if (ent != null) {
            if (player != null && !player.m_7500_()) {
                stack.m_41774_(1);
            }
            world.m_7967_((Entity)ent);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private EntityType<?> resolveEntityType() {
        EntityType type = this.entityTypeSupplier.get();
        if (type != null) {
            return type;
        }
        String base = this.dinosaur.getName().toLowerCase(Locale.ROOT);
        ResourceLocation key = new ResourceLocation("jurassicreborn", base);
        type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(key);
        if (type == null) {
            ResourceLocation alt = new ResourceLocation("jurassicreborn", "velociraptor" + base);
            type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(alt);
        }
        return type;
    }

    private DinosaurEntity spawnDinosaur(Level world, Player player, ItemStack stack, EntityType<?> entityType, double x, double y, double z) {
        Entity raw = entityType.m_20615_(world);
        if (!(raw instanceof DinosaurEntity)) {
            return null;
        }
        DinosaurEntity dino = (DinosaurEntity)raw;
        dino.m_6034_(x, y, z);
        dino.m_146922_(world.f_46441_.m_188501_() * 360.0f);
        dino.setGenetics(GeneticsHelper.randomGenetics(world.f_46441_));
        dino.setDNAQuality(100);
        int gender = this.getMode(stack);
        if (gender == 1) {
            dino.setMale(true);
        } else if (gender == 2) {
            dino.setMale(false);
        } else {
            dino.setMale(world.f_46441_.m_188499_());
        }
        if (player != null && player.m_6144_()) {
            dino.setAge(0);
        }
        return dino;
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_(TAG_GENDER);
    }

    private int changeMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int mode = (tag.m_128451_(TAG_GENDER) + 1) % 3;
        tag.m_128405_(TAG_GENDER, mode);
        stack.m_41751_(tag);
        return mode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)LangUtil.translate("lore.spawnegg.use_on_spawner")));
        tooltip.add((Component)Component.m_237113_((String)LangUtil.translate("lore.spawnegg.sneak_to_change_gender")));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

