/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.legacy.tabula;

import com.github.alexthe666.citadel.client.model.container.TabulaCubeContainer;
import com.github.alexthe666.citadel.client.model.container.TabulaCubeGroupContainer;
import com.github.alexthe666.citadel.client.model.container.TabulaModelContainer;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.resources.ResourceLocation;

public class TabulaModelHelper {
    public static TabulaCubeContainer getCubeByName(String name, TabulaModelContainer model) {
        List<TabulaCubeContainer> allCubes = TabulaModelHelper.getAllCubes(model);
        for (TabulaCubeContainer cube : allCubes) {
            if (!cube.getName().equals(name)) continue;
            return cube;
        }
        return null;
    }

    public static TabulaCubeContainer getCubeByIdentifier(String identifier, TabulaModelContainer model) {
        List<TabulaCubeContainer> allCubes = TabulaModelHelper.getAllCubes(model);
        for (TabulaCubeContainer cube : allCubes) {
            if (!cube.getIdentifier().equals(identifier)) continue;
            return cube;
        }
        return null;
    }

    public static List<TabulaCubeContainer> getAllCubes(TabulaModelContainer model) {
        ArrayList<TabulaCubeContainer> cubes = new ArrayList<TabulaCubeContainer>();
        try {
            for (TabulaCubeGroupContainer cubeGroup : model.getCubeGroups()) {
                cubes.addAll(TabulaModelHelper.traverse(cubeGroup));
            }
            for (TabulaCubeContainer cube : model.getCubes()) {
                cubes.addAll(TabulaModelHelper.traverse(cube));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cubes;
    }

    private static List<TabulaCubeContainer> traverse(TabulaCubeGroupContainer group) {
        ArrayList<TabulaCubeContainer> retCubes = new ArrayList<TabulaCubeContainer>();
        for (TabulaCubeContainer child : group.getCubes()) {
            retCubes.addAll(TabulaModelHelper.traverse(child));
        }
        for (TabulaCubeContainer child : group.getCubeGroups()) {
            retCubes.addAll(TabulaModelHelper.traverse((TabulaCubeGroupContainer)child));
        }
        return retCubes;
    }

    private static List<TabulaCubeContainer> traverse(TabulaCubeContainer cube) {
        ArrayList<TabulaCubeContainer> retCubes = new ArrayList<TabulaCubeContainer>();
        retCubes.add(cube);
        for (TabulaCubeContainer child : cube.getChildren()) {
            retCubes.addAll(TabulaModelHelper.traverse(child));
        }
        return retCubes;
    }

    public static TabulaModelContainer loadTabulaModel(String path) throws IOException {
        InputStream stream;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith(".tbl")) {
            path = (String)path + ".tbl";
        }
        if ((stream = TabulaModelHelper.class.getResourceAsStream((String)path)) == null) {
            return null;
        }
        return TabulaModelHelper.loadTabulaModel(TabulaModelHelper.getModelJsonStream((String)path, stream));
    }

    public static TabulaModelContainer loadTabulaModel(InputStream stream) {
        return (TabulaModelContainer)new Gson().fromJson((Reader)new InputStreamReader(stream), TabulaModelContainer.class);
    }

    private static InputStream getModelJsonStream(String name, InputStream file) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(file);
        while ((entry = zip.getNextEntry()) != null) {
            if (!entry.getName().equals("model.json")) continue;
            return zip;
        }
        throw new RuntimeException("No model.json present in " + name);
    }

    public static TabulaModelContainer loadTabulaModel(ResourceLocation location) throws IOException {
        String path = "/assets/" + location.m_135827_() + "/" + location.m_135815_() + ".tbl";
        try (InputStream stream = TabulaModelHelper.class.getResourceAsStream(path);){
            if (stream == null) {
                throw new IllegalArgumentException("Could not find tabula model at " + location);
            }
            TabulaModelContainer tabulaModelContainer = TabulaModelHelper.loadTabulaModel(TabulaModelHelper.getModelJsonStream(path, stream));
            return tabulaModelContainer;
        }
    }
}

