/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.entities.vehicle.FordExplorerSnowEntity;

public class FordExplorerSnowUpdatePositionStateMessage {
    private final int entityId;
    private final long railPos;

    public FordExplorerSnowUpdatePositionStateMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.railPos = buf.readLong();
    }

    public FordExplorerSnowUpdatePositionStateMessage(int entityId, @Nullable BlockPos pos) {
        this.entityId = entityId;
        this.railPos = (pos == null ? FordExplorerSnowEntity.INACTIVE : pos).m_121878_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeLong(this.railPos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Client.handle(this)));
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        static void handle(FordExplorerSnowUpdatePositionStateMessage msg) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity e = level.m_6815_(msg.entityId);
            if (e instanceof FordExplorerSnowEntity) {
                FordExplorerSnowEntity car = (FordExplorerSnowEntity)e;
                BlockPos newPos = BlockPos.m_122022_((long)msg.railPos);
                if (msg.railPos == FordExplorerSnowEntity.INACTIVE.m_121878_()) {
                    newPos = FordExplorerSnowEntity.INACTIVE;
                }
                car.prevRailTracks = car.railTracks;
                car.railTracks = newPos;
            }
        }
    }
}

