/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlockEntity;
import net.vit.jurassicreborn.common.paleopad.FeederTrackerApp;

public class NameFeederPacket {
    private final BlockPos pos;
    private final String name;

    public NameFeederPacket(BlockPos pos, String name) {
        this.pos = pos;
        this.name = name;
    }

    public static void encode(NameFeederPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.m_130070_(pkt.name);
    }

    public static NameFeederPacket decode(FriendlyByteBuf buf) {
        return new NameFeederPacket(buf.m_130135_(), buf.m_130277_());
    }

    public static void handle(NameFeederPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            BlockEntity be;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (be = (level = player.f_19853_).m_7702_(pkt.pos)) instanceof FeederBlockEntity) {
                FeederBlockEntity feeder = (FeederBlockEntity)be;
                MutableComponent nameComp = Component.m_237113_((String)pkt.name);
                feeder.m_58638_((Component)nameComp);
                FeederTrackerApp.addFeeder((Player)player, pkt.pos, (Component)nameComp);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

