/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.recipes.cleaner;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.recipes.FluidAndItemRecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class CleaningRecipe
implements Recipe<FluidAndItemRecipeWrapper> {
    public static final RecipeType<CleaningRecipe> CLEANING = RecipeType.simple((ResourceLocation)JurassicReborn.resource("cleaning"));
    public static Serializer INSTANCE = new Serializer();
    final ResourceLocation id;
    final Ingredient input;
    final ItemStack output;

    public CleaningRecipe(ResourceLocation id, Ingredient input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public boolean matches(FluidAndItemRecipeWrapper pContainer, Level pLevel) {
        ItemStack recipeItem = pContainer.m_8020_(0);
        return this.input.test(recipeItem) && pContainer.getTank().getFluidInTank(0).getAmount() > 0;
    }

    @Nonnull
    public ItemStack assemble(FluidAndItemRecipeWrapper pContainer, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return CLEANING;
    }

    private static class Serializer
    implements RecipeSerializer<CleaningRecipe> {
        Serializer() {
        }

        public CleaningRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            Ingredient input = CraftingHelper.getIngredient((JsonElement)pSerializedRecipe.getAsJsonObject("input"));
            ItemStack output = CraftingHelper.getItemStack((JsonObject)pSerializedRecipe.getAsJsonObject("output"), (boolean)false);
            return new CleaningRecipe(pRecipeId, input, output);
        }

        @Nullable
        public CleaningRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack output = pBuffer.m_130267_();
            return new CleaningRecipe(pRecipeId, input, output);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CleaningRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.writeItemStack(pRecipe.output, false);
        }
    }
}

