/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.util;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.item.AttractionSignEntity;
import net.vit.jurassicreborn.common.items.misc.AttractionSignItem;

public class LangUtil {
    public static final String LORE = "lore.%s";
    public static final String GENDER_CHANGE = "%s.genderchange";
    public static final TranslateKey GUI = new TranslateKey("gui.%s.name");
    public static final TranslateKey STATUS = new TranslateKey("status.%s.name");
    public static final TranslateKey STAND_CHANGE = new TranslateKey("%s.standchange.name");

    public static MutableComponent getDinoName(Dinosaur dino) {
        return Component.m_237115_((String)LangUtil.getEntityKey(dino.getName().replace(" ", "_").toLowerCase(Locale.ENGLISH)));
    }

    public static MutableComponent replaceInKey(Supplier<String> replacement, String replaceTarget, String key) {
        return Component.m_237113_((String)Component.m_237115_((String)key).getString().replace(replaceTarget, replacement.get()));
    }

    public static Component replaceWithDinosaurName(Dinosaur name, String key) {
        return LangUtil.replaceInKey(() -> name.getTranslatedName().getString(), "{dinosaur}", key);
    }

    public static MutableComponent replaceWithDinoName(Dinosaur name, String key) {
        return LangUtil.replaceInKey(() -> name.getTranslatedName().getString(), "{dino}", key);
    }

    public static String getStandType(boolean type) {
        return type ? LangUtil.translate("stand.stand.name") : LangUtil.translate("stand.placed.name");
    }

    public static String getEntityKey(String key) {
        return "entity.jurassicreborn." + key;
    }

    public static Component getFormattedQuality(int quality) {
        return quality == -1 ? Component.m_237113_((String)"??").m_130940_(ChatFormatting.OBFUSCATED) : Component.m_237113_((String)Integer.toString(quality));
    }

    public static String getDinoInfo(Dinosaur dinosaur) {
        String key = "info." + dinosaur.getName().replace(" ", "_").toLowerCase(Locale.ENGLISH) + ".name";
        return Component.m_237115_((String)key).getString();
    }

    public static String translate(String key) {
        return Component.m_237115_((String)key).getString();
    }

    public static String getGenderMode(int gender) {
        return LangUtil.getGender(gender).getString();
    }

    public static String getGUIKey(String key) {
        return "gui.jurassicreborn." + key;
    }

    public static String getStatusKey(String status) {
        return "status." + status;
    }

    public static Component getFormattedGenetics(String genetics) {
        return genetics.isEmpty() ? Component.m_237113_((String)"???").m_130940_(ChatFormatting.OBFUSCATED) : Component.m_237113_((String)genetics);
    }

    public static MutableComponent getGender(int gender) {
        String genderKey = "";
        if (gender == 0) {
            genderKey = "random";
        } else if (gender == 1) {
            genderKey = "male";
        } else if (gender == 2) {
            genderKey = "female";
        }
        return Component.m_237115_((String)("gender." + genderKey));
    }

    public static String getAttractionSignName(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof AttractionSignItem) {
            AttractionSignItem sign = (AttractionSignItem)item;
            AttractionSignEntity.AttractionSignType type = sign.getType();
            String key = String.format("attraction_sign.%s.name", type.name().toLowerCase(Locale.ROOT));
            return LangUtil.translate(key);
        }
        return "";
    }

    public static class TranslateKey {
        private final String format;

        public TranslateKey(String format) {
            this.format = format;
        }

        public String get(String key) {
            return String.format(this.format, key);
        }
    }
}

