/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.util.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.vit.jurassicreborn.client.JurassicClient;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class OpenPaleoPadEntityMessage {
    private final int entityId;
    private final DinosaurEntity.FieldGuideInfo guideInfo;

    public OpenPaleoPadEntityMessage(int entityId, DinosaurEntity.FieldGuideInfo guideInfo) {
        this.entityId = entityId;
        this.guideInfo = guideInfo;
    }

    public OpenPaleoPadEntityMessage(DinosaurEntity entity) {
        this(entity.m_19879_(), entity.getFieldGuideInfo());
    }

    public static void write(OpenPaleoPadEntityMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        DinosaurEntity.FieldGuideInfo.write(buf, message.guideInfo);
    }

    public static OpenPaleoPadEntityMessage read(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        DinosaurEntity.FieldGuideInfo guideInfo = DinosaurEntity.FieldGuideInfo.read(buf);
        return new OpenPaleoPadEntityMessage(entityId, guideInfo);
    }

    public OpenPaleoPadEntityMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.guideInfo = DinosaurEntity.FieldGuideInfo.read(buf);
    }

    public static OpenPaleoPadEntityMessage decode(FriendlyByteBuf buf) {
        return new OpenPaleoPadEntityMessage(buf);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        DinosaurEntity.FieldGuideInfo.write(buf, this.guideInfo);
    }

    public static void handle(OpenPaleoPadEntityMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Client.handle(message)));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        static void handle(OpenPaleoPadEntityMessage message) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Entity entity = player.f_19853_.m_6815_(message.entityId);
            if (entity instanceof DinosaurEntity) {
                DinosaurEntity dinosaur = (DinosaurEntity)entity;
                JurassicClient.openPaleoDinosaurPad(dinosaur, message.guideInfo);
            }
        }
    }
}

