/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.vit.jurassicreborn.common.CommonRegistries;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.worldgen.ModPlacements;

public record BiomeModification(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && !biome.m_203656_(BiomeTags.f_207612_) && !biome.m_203656_(BiomeTags.f_215818_)) {
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.ICE_SHARD_ORE_PLACEMENT);
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.FAUNA_FOSSIL_PLACEMENT);
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.FLORA_FOSSIL_PLACEMENT);
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.NEST_FOSSIL_PLACEMENT);
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.AMBER_ORE_PLACEMENT);
            if (!biome.m_203656_(Tags.Biomes.IS_VOID)) {
                builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.PLACED_LARGE_PETRIFIED_TREE);
                builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.PLACED_SMALL_PETRIFIED_TREE);
            }
            if (RebornConfig.spawnCrabs && (biome.m_203656_(Tags.Biomes.IS_WET) || biome.m_203656_(BiomeTags.f_207603_))) {
                builder.getMobSpawnSettings().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.CRAB.get(), 8, 2, 4));
            }
            if (RebornConfig.spawnSharks && biome.m_203656_(BiomeTags.f_207603_)) {
                builder.getMobSpawnSettings().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SHARK.get(), 2, 1, 2));
            }
            if (RebornConfig.spawnGoats && (biome.m_203656_(BiomeTags.f_207606_) || biome.m_203656_(Tags.Biomes.IS_MOUNTAIN))) {
                builder.getMobSpawnSettings().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GOAT.get(), 6, 2, 4));
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)CommonRegistries.BIOME_MODIFIER_CODEC.get();
    }
}

