/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.fossil.FaunaFossil;
import net.vit.jurassicreborn.common.blocks.fossil.FloraFossil;
import net.vit.jurassicreborn.common.worldgen.ModFeatures;
import net.vit.jurassicreborn.common.worldgen.tree.petrified.PetrifiedTreeConfig;

public final class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARAUCARIA = ModConfiguredFeatures.key("araucaria_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GINKGO = ModConfiguredFeatures.key("ginkgo_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CALAMITES = ModConfiguredFeatures.key("calamites_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PHOENIX = ModConfiguredFeatures.key("phoenix_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PSARONIUS = ModConfiguredFeatures.key("psaronius_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGNOLIA = ModConfiguredFeatures.key("magnolia_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLORA_FOSSIL_ORE = ModConfiguredFeatures.key("flora_fossil_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FAUNA_FOSSIL_ORE = ModConfiguredFeatures.key("fauna_fossil_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMBER_ORE = ModConfiguredFeatures.key("amber_ore_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICE_SHARD_ORE = ModConfiguredFeatures.key("ice_shard_ore_configured");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NEST_FOSSIL = ModConfiguredFeatures.key("configured_nest_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PETRIFIED_TREE_SMALL = ModConfiguredFeatures.key("configured_small_petrified_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PETRIFIED_TREE_LARGE = ModConfiguredFeatures.key("configured_large_petrified_tree");

    private ModConfiguredFeatures() {
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        List<OreConfiguration.TargetBlockState> amberTargets;
        TagMatchTest STONE_ORE_TARGET = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest DEEPSLATE_ORE_TARGET = new TagMatchTest(BlockTags.f_144267_);
        List<OreConfiguration.TargetBlockState> floraTargets = List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_TARGET, (BlockState)((FloraFossil)ModBlocks.FLORA_FOSSIL.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_TARGET, (BlockState)((FloraFossil)ModBlocks.DEEPSLATE_FLORA_FOSSIL.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> faunaTargets = List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_TARGET, (BlockState)((FaunaFossil)ModBlocks.FAUNA_FOSSIL.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> iceShardTargets = amberTargets = List.of(OreConfiguration.m_161021_((RuleTest)STONE_ORE_TARGET, (BlockState)((Block)ModBlocks.AMBER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)DEEPSLATE_ORE_TARGET, (BlockState)((Block)ModBlocks.DEEPSLATE_AMBER_ORE.get()).m_49966_()));
        ModConfiguredFeatures.register(ctx, ARAUCARIA, FeatureUtils.withConfig((Feature)ModFeatures.AraucariaTreePre.get(), NoneFeatureConfiguration.f_67816_));
        ModConfiguredFeatures.register(ctx, GINKGO, FeatureUtils.withConfig((Feature)ModFeatures.GinkgoTreePre.get(), NoneFeatureConfiguration.f_67816_));
        ModConfiguredFeatures.register(ctx, CALAMITES, FeatureUtils.withConfig((Feature)ModFeatures.CalamitesTreePre.get(), NoneFeatureConfiguration.f_67816_));
        ModConfiguredFeatures.register(ctx, PHOENIX, FeatureUtils.withConfig((Feature)ModFeatures.PhoenixTreePre.get(), NoneFeatureConfiguration.f_67816_));
        ModConfiguredFeatures.register(ctx, PSARONIUS, FeatureUtils.withConfig((Feature)ModFeatures.PsaroniusTreePre.get(), NoneFeatureConfiguration.f_67816_));
        ModConfiguredFeatures.register(ctx, MAGNOLIA, FeatureUtils.withConfig((Feature)ModFeatures.MagnoliaTreePre.get(), NoneFeatureConfiguration.f_67816_));
        ModConfiguredFeatures.register(ctx, FLORA_FOSSIL_ORE, Feature.f_65731_, new OreConfiguration(floraTargets, 17));
        ModConfiguredFeatures.register(ctx, FAUNA_FOSSIL_ORE, Feature.f_65731_, new OreConfiguration(faunaTargets, 3));
        ModConfiguredFeatures.register(ctx, AMBER_ORE, Feature.f_65731_, new OreConfiguration(amberTargets, 3));
        ModConfiguredFeatures.register(ctx, ICE_SHARD_ORE, Feature.f_65731_, new OreConfiguration(iceShardTargets, 3));
        ModConfiguredFeatures.register(ctx, NEST_FOSSIL, FeatureUtils.withConfig((Feature)ModFeatures.NEST_FOSSIL_FEATURE.get(), NoneFeatureConfiguration.f_67816_));
        ModConfiguredFeatures.register(ctx, PETRIFIED_TREE_SMALL, FeatureUtils.withConfig((Feature)ModFeatures.PETRIFIED_TREE_GENERATOR.get(), new PetrifiedTreeConfig(10, 0.2f)));
        ModConfiguredFeatures.register(ctx, PETRIFIED_TREE_LARGE, FeatureUtils.withConfig((Feature)ModFeatures.PETRIFIED_TREE_GENERATOR.get(), new PetrifiedTreeConfig(15, 0.1f)));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("jurassicreborn", name));
    }

    private static <C extends FeatureConfiguration> void register(BootstapContext<ConfiguredFeature<?, ?>> ctx, ResourceKey<ConfiguredFeature<?, ?>> key, Feature<C> feature, C config) {
        ctx.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
    }

    private static void register(BootstapContext<ConfiguredFeature<?, ?>> ctx, ResourceKey<ConfiguredFeature<?, ?>> key, ConfiguredFeature<?, ?> configured) {
        ctx.m_255272_(key, configured);
    }

    private static final class FeatureUtils {
        private FeatureUtils() {
        }

        static <C extends FeatureConfiguration> ConfiguredFeature<C, ?> withConfig(Feature<C> f, C c) {
            return new ConfiguredFeature(f, c);
        }
    }
}

