/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("item").forGetter(m -> Optional.ofNullable(m.item))).and((App)ResourceLocation.f_135803_.xmap(id -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)id), TagKey::f_203868_).optionalFieldOf("tag").forGetter(m -> Optional.ofNullable(m.tag))).and((App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(m -> Float.valueOf(m.chance))).and((App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(m -> m.count)).apply((Applicative)inst, (conditions, optItem, optTag, chance, count) -> new AddItemModifier((LootItemCondition[])conditions, optItem.orElse(null), (TagKey<Item>)((TagKey)optTag.orElse(null)), chance.floatValue(), (int)count))));
    private final Item item;
    private final TagKey<Item> tag;
    private final float chance;
    private final int count;

    public AddItemModifier(LootItemCondition[] conditions, Item item, TagKey<Item> tag, float chance, int count) {
        super(conditions);
        this.item = item;
        this.tag = tag;
        this.chance = chance;
        this.count = count;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generated, LootContext ctx) {
        List pool;
        if (ctx.m_230907_().m_188501_() > this.chance) {
            return generated;
        }
        Item toAdd = this.item;
        if (toAdd == null && this.tag != null && !(pool = ForgeRegistries.ITEMS.tags().getTag(this.tag).stream().toList()).isEmpty()) {
            toAdd = (Item)pool.get(ctx.m_230907_().m_188503_(pool.size()));
        }
        if (toAdd != null) {
            generated.add((Object)new ItemStack((ItemLike)toAdd, this.count));
        }
        return generated;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

