/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen.structure;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;

public abstract class StructureGenerator {
    protected Rotation rotation;
    protected Mirror mirror;
    protected int horizontalPos = -1;
    protected final int sizeX;
    protected final int sizeY;
    protected final int sizeZ;

    protected StructureGenerator(RandomSource rand, int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        Rotation[] rotations = Rotation.values();
        this.rotation = rotations[rand.m_188503_(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        this.mirror = mirrors[rand.m_188503_(mirrors.length)];
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void setMirror(Mirror mirror) {
        this.mirror = mirror;
    }

    protected BlockPos placeOnGround(ServerLevel level, BlockPos pos, int yOffset) {
        if (this.horizontalPos >= 0) {
            return new BlockPos(pos.m_123341_(), this.horizontalPos, pos.m_123343_());
        }
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        BlockPos min = this.transformPos(new BlockPos(0, 0, 0), this.mirror, this.rotation).m_121955_((Vec3i)pos);
        BlockPos max = this.transformPos(new BlockPos(this.sizeX - 1, 0, this.sizeZ - 1), this.mirror, this.rotation).m_121955_((Vec3i)pos);
        int minX = Math.min(min.m_123341_(), max.m_123341_());
        int minZ = Math.min(min.m_123343_(), max.m_123343_());
        int maxX = Math.max(min.m_123341_(), max.m_123341_());
        int maxZ = Math.max(min.m_123343_(), max.m_123343_());
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                if (x != minX && x != maxX && z != minZ && z != maxZ) continue;
                BlockPos ground = this.getGround(level, new BlockPos(x, 64, z));
                int levelY = ground.m_123342_();
                if (levelY < minHeight) {
                    minHeight = levelY;
                }
                if (levelY <= maxHeight) continue;
                maxHeight = levelY;
            }
        }
        int average = (maxHeight + minHeight) / 2;
        if (average - minHeight > 8 && !this.canSpawnOnHills()) {
            return null;
        }
        this.horizontalPos = minHeight + yOffset;
        return new BlockPos(pos.m_123341_(), this.horizontalPos, pos.m_123343_());
    }

    protected BlockPos getGround(ServerLevel level, BlockPos pos) {
        BlockPos below;
        BlockState state;
        Material material;
        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
        BlockPos current = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
        while (current.m_123342_() > level.m_141937_() && (material = (state = level.m_8055_(below = current.m_7495_())).m_60767_()) != Material.f_76314_ && material != Material.f_76317_ && material != Material.f_76315_ && material != Material.f_76278_ && !material.m_76332_()) {
            current = below;
        }
        return current;
    }

    public boolean generate(ServerLevel level, RandomSource random, BlockPos position) {
        BlockPos placePos;
        BlockPos levelPos = this.getLevelPosition();
        BlockPos blockPos = placePos = levelPos == null ? this.placeOnGround(level, position, this.getOffsetY()) : this.getGround(level, position).m_121996_((Vec3i)this.transformPos(levelPos, this.mirror, this.rotation));
        if (placePos != null) {
            this.loadChunks(level, placePos);
            this.generateStructure(level, random, placePos);
            this.generateFiller((Level)level, placePos);
            return true;
        }
        return false;
    }

    private void loadChunks(ServerLevel level, BlockPos pos) {
        BlockPos min = this.transformPos(new BlockPos(0, 0, 0), this.mirror, this.rotation).m_121955_((Vec3i)pos);
        BlockPos max = this.transformPos(new BlockPos(this.sizeX - 1, 0, this.sizeZ - 1), this.mirror, this.rotation).m_121955_((Vec3i)pos);
        int minChunkX = Math.min(min.m_123341_(), max.m_123341_()) >> 4;
        int maxChunkX = Math.max(min.m_123341_(), max.m_123341_()) >> 4;
        int minChunkZ = Math.min(min.m_123343_(), max.m_123343_()) >> 4;
        int maxChunkZ = Math.max(min.m_123343_(), max.m_123343_()) >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                level.m_6325_(cx, cz);
            }
        }
    }

    protected void generateFiller(Level level, BlockPos pos) {
        BlockPos min = this.transformPos(new BlockPos(0, 0, 0), this.mirror, this.rotation).m_121955_((Vec3i)pos);
        BlockPos max = this.transformPos(new BlockPos(this.sizeX - 1, 0, this.sizeZ - 1), this.mirror, this.rotation).m_121955_((Vec3i)pos);
        for (int x = Math.min(min.m_123341_(), max.m_123341_()); x <= Math.max(min.m_123341_(), max.m_123341_()); ++x) {
            for (int z = Math.min(min.m_123343_(), max.m_123343_()); z <= Math.max(min.m_123343_(), max.m_123343_()); ++z) {
                BlockPos blockPos = new BlockPos(x, pos.m_123342_(), z);
                if (level.m_8055_(blockPos).m_60795_()) continue;
                BlockPos setPos = blockPos.m_7495_();
                do {
                    level.m_7731_(setPos, this.getFillerState(), 2);
                } while (level.m_8055_(setPos = setPos.m_7495_()).m_60767_().m_76336_());
            }
        }
    }

    protected boolean canSpawnOnHills() {
        return false;
    }

    protected BlockPos transformPos(BlockPos pos, Mirror mirror, Rotation rotation) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        boolean mirrored = true;
        switch (mirror) {
            case FRONT_BACK: {
                x = -x;
                break;
            }
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            default: {
                mirrored = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return mirrored ? new BlockPos(x, y, z) : pos;
    }

    protected abstract void generateStructure(ServerLevel var1, RandomSource var2, BlockPos var3);

    public int getOffsetY() {
        return -1;
    }

    public BlockPos getLevelPosition() {
        return null;
    }

    public BlockState getFillerState() {
        return Blocks.f_50493_.m_49966_();
    }
}

