/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.animal.CrabEntity;
import net.vit.jurassicreborn.common.entities.animal.GoatEntity;
import net.vit.jurassicreborn.common.entities.animal.SharkEntity;
import net.vit.jurassicreborn.common.util.EntityColorTint;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin {
    ArrayList<Optional<?>> renderParams = new ArrayList();

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    public void renderParamAccessor(LivingEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci) {
        if (this.renderParams.isEmpty()) {
            this.renderParams.add(Optional.of(pEntity));
            this.renderParams.add(Optional.of(Float.valueOf(pEntityYaw)));
            this.renderParams.add(Optional.of(Float.valueOf(pPartialTicks)));
            this.renderParams.add(Optional.of(pMatrixStack));
            this.renderParams.add(Optional.of(pBuffer));
            this.renderParams.add(Optional.of(pPackedLight));
        } else {
            this.renderParams.set(0, Optional.of(pEntity));
            this.renderParams.set(1, Optional.of(Float.valueOf(pEntityYaw)));
            this.renderParams.set(2, Optional.of(Float.valueOf(pPartialTicks)));
            this.renderParams.set(3, Optional.of(pMatrixStack));
            this.renderParams.set(4, Optional.of(pBuffer));
            this.renderParams.set(5, Optional.of(pPackedLight));
        }
    }

    @Redirect(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V", ordinal=0))
    public void renderMixin(EntityModel<? extends Entity> instance, PoseStack pose, VertexConsumer consumer, int light, int overlay, float r, float g, float b, float a) {
        if (!this.renderParams.isEmpty() && this.renderParams.get(0).isPresent() && EntityColorTint.isEntityInList((Entity)this.renderParams.get(0).get())) {
            Color tint = EntityColorTint.getColor();
            instance.m_7695_(pose, consumer, light, overlay, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
            EntityColorTint.clearColor();
        }
        instance.m_7695_(pose, consumer, light, overlay, r, g, b, a);
    }

    @Inject(method={"shouldShowName"}, at={@At(value="HEAD")}, cancellable=true)
    private void jurassicreborn$hideDinoName(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        CrabEntity crabEntity;
        GoatEntity goatEntity;
        SharkEntity sharkEntity;
        DinosaurEntity dinosaur;
        if (entity instanceof DinosaurEntity && !(dinosaur = (DinosaurEntity)entity).m_8077_()) {
            cir.setReturnValue((Object)false);
        }
        if (entity instanceof SharkEntity && !(sharkEntity = (SharkEntity)entity).m_8077_()) {
            cir.setReturnValue((Object)false);
        }
        if (entity instanceof GoatEntity && !(goatEntity = (GoatEntity)entity).m_8077_()) {
            cir.setReturnValue((Object)false);
        }
        if (entity instanceof CrabEntity && !(crabEntity = (CrabEntity)entity).m_8077_()) {
            cir.setReturnValue((Object)false);
        }
    }
}

