/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mod.reborn.server.item.JournalItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class JournalGui
extends GuiScreen {
    private static final int SIZE_X = 256;
    private static final int SIZE_Y = 192;
    private static final float FONT_SCALE = 1.0f;
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("rebornmod", "textures/journal/background.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("rebornmod", "textures/journal/widgets.png");
    private final JournalItem.JournalType type;
    private final JournalItem.Content content;
    private String[][] pages;
    private int pageCount;
    private PageButton nextPage;
    private PageButton previousPage;
    private int page;

    public JournalGui(JournalItem.JournalType type) {
        this.type = type;
        this.content = type.getContent();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 192) / 2;
        this.nextPage = new PageButton(0, x + 235, y + 180, true);
        this.field_146292_n.add(this.nextPage);
        this.previousPage = new PageButton(1, x - 3, y + 180, false);
        this.field_146292_n.add(this.previousPage);
        ArrayList<String> lines = new ArrayList<String>();
        for (String[] entry : this.content.getEntries()) {
            for (String line : entry) {
                ArrayList<JournalFormatting> format = new ArrayList<JournalFormatting>();
                for (JournalFormatting formatting : JournalFormatting.values()) {
                    line = formatting.apply(line, format);
                }
                float scale = 1.0f;
                for (JournalFormatting formatting : format) {
                    scale *= formatting.getScaleModifier();
                }
                StringBuilder currentLine = new StringBuilder();
                for (String word : line.split("\\s")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if ((float)this.field_146289_q.func_78256_a(stringBuilder.append(currentLine.toString()).append(word).toString()) * scale > 94.0f) {
                        lines.add(JournalFormatting.format(currentLine.toString(), format));
                        currentLine = new StringBuilder();
                    }
                    currentLine.append(word).append(" ");
                }
                lines.add(JournalFormatting.format(currentLine.toString(), format));
            }
            lines.add("\n");
        }
        ArrayList<String[]> pages = new ArrayList<String[]>();
        ArrayList<String> currentPage = new ArrayList<String>();
        int lineOffsetY = 0;
        int lineHeight = (int)((float)this.field_146289_q.field_78288_b * 1.0f + 2.0f);
        for (String line : lines) {
            boolean nextPage = line.endsWith("\n");
            if (!nextPage) {
                currentPage.add(line);
            }
            if ((lineOffsetY += lineHeight) <= 140 && !nextPage) continue;
            pages.add(currentPage.toArray(new String[currentPage.size()]));
            currentPage.clear();
            lineOffsetY = 0;
        }
        this.pages = (String[][])pages.toArray((T[])new String[pages.size()][]);
        this.pageCount = MathHelper.func_76143_f((double)((double)this.pages.length / 2.0));
        this.updateButtons();
    }

    private void updateButtons() {
        this.nextPage.field_146125_m = this.page < this.pageCount - 1;
        this.previousPage.field_146125_m = this.page > 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 192) / 2;
        this.field_73735_i = -1000.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(x, y, 0, 0, 256, 256);
        this.drawPage(this.page * 2, x + 18, y + 16);
        this.drawPage(this.page * 2 + 1, x + 145, y + 16);
    }

    private void drawPage(int pageIndex, int originX, int originY) {
        if (pageIndex >= 0 && pageIndex < this.pages.length) {
            String[] page;
            int lineOffsetY = 0;
            int lineHeight = (int)((float)this.field_146289_q.field_78288_b * 1.0f + 2.0f);
            for (String line : page = this.pages[pageIndex]) {
                this.drawScaledString(line, originX, originY + lineOffsetY, 1.0f, 0);
                lineOffsetY += lineHeight;
            }
        }
    }

    private void drawScaledString(String text, float x, float y, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.field_146289_q.func_175065_a(text, x / scale, y / scale, color, false);
        GlStateManager.func_179121_F();
    }

    private void drawCenteredScaledString(String text, float x, float y, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.field_146289_q.func_175065_a(text, (x - (float)(this.field_146289_q.func_78256_a(text) / 2)) / scale, y / scale, color, false);
        GlStateManager.func_179121_F();
    }

    private void drawFullTexturedRect(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                if (this.page < this.pageCount) {
                    ++this.page;
                }
            } else if (button.field_146127_k == 1 && this.page > 0) {
                --this.page;
            }
            this.updateButtons();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    static class PageButton
    extends GuiButton {
        private final boolean isForward;

        PageButton(int id, int x, int y, boolean isForward) {
            super(id, x, y, 23, 13, "");
            this.isForward = isForward;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean selected = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(WIDGETS_TEXTURE);
                int u = 0;
                int v = 194;
                if (selected) {
                    u += 23;
                }
                if (!this.isForward) {
                    v += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, u, v, 23, 13);
            }
        }
    }

    private static enum JournalFormatting {
        BOLD("*", TextFormatting.BOLD, 1.15f),
        ITALICS("_", TextFormatting.ITALIC);

        private final String identifier;
        private final TextFormatting textFormat;
        private final float scaleModifier;

        private JournalFormatting(String identifier, TextFormatting textFormat) {
            this(identifier, textFormat, 1.0f);
        }

        private JournalFormatting(String identifier, TextFormatting textFormat, float scaleModifier) {
            this.identifier = identifier;
            this.textFormat = textFormat;
            this.scaleModifier = scaleModifier;
        }

        public static String format(String text, List<JournalFormatting> format) {
            for (JournalFormatting formatting : format) {
                text = formatting.format(text);
            }
            text = text.replaceAll("\\\\", "");
            return text;
        }

        public String format(String text) {
            return this.textFormat.toString() + text;
        }

        public String apply(String text, List<JournalFormatting> format) {
            if (text.startsWith(this.identifier)) {
                format.add(this);
                return text.replaceFirst(Pattern.quote(this.identifier), "");
            }
            return text;
        }

        public float getScaleModifier() {
            return this.scaleModifier;
        }
    }
}

