/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.gui;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.DinosaurStatus;
import mod.reborn.server.util.LangUtils;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PaleoPadViewDinosaurGui
extends GuiScreen {
    private static final int SIZE_X = 256;
    private static final int SIZE_Y = 192;
    private static final int TOTAL_PAGES = 2;
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/paleo_pad.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("rebornmod", "textures/field_guide/widgets.png");
    private static final Map<DinosaurStatus, ResourceLocation> STATUS_TEXTURES = new HashMap<DinosaurStatus, ResourceLocation>();
    private DinosaurEntity entity;
    private DinosaurEntity.FieldGuideInfo guideInfo;
    private PageButton nextPage;
    private PageButton previousPage;
    private int page;

    public PaleoPadViewDinosaurGui(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo guideInfo) {
        this.entity = entity;
        this.guideInfo = guideInfo;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 192) / 2;
        this.nextPage = new PageButton(0, x + 213, y + 160, true);
        this.field_146292_n.add(this.nextPage);
        this.previousPage = new PageButton(1, x + 15, y + 160, false);
        this.field_146292_n.add(this.previousPage);
        this.updateButtons();
    }

    private void updateButtons() {
        this.nextPage.field_146125_m = this.page < 1;
        this.previousPage.field_146125_m = this.page > 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
        int scaleFactor = scaledResolution.func_78325_e();
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 192) / 2;
        this.field_73735_i = -1000.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(x, y, 0, 0, 256, 256);
        Dinosaur dinosaur = this.entity.getDinosaur();
        this.drawScaledString(LangUtils.getDinoName(dinosaur).toUpperCase(Locale.ENGLISH), x + 15, y + 14, 1.3f, 0);
        if (this.page == 0) {
            int size;
            this.drawScaledString(this.entity.getGrowthStage().getLocalization().toUpperCase(Locale.ENGLISH) + " // " + LangUtils.getGenderMode(this.entity.isMale() ? 1 : 2).toUpperCase(Locale.ENGLISH), x + 16, y + 24, 1.0f, 0);
            int statisticsX = x + 128 + 15;
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            this.drawScaledString(LangUtils.translate(LangUtils.GUI.get("dinosaur_statistics"), new Object[0]), statisticsX, y + 14, 1.0f, 0);
            int statisticTextX = x + 192;
            this.drawCenteredScaledString(LangUtils.translate(LangUtils.GUI.get("health"), new Object[0]), statisticTextX, y + 35, 1.0f, 0);
            this.drawCenteredScaledString(LangUtils.translate(LangUtils.GUI.get("hunger"), new Object[0]), statisticTextX, y + 65, 1.0f, 0);
            this.drawCenteredScaledString(LangUtils.translate(LangUtils.GUI.get("thirst"), new Object[0]), statisticTextX, y + 95, 1.0f, 0);
            this.drawCenteredScaledString(LangUtils.translate(LangUtils.GUI.get("age"), new Object[0]), statisticTextX, y + 125, 1.0f, 0);
            this.field_146297_k.func_110434_K().func_110577_a(WIDGETS_TEXTURE);
            this.drawBar(statisticsX, y + 45, this.entity.isCarcass() ? 0.0f : this.entity.func_110143_aJ(), this.entity.func_110138_aP(), 0xFF0000);
            this.drawBar(statisticsX, y + 75, this.guideInfo.hunger, this.entity.getMetabolism().getMaxEnergy(), 9729114);
            this.drawBar(statisticsX, y + 105, this.guideInfo.thirst, this.entity.getMetabolism().getMaxWater(), 255);
            this.drawBar(statisticsX, y + 135, this.entity.getDinosaurAge(), dinosaur.getMaximumAge(), 65280);
            this.drawCenteredScaledString(LangUtils.translate(LangUtils.GUI.get("days_old"), new Object[0]).replace("{value}", String.valueOf(this.entity.getDaysExisted())), statisticTextX, y + 155, 1.0f, 0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((x + 15) * scaleFactor), (int)((this.field_146295_m - y - 140) * scaleFactor), (int)(100 * scaleFactor), (int)(100 * scaleFactor));
            this.drawEntity(x + 65, y + 110, (int)(70.0 / ((double)dinosaur.getAdultSizeY() + (2.0 * dinosaur.getScaleAdult() + dinosaur.getPaleoPadScale()))), (EntityLivingBase)this.entity);
            GL11.glDisable((int)3089);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int statusX = 0;
            int statusY = 0;
            List<DinosaurStatus> activeStatuses = DinosaurStatus.getActiveStatuses(this.entity, this.guideInfo);
            for (DinosaurStatus status : activeStatuses) {
                this.field_146297_k.func_110434_K().func_110577_a(STATUS_TEXTURES.get((Object)status));
                size = 16;
                this.drawFullTexturedRect(statusX + x + 31, statusY + y + 152, size, size);
                if ((statusX += 18) <= 68) continue;
                statusX = 0;
                statusY -= 18;
            }
            statusX = 0;
            statusY = 0;
            for (DinosaurStatus status : activeStatuses) {
                size = 16;
                int renderX = statusX + x + 31;
                int renderY = statusY + y + 152;
                if (mouseX >= renderX && mouseY >= renderY && mouseX <= renderX + size && mouseY <= renderY + size) {
                    this.func_146279_a(LangUtils.translate(LangUtils.STATUS.get(status.name().toLowerCase(Locale.ENGLISH)), new Object[0]), mouseX, mouseY);
                }
                if ((statusX += 18) <= 68) continue;
                statusX = 0;
                statusY -= 18;
            }
            GlStateManager.func_179140_f();
        } else {
            String text = LangUtils.getDinoInfo(dinosaur);
            ArrayList<String> lines = new ArrayList<String>();
            int wrapX = 0;
            StringBuilder wrapLine = new StringBuilder();
            for (String word : text.split(" ")) {
                if (wrapX + this.field_146289_q.func_78256_a(word) > 220) {
                    lines.add(wrapLine.toString());
                    wrapLine = new StringBuilder();
                }
                wrapLine.append(word).append(" ");
                wrapX = this.field_146289_q.func_78256_a(wrapLine.toString().trim());
            }
            lines.add(wrapLine.toString());
            int lineX = 0;
            int lineY = y + 35;
            for (String line : lines) {
                this.drawCenteredScaledString(line.trim(), x + 128 + lineX, lineY, 1.0f, 0);
                if ((lineY += 10) <= y + 192 - 35) continue;
                lineX += 128;
                lineY = y + 10;
            }
        }
    }

    private void drawBar(int x, int y, float value, float max, int color) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(x, y, 0, 179, 98, 8);
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        this.func_73729_b(x, y, 0, 187, Math.max(0, Math.min(98, (int)(value / max * 98.0f))), 8);
    }

    private void drawScaledString(String text, float x, float y, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.field_146289_q.func_175065_a(text, x / scale, y / scale, color, false);
        GlStateManager.func_179121_F();
    }

    private void drawCenteredScaledString(String text, float x, float y, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.field_146289_q.func_175065_a(text, (x - (float)(this.field_146289_q.func_78256_a(text) / 2)) / scale, y / scale, color, false);
        GlStateManager.func_179121_F();
    }

    private void drawFullTexturedRect(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                if (this.page < 2) {
                    ++this.page;
                }
            } else if (button.field_146127_k == 1 && this.page > 0) {
                --this.page;
            }
            this.updateButtons();
        }
    }

    public void drawEntity(int posX, int posY, float scale, EntityLivingBase entity) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager renderManager = this.field_146297_k.func_175598_ae();
        renderManager.func_178631_a(180.0f);
        renderManager.func_178633_a(false);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float partialTicks = LLibrary.PROXY.getPartialTicks();
        GlStateManager.func_179114_b((float)ClientUtils.interpolate((float)entity.field_70760_ar, (float)entity.field_70761_aq, (float)partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        renderManager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
        renderManager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        for (DinosaurStatus status : DinosaurStatus.values()) {
            STATUS_TEXTURES.put(status, new ResourceLocation("rebornmod", "textures/field_guide/status/" + status.name().toLowerCase(Locale.ENGLISH) + ".png"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class PageButton
    extends GuiButton {
        private final boolean isForward;

        public PageButton(int id, int x, int y, boolean isForward) {
            super(id, x, y, 23, 13, "");
            this.isForward = isForward;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean selected = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(WIDGETS_TEXTURE);
                int u = 0;
                int v = 194;
                if (selected) {
                    u += 23;
                }
                if (!this.isForward) {
                    v += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, u, v, 23, 13);
            }
        }
    }
}

