/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.gui.app;

import java.util.HashMap;
import java.util.Map;
import mod.reborn.client.gui.PaleoPadGui;
import mod.reborn.client.gui.app.GuiApp;
import mod.reborn.server.paleopad.App;
import mod.reborn.server.paleopad.FlappyDinoApp;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import scala.util.Random;

public class FlappyDinoGuiApp
extends GuiApp {
    private static final ResourceLocation texture = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/flappy_dino.png");
    private static final ResourceLocation logo = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/background/flappy_dino.png");
    private static final ResourceLocation pteranodon = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/background/flappy_dino_pteranodon.png");
    private static final ResourceLocation character = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/background/pteranodon_char.png");
    private static final ResourceLocation pillar_bottom = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/background/pillar_bottom.png");
    private static final ResourceLocation pillar_top = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/background/pillar_top.png");
    private static final ResourceLocation background = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/background/flappy_dino_background.png");
    private boolean mainScreen;
    private int x;
    private int y;
    private int motionY;
    private Map<Integer, Integer> pillars = new HashMap<Integer, Integer>();

    public FlappyDinoGuiApp(App app) {
        super(app);
    }

    @Override
    public void render(int mouseX, int mouseY, PaleoPadGui gui) {
        super.renderButtons(mouseX, mouseY, gui);
        FlappyDinoApp app = (FlappyDinoApp)this.getApp();
        mc.func_110434_K().func_110577_a(background);
        gui.drawScaledTexturedModalRect(0, 0, 0, 0, 229, 150, 229, 150, 1.0f);
        if (this.mainScreen) {
            mc.func_110434_K().func_110577_a(logo);
            gui.drawScaledTexturedModalRect(5, 5, 0, 0, 128, 64, 128, 64, 1.0f);
            mc.func_110434_K().func_110577_a(pteranodon);
            gui.drawScaledTexturedModalRect(145, 15, 0, 0, 128, 64, 128, 64, 1.0f);
            gui.drawBoxOutline(90, 100, 50, 20, 1, 1.0f, 0x545454);
            gui.drawScaledRect(91, 101, 49, 19, 1.0f, 0x747474);
            gui.drawScaledText("Play", 105, 107, 1.0f, 0xFFFFFF);
        } else {
            int drawX;
            mc.func_110434_K().func_110577_a(character);
            gui.drawScaledTexturedModalRect(5, 150 - this.y, 0, 0, 32, 32, 32, 32, 1.0f);
            mc.func_110434_K().func_110577_a(pillar_bottom);
            for (Map.Entry<Integer, Integer> entry : this.pillars.entrySet()) {
                drawX = entry.getKey() - this.x;
                if (drawX <= 0 || drawX >= 200) continue;
                for (int height = 0; height < entry.getValue(); ++height) {
                    gui.drawScaledTexturedModalRect(drawX, 130 - height * 20, 0, 12, 32, 20, 32, 32, 1.0f);
                }
                gui.drawScaledTexturedModalRect(drawX, 139 - entry.getValue() * 20, 0, 0, 32, 12, 32, 32, 1.0f);
            }
            mc.func_110434_K().func_110577_a(pillar_top);
            for (Map.Entry<Integer, Integer> entry : this.pillars.entrySet()) {
                drawX = entry.getKey() - this.x;
                if (drawX <= 0 || drawX >= 200) continue;
                Integer totalHeight = 4 - entry.getValue();
                for (int height = 0; height < totalHeight; ++height) {
                    gui.drawScaledTexturedModalRect(drawX, height * 20, 0, 0, 32, 20, 32, 32, 1.0f);
                }
                gui.drawScaledTexturedModalRect(drawX, totalHeight * 20, 0, 20, 32, 12, 32, 32, 1.0f);
                if (!mc.func_175598_ae().func_178634_b()) continue;
                int topHeight = (4 - entry.getValue()) * 20 + 11;
                int bottomHeight = 150 - entry.getValue() * 20 - 11;
                int actualY = 150 - this.y;
                gui.drawScaledRect(drawX + 1, topHeight, 30, 1, 1.0f, 0xFFFFFF);
                gui.drawScaledRect(drawX + 1, bottomHeight, 30, 1, 1.0f, 0xFFFF00);
                gui.drawScaledRect(6, actualY + 5, 30, 1, 1.0f, 0xFF0000);
                gui.drawScaledRect(6, actualY + 23, 30, 1, 1.0f, 0xFF00FF);
            }
        }
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, PaleoPadGui gui) {
        ScaledResolution dimensions = new ScaledResolution(mc);
        mouseX -= dimensions.func_78326_a() / 2 - 115;
        mouseY -= 65;
        if (this.mainScreen) {
            if (mouseX > 90 && mouseX < 140 && mouseY > 100 && mouseY < 120) {
                this.mainScreen = false;
            }
        } else {
            this.motionY = 6;
        }
    }

    @Override
    public void init() {
        this.x = 0;
        this.y = 150;
        this.motionY = 0;
        this.pillars.clear();
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            this.pillars.put(i * 70 + 70, rand.nextInt(5));
        }
        this.mainScreen = true;
    }

    @Override
    public void update() {
        if (!this.mainScreen && FlappyDinoGuiApp.mc.field_71439_g.field_70173_aa % 2 == 0) {
            ++this.x;
            if (this.y > 140) {
                this.y = 140;
            }
            if (this.motionY < -5) {
                this.motionY = -5;
            }
            this.y += this.motionY;
            --this.motionY;
            boolean died = false;
            for (Map.Entry<Integer, Integer> entry : this.pillars.entrySet()) {
                boolean collideY;
                int renderX = entry.getKey() - this.x;
                int height = entry.getValue();
                int bottomHeight = 150 - entry.getValue() * 20 - 11;
                int topHeight = (4 - height) * 20 + 11;
                int actualY = 150 - this.y;
                if (renderX <= 0 || renderX >= 200) continue;
                boolean collideX = renderX < 30;
                boolean bl = collideY = actualY + 5 < topHeight || actualY + 23 > bottomHeight;
                if (!collideX || !collideY) continue;
                died = true;
                break;
            }
            if (this.y < 20) {
                died = true;
            }
            if (died) {
                this.init();
            }
        }
    }

    @Override
    public ResourceLocation getTexture(PaleoPadGui gui) {
        return texture;
    }
}

