/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.gui.app;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.reborn.client.gui.PaleoPadGui;
import mod.reborn.client.gui.app.GuiApp;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.paleopad.App;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MinimapGuiApp
extends GuiApp {
    private static final ResourceLocation texture = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/minimap.png");
    private static final ResourceLocation widgets = new ResourceLocation("rebornmod", "textures/gui/widget.png");
    private static final ResourceLocation entity = new ResourceLocation("rebornmod", "textures/gui/paleo_pad/apps/background/entity.png");
    private final Map<BlockPos, Integer> heights = new HashMap<BlockPos, Integer>();

    public MinimapGuiApp(App app) {
        super(app);
    }

    @Override
    public void render(int mouseX, int mouseY, PaleoPadGui gui) {
        super.renderButtons(mouseX, mouseY, gui);
        EntityPlayerSP player = MinimapGuiApp.mc.field_71439_g;
        WorldClient world = MinimapGuiApp.mc.field_71441_e;
        ScaledResolution dimensions = new ScaledResolution(mc);
        int left = dimensions.func_78326_a() / 2 - 115;
        int top = 65;
        gui.drawScaledText("Loc: " + (int)player.field_70165_t + " " + (int)player.field_70163_u + " " + (int)player.field_70161_v, 2, 3, 1.0f, 0xFFFFFF);
        int playerX = (int)player.field_70165_t;
        int playerZ = (int)player.field_70161_v;
        int playerChunkX = playerX >> 4;
        int playerChunkZ = playerZ >> 4;
        int mapX = 0;
        int renderY = 0;
        int renderChunkX = 0;
        int renderChunkY = 0;
        gui.drawBoxOutline(89, 14, 129, 129, 1, 1.0f, 0x606060);
        for (int chunkX = playerChunkX - 4; chunkX < playerChunkX + 4; ++chunkX) {
            for (int chunkZ = playerChunkZ - 4; chunkZ < playerChunkZ + 4; ++chunkZ) {
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                if (!chunk.func_76621_g()) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int blockX = x + chunkX * 16;
                            int blockZ = z + chunkZ * 16;
                            BlockPos pos = this.getHeight((World)world, blockX, blockZ);
                            int blockY = pos.func_177956_o();
                            IBlockState blockState = world.func_180495_p(pos);
                            MapColor color = blockState.func_185904_a().func_151565_r();
                            int rgb = color.field_76291_p;
                            int r = rgb >> 16 & 0xFF;
                            int g = rgb >> 8 & 0xFF;
                            int b = rgb & 0xFF;
                            int lightnessOffset = 0;
                            lightnessOffset -= this.getHeight((World)world, blockX - 1, blockZ).func_177956_o() > blockY ? 10 : 0;
                            lightnessOffset -= this.getHeight((World)world, blockX, blockZ - 1).func_177956_o() > blockY ? 10 : 0;
                            lightnessOffset -= this.getHeight((World)world, blockX + 1, blockZ).func_177956_o() > blockY ? 10 : 0;
                            r = Math.min(Math.max(r + (lightnessOffset -= this.getHeight((World)world, blockX, blockZ + 1).func_177956_o() > blockY ? 10 : 0), 0), 255);
                            g = Math.min(Math.max(g + lightnessOffset, 0), 255);
                            b = Math.min(Math.max(b + lightnessOffset, 0), 255);
                            rgb = r << 16 | g << 8 | b;
                            gui.drawScaledRect(mapX + renderChunkX * 16 + 90, renderY + renderChunkY * 16 + 15, 1, 1, 1.0f, rgb);
                            ++renderY;
                        }
                        renderY = 0;
                        ++mapX;
                    }
                }
                mapX = 0;
                renderY = 0;
                ++renderChunkY;
            }
            renderChunkY = 0;
            ++renderChunkX;
        }
        renderChunkX = 0;
        renderChunkY = 0;
        int trackedEntities = 0;
        ArrayList<String> dinos = new ArrayList<String>();
        for (int chunkX = playerChunkX - 4; chunkX < playerChunkX + 4; ++chunkX) {
            for (int chunkZ = playerChunkZ - 4; chunkZ < playerChunkZ + 4; ++chunkZ) {
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                if (chunk.func_76621_g()) continue;
                for (Entity e : this.getEntitiesInChunk(chunk, null, (Predicate<Entity>)EntitySelectors.field_180132_d)) {
                    if (!(e instanceof DinosaurEntity)) continue;
                    DinosaurEntity dino = (DinosaurEntity)e;
                    if (dino.trackersUUID.isEmpty() || !dino.trackersUUID.contains(MinimapGuiApp.mc.field_71439_g.func_146103_bH().getId().toString())) continue;
                    ++trackedEntities;
                    String pos = "(" + (int)e.field_70165_t + " " + (int)e.field_70163_u + " " + (int)e.field_70161_v + ")";
                    dinos.add("-" + dino.func_70005_c_() + " " + pos);
                    int x = (int)e.field_70165_t - (playerChunkX - 4) * 16 + 90 - 1 + left;
                    int y = (int)e.field_70161_v - (playerChunkZ - 4) * 16 + 15 - 1 + top;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(widgets);
                    gui.func_73729_b(x, y, 0, 0, 3, 3);
                }
            }
            for (int i = 0; i < dinos.size(); ++i) {
                String s = (String)dinos.get(i);
                gui.drawScaledText(s, 2, 23 + 10 * i, 0.6f, 0xFFFFFF);
            }
        }
        gui.drawScaledText("Tracked Dinos : " + trackedEntities, 2, 13, 0.67f, 0xFFFFFF);
        mc.func_110434_K().func_110577_a(widgets);
        int x = (int)player.field_70165_t - (playerChunkX - 4) * 16 + 90 - 1 + left;
        int y = (int)player.field_70161_v - (playerChunkZ - 4) * 16 + 15 - 1 + top;
        gui.func_73729_b(x, y, 3, 0, 3, 3);
        renderChunkY = 0;
        ++renderChunkX;
    }

    private BlockPos getHeight(World world, int x, int z) {
        BlockPos posKey = new BlockPos(x, 0, z);
        if (this.heights.containsKey(posKey)) {
            return new BlockPos(x, this.heights.get(posKey).intValue(), z);
        }
        int y = world.func_175645_m(posKey).func_177956_o();
        BlockPos pos = new BlockPos(x, y, z);
        while (world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid) {
            pos = new BlockPos(x, --y, z);
        }
        BlockPos up = pos.func_177982_a(0, 1, 0);
        if (!world.func_175623_d(up)) {
            pos = up;
        }
        this.heights.put(posKey, pos.func_177956_o());
        return pos;
    }

    public List<Entity> getEntitiesInChunk(Chunk chunk, Entity exclude, Predicate<Entity> predicate) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        int i = MathHelper.func_76128_c((double)((0.0 - World.MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((256.0 + World.MAX_ENTITY_RADIUS) / 16.0));
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(entityLists.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(entityLists.length - 1));
        for (int k = i; k <= j; ++k) {
            for (Entity entity : entityLists[k]) {
                if (entity == exclude || predicate != null && !predicate.apply((Object)entity)) continue;
                entities.add(entity);
                Entity[] parts = entity.func_70021_al();
                if (parts == null) continue;
                for (Entity part : parts) {
                    entity = part;
                    if (entity == exclude || predicate != null && !predicate.apply((Object)entity)) continue;
                    entities.add(entity);
                }
            }
        }
        return entities;
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, PaleoPadGui gui) {
        ScaledResolution dimensions = new ScaledResolution(mc);
        mouseX -= dimensions.func_78326_a() / 2 - 115;
    }

    @Override
    public void init() {
        this.heights.clear();
    }

    @Override
    public ResourceLocation getTexture(PaleoPadGui gui) {
        return texture;
    }
}

