/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.model;

import mod.reborn.client.model.FixedModelRenderer;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeGroupContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FixedTabulaModel
extends TabulaModel {
    public FixedTabulaModel(TabulaModelContainer container, ITabulaModelAnimator<?> tabulaAnimator) {
        super(container, tabulaAnimator);
        this.cubes.clear();
        this.identifierMap.clear();
        this.rootBoxes.clear();
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
        this.updateDefaultPose();
    }

    public FixedTabulaModel(TabulaModelContainer container) {
        this(container, null);
    }

    private void parseCubeGroup(TabulaCubeGroupContainer container) {
        for (TabulaCubeContainer cube : container.getCubes()) {
            this.parseCube(cube, null);
        }
        container.getCubeGroups().forEach(this::parseCubeGroup);
    }

    private void parseCube(TabulaCubeContainer cube, FixedModelRenderer parent) {
        FixedModelRenderer box = this.createBox(cube);
        this.cubes.put(cube.getName(), box);
        this.identifierMap.put(cube.getIdentifier(), box);
        if (parent != null) {
            parent.func_78792_a((ModelRenderer)box);
        } else {
            this.rootBoxes.add(box);
        }
        for (TabulaCubeContainer child : cube.getChildren()) {
            this.parseCube(child, box);
        }
    }

    private FixedModelRenderer createBox(TabulaCubeContainer cube) {
        int[] textureOffset = cube.getTextureOffset();
        double[] position = cube.getPosition();
        double[] rotation = cube.getRotation();
        double[] offset = cube.getOffset();
        int[] dimensions = cube.getDimensions();
        FixedModelRenderer box = new FixedModelRenderer((AdvancedModelBase)this, cube.getName());
        box.setTextureOffset(textureOffset[0], textureOffset[1]);
        box.func_78793_a((float)position[0], (float)position[1], (float)position[2]);
        box.func_78790_a((float)offset[0], (float)offset[1], (float)offset[2], dimensions[0], dimensions[1], dimensions[2], 0.0f);
        box.field_78795_f = (float)Math.toRadians(rotation[0]);
        box.field_78796_g = (float)Math.toRadians(rotation[1]);
        box.field_78808_h = (float)Math.toRadians(rotation[2]);
        return box;
    }
}

