/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.model.animation;

import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import mod.reborn.client.model.AnimatableModel;
import mod.reborn.client.model.animation.JabelarAnimationHandler;
import mod.reborn.server.api.Animatable;
import mod.reborn.server.entity.GrowthStage;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class EntityAnimator<ENTITY extends EntityLivingBase>
implements ITabulaModelAnimator<ENTITY> {
    protected EnumMap<GrowthStage, Map<ENTITY, JabelarAnimationHandler<ENTITY>>> animationHandlers = new EnumMap(GrowthStage.class);

    private JabelarAnimationHandler<ENTITY> getAnimationHelper(ENTITY entity, AnimatableModel model, boolean useInertialTweens) {
        JabelarAnimationHandler<ENTITY> render;
        GrowthStage growth = ((Animatable)entity).getGrowthStage();
        Map<ENTITY, JabelarAnimationHandler<ENTITY>> growthToRender = this.animationHandlers.get((Object)growth);
        if (growthToRender == null) {
            growthToRender = new WeakHashMap<ENTITY, JabelarAnimationHandler<ENTITY>>();
            this.animationHandlers.put(growth, growthToRender);
        }
        if ((render = growthToRender.get(entity)) == null) {
            render = ((Animatable)entity).getPoseHandler().createAnimationHandler(entity, model, growth, useInertialTweens);
            growthToRender.put(entity, render);
        }
        return render;
    }

    public final void setRotationAngles(TabulaModel model, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
        this.getAnimationHelper(entity, (AnimatableModel)model, ((Animatable)entity).shouldUseInertia()).performAnimations(entity, limbSwing, limbSwingAmount, ticks);
        int i = 0;
        AdvancedModelRenderer cube = model.getCube("neck" + i++);
        if (cube == null) {
            cube = model.getCube("throat" + i++);
        }
        float j = 1.0f - (float)i * 1.0E-5f;
        if (cube != null) {
            cube.scaleX *= j;
            cube.scaleY *= j;
            cube.scaleZ *= j;
        }
        this.performAnimations((AnimatableModel)model, entity, limbSwing, limbSwingAmount, ticks, rotationYaw, rotationPitch, scale);
    }

    protected void performAnimations(AnimatableModel parModel, ENTITY entity, float limbSwing, float limbSwingAmount, float ticks, float rotationYaw, float rotationPitch, float scale) {
    }
}

