/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.model.animation.dto;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import mod.reborn.client.model.animation.dto.GrowthRenderDef;
import mod.reborn.server.entity.GrowthStage;

public class AnimatableRenderDefDTO {
    public int version;
    public Map<GrowthStage, GrowthRenderDef> perStage;

    public static class AnimatableDeserializer
    implements JsonDeserializer<AnimatableRenderDefDTO> {
        public AnimatableRenderDefDTO deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject def = json.getAsJsonObject();
            AnimatableRenderDefDTO built = new AnimatableRenderDefDTO();
            built.version = def.get("version") == null ? 0 : def.get("version").getAsInt();
            built.perStage = new EnumMap<GrowthStage, GrowthRenderDef>(GrowthStage.class);
            for (GrowthStage g : GrowthStage.VALUES) {
                GrowthRenderDef renderDef;
                JsonElement perhaps = def.get(g.name());
                GrowthRenderDef growthRenderDef = renderDef = perhaps == null ? new GrowthRenderDef() : (GrowthRenderDef)context.deserialize(perhaps, GrowthRenderDef.class);
                if (renderDef.directory == null || renderDef.directory.isEmpty()) {
                    renderDef.directory = g.name().toLowerCase(Locale.ROOT);
                }
                built.perStage.put(g, renderDef);
            }
            return built;
        }
    }
}

