/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mod.reborn.RebornMod;
import mod.reborn.client.event.ClientEventHandler;
import mod.reborn.client.gui.BugCrateGui;
import mod.reborn.client.gui.CleaningStationGui;
import mod.reborn.client.gui.CultivateGui;
import mod.reborn.client.gui.CultivateProcessGui;
import mod.reborn.client.gui.DNACombinatorHybridizerGui;
import mod.reborn.client.gui.DNAExtractorGui;
import mod.reborn.client.gui.DNASequencerGui;
import mod.reborn.client.gui.DNASynthesizerGui;
import mod.reborn.client.gui.EmbryoCalcificationMachineGui;
import mod.reborn.client.gui.EmbryonicMachineGui;
import mod.reborn.client.gui.FeederGui;
import mod.reborn.client.gui.FieldGuideGui;
import mod.reborn.client.gui.FossilGrinderGui;
import mod.reborn.client.gui.IncubatorGui;
import mod.reborn.client.gui.JournalGui;
import mod.reborn.client.gui.OrderDinosaurGui;
import mod.reborn.client.gui.PaleoPadGui;
import mod.reborn.client.gui.PaleoPadViewDinosaurGui;
import mod.reborn.client.gui.SelectDinoGui;
import mod.reborn.client.gui.SkeletonAssemblyGui;
import mod.reborn.client.model.RebornTabulaModelHandler;
import mod.reborn.client.render.RenderingHandler;
import mod.reborn.client.sound.CarSound;
import mod.reborn.server.block.entity.BugCrateBlockEntity;
import mod.reborn.server.block.entity.CleaningStationBlockEntity;
import mod.reborn.server.block.entity.CultivatorBlockEntity;
import mod.reborn.server.block.entity.DNACombinatorHybridizerBlockEntity;
import mod.reborn.server.block.entity.DNAExtractorBlockEntity;
import mod.reborn.server.block.entity.DNASequencerBlockEntity;
import mod.reborn.server.block.entity.DNASynthesizerBlockEntity;
import mod.reborn.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import mod.reborn.server.block.entity.EmbryonicMachineBlockEntity;
import mod.reborn.server.block.entity.FeederBlockEntity;
import mod.reborn.server.block.entity.FossilGrinderBlockEntity;
import mod.reborn.server.block.entity.IncubatorBlockEntity;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.VenomEntity;
import mod.reborn.server.entity.particle.VenomParticle;
import mod.reborn.server.entity.vehicle.VehicleEntity;
import mod.reborn.server.event.KeyBindingHandler;
import mod.reborn.server.item.JournalItem;
import mod.reborn.server.proxy.ServerProxy;
import net.ilexiconn.llibrary.client.lang.LanguageHandler;
import net.ilexiconn.llibrary.server.util.WebUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends ServerProxy {
    public static final Minecraft MC = Minecraft.func_71410_x();
    private static KeyBindingHandler keyHandler = new KeyBindingHandler();
    public static final List<UUID> MEMBERS = new ArrayList<UUID>();
    public static final List<UUID> TESTERS = new ArrayList<UUID>();

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        super.onPreInit(event);
        KeyBindingHandler.init();
        try {
            LanguageHandler.INSTANCE.loadRemoteLocalization("rebornmod");
        }
        catch (Exception e) {
            RebornMod.getLogger().error("Failed to load remote localizations", (Throwable)e);
        }
        ClientEventHandler eventHandler = new ClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)RenderingHandler.INSTANCE);
        RenderingHandler.INSTANCE.preInit();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)RebornTabulaModelHandler.INSTANCE);
        RebornTabulaModelHandler.INSTANCE.addDomain("rebornmod");
    }

    public static void playHelicopterSound(VehicleEntity entity) {
        MC.func_147118_V().func_147682_a((ISound)new CarSound(entity));
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        super.onInit(event);
        RenderingHandler.INSTANCE.init();
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        super.onPostInit(event);
        RenderingHandler.INSTANCE.postInit();
        new Thread(() -> {
            List modmembers = WebUtils.readPastebinAsList((String)"7a2d1ce3");
            List bugtesters = WebUtils.readPastebinAsList((String)"9H4eiu0S");
            if (modmembers != null) {
                for (String members : modmembers) {
                    MEMBERS.add(UUID.fromString(members));
                }
            }
            if (bugtesters != null) {
                for (String testers : bugtesters) {
                    TESTERS.add(UUID.fromString(testers));
                }
            }
        }).start();
    }

    @Override
    public EntityPlayer getPlayer() {
        return ClientProxy.MC.field_71439_g;
    }

    @Override
    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? this.getPlayer() : super.getPlayerEntityFromContext(ctx);
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            if (tile instanceof CleaningStationBlockEntity && id == 0) {
                return new CleaningStationGui(player.field_71071_by, (IInventory)((CleaningStationBlockEntity)tile));
            }
            if (tile instanceof FossilGrinderBlockEntity && id == 1) {
                return new FossilGrinderGui(player.field_71071_by, (IInventory)((FossilGrinderBlockEntity)tile));
            }
            if (tile instanceof DNASequencerBlockEntity && id == 2) {
                return new DNASequencerGui(player.field_71071_by, (IInventory)((DNASequencerBlockEntity)tile));
            }
            if (tile instanceof EmbryonicMachineBlockEntity && id == 3) {
                return new EmbryonicMachineGui(player.field_71071_by, (IInventory)((EmbryonicMachineBlockEntity)tile));
            }
            if (tile instanceof EmbryoCalcificationMachineBlockEntity && id == 4) {
                return new EmbryoCalcificationMachineGui(player.field_71071_by, (IInventory)((EmbryoCalcificationMachineBlockEntity)tile));
            }
            if (tile instanceof DNASynthesizerBlockEntity && id == 5) {
                return new DNASynthesizerGui(player.field_71071_by, (IInventory)((DNASynthesizerBlockEntity)tile));
            }
            if (tile instanceof IncubatorBlockEntity && id == 6) {
                return new IncubatorGui(player.field_71071_by, (IncubatorBlockEntity)tile);
            }
            if (tile instanceof DNACombinatorHybridizerBlockEntity && id == 7) {
                return new DNACombinatorHybridizerGui(player.field_71071_by, (DNACombinatorHybridizerBlockEntity)tile);
            }
            if (tile instanceof DNAExtractorBlockEntity && id == 8) {
                return new DNAExtractorGui(player.field_71071_by, (IInventory)((DNAExtractorBlockEntity)tile));
            }
            if (tile instanceof CultivatorBlockEntity && id == 9) {
                CultivatorBlockEntity cultivator = (CultivatorBlockEntity)tile;
                if (cultivator.isProcessing(0)) {
                    return new CultivateProcessGui(player.field_71071_by, cultivator);
                }
                return new CultivateGui(player.field_71071_by, cultivator);
            }
            if (tile instanceof FeederBlockEntity && id == 10) {
                return new FeederGui(player.field_71071_by, (IInventory)((FeederBlockEntity)tile));
            }
            if (tile instanceof BugCrateBlockEntity && id == 11) {
                return new BugCrateGui(player.field_71071_by, (BugCrateBlockEntity)tile);
            }
        }
        if (id == 12) {
            return new SkeletonAssemblyGui(SkeletonAssemblyGui.createContainer(player.field_71071_by, world, pos));
        }
        return null;
    }

    public static KeyBindingHandler getKeyHandler() {
        return keyHandler;
    }

    @Override
    public void openSelectDino(BlockPos pos, EnumFacing facing, EnumHand hand) {
        MC.func_147108_a((GuiScreen)new SelectDinoGui(pos, facing, hand));
    }

    @Override
    public void openOrder(DinosaurEntity entity) {
        MC.func_147108_a((GuiScreen)new OrderDinosaurGui(entity));
    }

    @Override
    public void openFieldGuide(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo fieldGuideInfo) {
        MC.func_147108_a((GuiScreen)new FieldGuideGui(entity, fieldGuideInfo));
    }

    @Override
    public void openPaleoDinosaurPad(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo guideInfo) {
        MC.func_147108_a((GuiScreen)new PaleoPadViewDinosaurGui(entity, guideInfo));
    }

    @Override
    public void openPaleoPad() {
        MC.func_147108_a((GuiScreen)new PaleoPadGui());
    }

    @Override
    public void openJournal(JournalItem.JournalType type) {
        MC.func_147108_a((GuiScreen)new JournalGui(type));
    }

    public static void playCarSound(VehicleEntity entity) {
        MC.func_147118_V().func_147682_a((ISound)new CarSound(entity));
    }

    public static void stopSound(ISound sound) {
        MC.func_147118_V().func_147683_b(sound);
    }

    public static void spawnVenomParticles(VenomEntity entity) {
        ParticleManager particleManager = ClientProxy.MC.field_71452_i;
        float size = 0.35f;
        for (int i = 0; i < 16; ++i) {
            particleManager.func_78873_a((Particle)new VenomParticle(entity.field_70170_p, (double)size * Math.random() - (double)(size / 2.0f), (double)size * Math.random() - (double)(size / 2.0f), (double)size * Math.random() - (double)(size / 2.0f), 0.0, 0.0, 0.0, 1.0f, entity));
        }
    }
}

