/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.render.entity;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import mod.reborn.client.model.TabulaModelUV;
import mod.reborn.client.model.animation.entity.vehicle.CarAnimator;
import mod.reborn.server.entity.ai.util.MathUtils;
import mod.reborn.server.entity.vehicle.HelicopterEntity;
import mod.reborn.server.entity.vehicle.VehicleEntity;
import mod.reborn.server.tabula.TabulaModelHelper;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class CarRenderer<E extends VehicleEntity>
extends Render<E> {
    private static final ResourceLocation[] DESTROY_STAGES = (ResourceLocation[])IntStream.range(0, 10).mapToObj(n -> new ResourceLocation(String.format("textures/blocks/destroy_stage_%d.png", n))).toArray(ResourceLocation[]::new);
    protected final String carName;
    protected CarAnimator animator;
    protected final ResourceLocation texture;
    protected TabulaModel baseModel;
    protected TabulaModel destroyModel;

    protected CarRenderer(RenderManager renderManager, String carName) {
        super(renderManager);
        this.carName = carName;
        this.animator = this.createCarAnimator();
        this.texture = new ResourceLocation("rebornmod", "textures/entities/" + carName + "/" + carName + ".png");
        try {
            TabulaModelContainer container = TabulaModelHelper.loadTabulaModel("/assets/rebornmod/models/entities/" + carName + "/" + carName + ".tbl");
            this.baseModel = new TabulaModel(container, (ITabulaModelAnimator)this.animator);
            this.destroyModel = new TabulaModel((TabulaModelContainer)new TabulaModelUV(container, 16, 16), (ITabulaModelAnimator)this.animator);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load car " + carName, e);
        }
    }

    public void doRender(E entity, double x, double y, double z, float yaw, float partialTicks) {
        this.animator.partialTicks = partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_180548_c((Entity)entity);
        this.renderModel(entity, x, y, z, yaw, partialTicks, false);
        int destroyStage = Math.min(10, (int)(10.0f - ((VehicleEntity)entity).getHealth() / 40.0f * 10.0f)) - 1;
        if (destroyStage >= 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
            GlStateManager.func_179088_q();
            RenderHelper.func_74518_a();
            this.func_110776_a(DESTROY_STAGES[destroyStage]);
            this.renderModel(entity, x, y, z, yaw, partialTicks, true);
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            RenderHelper.func_74519_b();
        }
        GlStateManager.func_179084_k();
        super.func_76986_a(entity, x, y, z, yaw, partialTicks);
    }

    protected void renderModel(E entity, double x, double y, double z, float yaw, float partialTicks, boolean destroy) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.25f), (float)((float)z));
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        this.doCarRotations((VehicleEntity)entity, partialTicks);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        (destroy ? this.destroyModel : this.baseModel).func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
    }

    protected void doCarRotations(VehicleEntity entity, float partialTicks) {
        if (!(entity instanceof HelicopterEntity)) {
            double backValue = entity.backValue.getValueForRendering(partialTicks);
            double frontValue = entity.frontValue.getValueForRendering(partialTicks);
            double leftValue = entity.leftValue.getValueForRendering(partialTicks);
            double rightValue = entity.rightValue.getValueForRendering(partialTicks);
            Vector4d vec = entity.getCarDimensions();
            Vector2d rot = entity.getBackWheelRotationPoint();
            GlStateManager.func_179137_b((double)0.0, (double)rot.x, (double)rot.y);
            float localRotationPitch = (float)MathUtils.cosineFromPoints(new Vec3d(frontValue, 0.0, vec.w), new Vec3d(backValue, 0.0, vec.w), new Vec3d(backValue, 0.0, vec.y));
            GlStateManager.func_179114_b((float)(frontValue < backValue ? -localRotationPitch : localRotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)(-rot.x), (double)(-rot.y));
            float localRotationRoll = (float)MathUtils.cosineFromPoints(new Vec3d(rightValue, 0.0, vec.z), new Vec3d(leftValue, 0.0, vec.z), new Vec3d(leftValue, 0.0, vec.x));
            GlStateManager.func_179114_b((float)(leftValue < rightValue ? localRotationRoll : -localRotationRoll), (float)0.0f, (float)0.0f, (float)1.0f);
            entity.pitch = frontValue < backValue ? localRotationPitch : -localRotationPitch;
            entity.roll = leftValue < rightValue ? localRotationRoll : -localRotationRoll;
        }
    }

    protected abstract CarAnimator createCarAnimator();

    @Nullable
    protected ResourceLocation getEntityTexture(E entity) {
        return this.texture;
    }
}

