/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.render.entity;

import java.awt.Color;
import java.util.Random;
import mod.reborn.client.render.entity.dinosaur.DinosaurRenderInfo;
import mod.reborn.server.dinosaur.Dinosaur;
import mod.reborn.server.entity.DinosaurEntity;
import mod.reborn.server.entity.GrowthStage;
import mod.reborn.server.entity.dinosaur.AllosaurusEntity;
import mod.reborn.server.entity.dinosaur.AnkylodocusEntity;
import mod.reborn.server.entity.dinosaur.AnkylosaurusEntity;
import mod.reborn.server.entity.dinosaur.ApatosaurusEntity;
import mod.reborn.server.entity.dinosaur.BaryonyxEntity;
import mod.reborn.server.entity.dinosaur.BrachiosaurusEntity;
import mod.reborn.server.entity.dinosaur.CamarasaurusEntity;
import mod.reborn.server.entity.dinosaur.CeratosaurusEntity;
import mod.reborn.server.entity.dinosaur.ChasmosaurusEntity;
import mod.reborn.server.entity.dinosaur.CompsognathusEntity;
import mod.reborn.server.entity.dinosaur.DeinotheriumEntity;
import mod.reborn.server.entity.dinosaur.DiplodocusEntity;
import mod.reborn.server.entity.dinosaur.IndoraptorEntity;
import mod.reborn.server.entity.dinosaur.MammothEntity;
import mod.reborn.server.entity.dinosaur.MicroceratusEntity;
import mod.reborn.server.entity.dinosaur.OviraptorEntity;
import mod.reborn.server.entity.dinosaur.ParaceratheriumEntity;
import mod.reborn.server.entity.dinosaur.ParasaurolophusEntity;
import mod.reborn.server.entity.dinosaur.ProtoceratopsEntity;
import mod.reborn.server.entity.dinosaur.SinoceratopsEntity;
import mod.reborn.server.entity.dinosaur.SmilodonEntity;
import mod.reborn.server.entity.dinosaur.SpinoraptorEntity;
import mod.reborn.server.entity.dinosaur.StyracosaurusEntity;
import mod.reborn.server.entity.dinosaur.TitanisEntity;
import mod.reborn.server.entity.dinosaur.TriceratopsEntity;
import mod.reborn.server.entity.dinosaur.VectipeltaEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DinosaurRenderer
extends RenderLiving<DinosaurEntity> {
    public Dinosaur dinosaur;
    public DinosaurRenderInfo renderInfo;
    public Random random;

    public DinosaurRenderer(DinosaurRenderInfo renderInfo, RenderManager renderManager) {
        super(renderManager, null, renderInfo.getShadowSize());
        this.dinosaur = renderInfo.getDinosaur();
        this.random = new Random();
        this.renderInfo = renderInfo;
        this.func_177094_a(new LayerEyelid(this));
    }

    public void preRenderCallback(DinosaurEntity entity, float partialTick) {
        String name;
        float scaleModifier = entity.getAttributes().getScaleModifier();
        float scale = (float)entity.interpolate(this.dinosaur.getScaleInfant(), this.dinosaur.getScaleAdult()) * scaleModifier;
        this.field_76989_e = scale * this.renderInfo.getShadowSize();
        GlStateManager.func_179109_b((float)(this.dinosaur.getOffsetX() * scale), (float)(this.dinosaur.getOffsetY() * scale), (float)(this.dinosaur.getOffsetZ() * scale));
        switch (name = entity.func_95999_t()) {
            case "JTGhawk137": {
                GlStateManager.func_179152_a((float)0.1f, (float)scale, (float)scale);
                break;
            }
            case "Gegy": {
                GlStateManager.func_179152_a((float)scale, (float)0.01f, (float)scale);
                break;
            }
            case "Destruction": {
                GlStateManager.func_179139_a((double)((double)scale * 1.2), (double)((double)scale * 1.2), (double)((double)scale * 1.2));
                break;
            }
            case "Wyn": {
                GlStateManager.func_179139_a((double)((double)scale * 1.3), (double)((double)scale * 1.3), (double)((double)scale * 1.3));
                break;
            }
            case "Notch": {
                GlStateManager.func_179152_a((float)(scale * 2.0f), (float)(scale * 2.0f), (float)(scale * 2.0f));
                break;
            }
            case "jglrxavpok": {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)(scale * -1.0f));
                break;
            }
            case "Vitiate": {
                int color = Color.HSBtoRGB((float)(entity.field_70170_p.func_82737_E() % 1000L) / 100.0f, 1.0f, 1.0f);
                GlStateManager.func_179124_c((float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color >> 16 & 0xFF) / 255.0f));
                break;
            }
            case "VPFbGsfp5QR3WsLXM4JBDJXMG": {
                GlStateManager.func_179152_a((float)(scale * (float)this.random.nextInt(69)), (float)(scale * (float)this.random.nextInt(69)), (float)(scale * (float)this.random.nextInt(69)));
                break;
            }
            case "WIDE": {
                GlStateManager.func_179152_a((float)(scale * 5.0f), (float)(scale * 0.5f), (float)(scale * 0.5f));
                break;
            }
            default: {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            }
        }
    }

    public void doRender(DinosaurEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = this.renderInfo.getModel(entity.getGrowthStage(), entity.getSkeletonVariant());
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    public ResourceLocation getEntityTexture(DinosaurEntity entity) {
        GrowthStage growthStage = entity.getGrowthStage();
        if (!this.dinosaur.doesSupportGrowthStage(growthStage)) {
            growthStage = GrowthStage.ADULT;
        }
        if (entity instanceof MammothEntity && !entity.isSkeleton()) {
            return ((MammothEntity)entity).getTexture();
        }
        if (entity instanceof CompsognathusEntity && !entity.isSkeleton()) {
            return ((CompsognathusEntity)entity).getTexture();
        }
        if (entity instanceof AllosaurusEntity && !entity.isSkeleton()) {
            return ((AllosaurusEntity)entity).getTexture();
        }
        if (entity instanceof ParasaurolophusEntity && !entity.isSkeleton()) {
            return ((ParasaurolophusEntity)entity).getTexture();
        }
        if (entity instanceof DeinotheriumEntity && !entity.isSkeleton()) {
            return ((DeinotheriumEntity)entity).getTexture();
        }
        if (entity instanceof SmilodonEntity && !entity.isSkeleton()) {
            return ((SmilodonEntity)entity).getTexture();
        }
        if (entity instanceof TitanisEntity && !entity.isSkeleton()) {
            return ((TitanisEntity)entity).getTexture();
        }
        if (entity instanceof CeratosaurusEntity && !entity.isSkeleton()) {
            return ((CeratosaurusEntity)entity).getTexture();
        }
        if (entity instanceof SpinoraptorEntity && !entity.isSkeleton()) {
            return ((SpinoraptorEntity)entity).getTexture();
        }
        if (entity instanceof IndoraptorEntity && !entity.isSkeleton()) {
            return ((IndoraptorEntity)entity).getTexture();
        }
        if (entity instanceof BaryonyxEntity && !entity.isSkeleton()) {
            return ((BaryonyxEntity)entity).getTexture();
        }
        if (entity instanceof DiplodocusEntity && !entity.isSkeleton()) {
            return ((DiplodocusEntity)entity).getTexture();
        }
        if (entity instanceof AnkylodocusEntity && !entity.isSkeleton()) {
            return ((AnkylodocusEntity)entity).getTexture();
        }
        if (entity instanceof CamarasaurusEntity && !entity.isSkeleton()) {
            return ((CamarasaurusEntity)entity).getTexture();
        }
        if (entity instanceof BrachiosaurusEntity && !entity.isSkeleton()) {
            return ((BrachiosaurusEntity)entity).getTexture();
        }
        if (entity instanceof AnkylosaurusEntity && !entity.isSkeleton()) {
            return ((AnkylosaurusEntity)entity).getTexture();
        }
        if (entity instanceof ApatosaurusEntity && !entity.isSkeleton()) {
            return ((ApatosaurusEntity)entity).getTexture();
        }
        if (entity instanceof OviraptorEntity && !entity.isSkeleton()) {
            return ((OviraptorEntity)entity).getTexture();
        }
        if (entity instanceof ChasmosaurusEntity && !entity.isSkeleton()) {
            return ((ChasmosaurusEntity)entity).getTexture();
        }
        if (entity instanceof StyracosaurusEntity && !entity.isSkeleton()) {
            return ((StyracosaurusEntity)entity).getTexture();
        }
        if (entity instanceof SinoceratopsEntity && !entity.isSkeleton()) {
            return ((SinoceratopsEntity)entity).getTexture();
        }
        if (entity instanceof TriceratopsEntity && !entity.isSkeleton()) {
            return ((TriceratopsEntity)entity).getTexture();
        }
        if (entity instanceof MicroceratusEntity && !entity.isSkeleton()) {
            return ((MicroceratusEntity)entity).getTexture();
        }
        if (entity instanceof ProtoceratopsEntity && !entity.isSkeleton()) {
            return ((ProtoceratopsEntity)entity).getTexture();
        }
        if (entity instanceof VectipeltaEntity && !entity.isSkeleton()) {
            return ((VectipeltaEntity)entity).getTexture();
        }
        if (entity instanceof ParaceratheriumEntity && !entity.isSkeleton()) {
            return ((ParaceratheriumEntity)entity).getTexture();
        }
        return entity.isMale() ? this.dinosaur.getMaleTexture(growthStage) : this.dinosaur.getFemaleTexture(growthStage);
    }

    protected void applyRotations(DinosaurEntity entity, float p_77043_2_, float p_77043_3_, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerEyelid
    implements LayerRenderer<DinosaurEntity> {
        private final DinosaurRenderer renderer;

        public LayerEyelid(DinosaurRenderer renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(DinosaurEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float yaw, float pitch, float scale) {
            ITextureObject textureObject;
            ResourceLocation texture;
            if (!entity.func_82150_aj() && entity.areEyelidsClosed() && (texture = this.renderer.dinosaur.getEyelidTexture(entity)) != null && (textureObject = Minecraft.func_71410_x().func_110434_K().func_110581_b(texture)) != TextureUtil.field_111001_a) {
                this.renderer.func_110776_a(texture);
                this.renderer.func_177087_b().func_78088_a((Entity)entity, limbSwing, limbSwingAmount, age, yaw, pitch, scale);
                this.renderer.func_177105_a((EntityLiving)entity);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

