/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.render.entity;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Locale;
import mod.reborn.client.model.AnimatableModel;
import mod.reborn.client.model.animation.entity.GoatAnimator;
import mod.reborn.server.entity.animal.GoatEntity;
import mod.reborn.server.tabula.TabulaModelHelper;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GoatRenderer
extends RenderLiving<GoatEntity> {
    private static final EnumMap<GoatEntity.Variant, ResourceLocation> KID_TEXTURE = new EnumMap(GoatEntity.Variant.class);
    private static final EnumMap<GoatEntity.Variant, ResourceLocation> BILLY_TEXTURE = new EnumMap(GoatEntity.Variant.class);
    private static final EnumMap<GoatEntity.Variant, ResourceLocation> NANNY_TEXTURE = new EnumMap(GoatEntity.Variant.class);
    private static final AnimatableModel KID_MODEL;
    private static final AnimatableModel BILLY_MODEL;
    private static final AnimatableModel NANNY_MODEL;

    public GoatRenderer(RenderManager renderManager) {
        super(renderManager, (ModelBase)BILLY_MODEL, 0.4f);
    }

    public void preRenderCallback(GoatEntity entity, float partialTick) {
        float scale = entity.func_70631_g_() ? 0.2f : 0.47f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    public void doRender(GoatEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GoatEntity.Type type = entity.getType();
        this.field_77045_g = type == GoatEntity.Type.KID ? KID_MODEL : (type == GoatEntity.Type.BILLY ? BILLY_MODEL : NANNY_MODEL);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    public ResourceLocation getEntityTexture(GoatEntity entity) {
        GoatEntity.Type type = entity.getType();
        if (type == GoatEntity.Type.KID) {
            return KID_TEXTURE.get((Object)entity.getVariant());
        }
        if (type == GoatEntity.Type.BILLY) {
            return BILLY_TEXTURE.get((Object)entity.getVariant());
        }
        return NANNY_TEXTURE.get((Object)entity.getVariant());
    }

    static {
        TabulaModelContainer kid = null;
        TabulaModelContainer billy = null;
        TabulaModelContainer nanny = null;
        try {
            kid = TabulaModelHelper.loadTabulaModel("assets/rebornmod/models/entities/goat_kid/adult/goat_kid");
            billy = TabulaModelHelper.loadTabulaModel("assets/rebornmod/models/entities/goat_billy/adult/goat_billy");
            nanny = TabulaModelHelper.loadTabulaModel("assets/rebornmod/models/entities/goat_nanny/adult/goat_nanny");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        KID_MODEL = new AnimatableModel(kid, new GoatAnimator());
        BILLY_MODEL = new AnimatableModel(billy, new GoatAnimator());
        NANNY_MODEL = new AnimatableModel(nanny, new GoatAnimator());
        for (GoatEntity.Variant variant : GoatEntity.Variant.values()) {
            String name = variant.name().toLowerCase(Locale.ENGLISH);
            KID_TEXTURE.put(variant, new ResourceLocation("rebornmod", "textures/entities/goat/kid_" + name + ".png"));
            NANNY_TEXTURE.put(variant, new ResourceLocation("rebornmod", "textures/entities/goat/nanny_" + name + ".png"));
            BILLY_TEXTURE.put(variant, new ResourceLocation("rebornmod", "textures/entities/goat/billy_" + name + ".png"));
        }
    }
}

