/*
 * Decompiled with CFR 0.152.
 */
package mod.reborn.client.render.entity;

import java.util.HashMap;
import java.util.Map;
import mod.reborn.server.entity.item.MuralEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MuralRenderer
extends Render<MuralEntity> {
    private static Map<MuralEntity.Type, Integer> DISPLAY_LIST = new HashMap<MuralEntity.Type, Integer>();

    public MuralRenderer(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(MuralEntity entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179129_p();
        MuralEntity.Type type = entity.type;
        this.func_110776_a(type.texture);
        float scale = 0.0625f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        Integer displayList = DISPLAY_LIST.get((Object)type);
        if (displayList != null) {
            GlStateManager.func_179148_o((int)displayList);
        } else {
            displayList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)displayList, (int)4864);
            this.renderLayer(entity, entity.func_82329_d(), entity.func_82330_g(), type.sizeX, type.sizeY);
            GlStateManager.func_187415_K();
            DISPLAY_LIST.put(type, displayList);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, yaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(MuralEntity entity) {
        return entity.type.texture;
    }

    private void renderLayer(MuralEntity entity, int width, int height, int textureWidth, int textureHeight) {
        float centerWidth = (float)(-textureWidth) / 2.0f;
        float centerHeight = (float)(-textureHeight) / 2.0f;
        float pixelSize = 0.0625f;
        float depth = 1.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-depth + 0.5f));
        int x = 0;
        while ((float)x < (float)textureWidth * pixelSize) {
            int y = 0;
            while ((float)y < (float)textureHeight * pixelSize) {
                float i;
                float maxX = centerWidth + (float)(x + 1) / pixelSize;
                float minX = centerWidth + (float)x / pixelSize;
                float maxY = (float)(-textureHeight) + (float)(y + 1) / pixelSize;
                float minY = (float)(-textureHeight) + (float)y / pixelSize;
                this.setLightmap(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                float maxTextureX = ((float)textureWidth - (float)x / pixelSize) / (float)textureWidth;
                float minTextureX = ((float)textureWidth - (float)(x + 1) / pixelSize) / (float)textureWidth;
                float maxTextureY = ((float)textureHeight - (float)y / pixelSize) / (float)textureHeight;
                float minTextureY = ((float)textureHeight - (float)(y + 1) / pixelSize) / (float)textureHeight;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                buffer.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a((double)minTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a((double)maxTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a((double)maxTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)minTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)maxX, (double)minY, (double)depth).func_187315_a((double)minTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)minY, (double)depth).func_187315_a((double)maxTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)maxY, (double)depth).func_187315_a((double)maxTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)maxX, (double)maxY, (double)depth).func_187315_a((double)minTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                tessellator.func_78381_a();
                for (i = minX; i < maxX; i += 1.0f) {
                    maxTextureX = (centerWidth - i) / (float)textureWidth;
                    minTextureX = (centerWidth - (i + pixelSize)) / (float)textureWidth;
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    buffer.func_181662_b((double)i, (double)minY, 0.0).func_187315_a((double)maxTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)i, (double)minY, (double)depth).func_187315_a((double)maxTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)i, (double)maxY, (double)depth).func_187315_a((double)minTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)i, (double)maxY, 0.0).func_187315_a((double)minTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    tessellator.func_78381_a();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    buffer.func_181662_b((double)(i + 1.0f), (double)minY, 0.0).func_187315_a((double)maxTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)(i + 1.0f), (double)minY, (double)depth).func_187315_a((double)maxTextureX, (double)maxTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)(i + 1.0f), (double)maxY, (double)depth).func_187315_a((double)minTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)(i + 1.0f), (double)maxY, 0.0).func_187315_a((double)minTextureX, (double)minTextureY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    tessellator.func_78381_a();
                }
                maxTextureX = ((float)textureWidth - (float)x / pixelSize) / (float)textureWidth;
                minTextureX = ((float)textureWidth - (float)(x + 1) / pixelSize) / (float)textureWidth;
                for (i = minY; i < maxY; i += 1.0f) {
                    maxTextureY = (centerHeight - i) / (float)textureHeight;
                    minTextureY = (centerHeight - (i + pixelSize)) / (float)textureHeight;
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    buffer.func_181662_b((double)minX, (double)i, 0.0).func_187315_a((double)maxTextureX, (double)(maxTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)i, (double)depth).func_187315_a((double)maxTextureX, (double)(minTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)i, (double)depth).func_187315_a((double)minTextureX, (double)(minTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)i, 0.0).func_187315_a((double)minTextureX, (double)(maxTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    tessellator.func_78381_a();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    buffer.func_181662_b((double)minX, (double)(i + 1.0f), 0.0).func_187315_a((double)maxTextureX, (double)(maxTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)(i + 1.0f), (double)depth).func_187315_a((double)maxTextureX, (double)(minTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)(i + 1.0f), (double)depth).func_187315_a((double)minTextureX, (double)(minTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)(i + 1.0f), 0.0).func_187315_a((double)minTextureX, (double)(maxTextureY + 0.5f)).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    tessellator.func_78381_a();
                }
                ++y;
            }
            ++x;
        }
    }

    private void setLightmap(MuralEntity sign, float xzOffset, float yOffset) {
        int posX = MathHelper.func_76128_c((double)sign.field_70165_t);
        int posY = MathHelper.func_76128_c((double)(sign.field_70163_u + (double)(yOffset / 16.0f)));
        int posZ = MathHelper.func_76128_c((double)sign.field_70161_v);
        EnumFacing direction = sign.field_174860_b;
        if (direction == EnumFacing.NORTH) {
            posX = MathHelper.func_76128_c((double)(sign.field_70165_t + (double)(xzOffset / 16.0f)));
        } else if (direction == EnumFacing.WEST) {
            posZ = MathHelper.func_76128_c((double)(sign.field_70161_v - (double)(xzOffset / 16.0f)));
        } else if (direction == EnumFacing.SOUTH) {
            posX = MathHelper.func_76128_c((double)(sign.field_70165_t - (double)(xzOffset / 16.0f)));
        } else if (direction == EnumFacing.EAST) {
            posZ = MathHelper.func_76128_c((double)(sign.field_70161_v + (double)(xzOffset / 16.0f)));
        }
        int combinedLight = this.field_76990_c.field_78722_g.func_175626_b(new BlockPos(posX, posY, posZ), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(combinedLight % 65536), (float)((float)combinedLight / 65536.0f));
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

